/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ReadScopeWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class ReadScopeFunction<T extends AbstractWrapper>
extends SlowFunction<T, ReadScopeWrapper> {
    public ReadScopeFunction(ISetWithListeners<T> domain, IOperationRunner runner) {
        super(domain, runner, Display.getCurrent(), true);
    }

    protected abstract Map<T, IReadScope> getReadScopes(Collection<T> var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected Map<T, ReadScopeWrapper> doFetch(Collection<T> toFetch, IProgressMonitor monitor) throws OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap result = NewCollection.hashMap();
        HashMap contextMap = NewCollection.hashMap();
        ArrayList contextHandles = NewCollection.arrayList();
        ArrayList accessGroupHandles = NewCollection.arrayList();
        try {
            ItemLocator locator;
            Map<T, IReadScope> scopeMap = this.getReadScopes(toFetch, (IProgressMonitor)progress.newChild(25));
            for (AbstractWrapper next : toFetch) {
                IReadScope scope = scopeMap.get((Object)next);
                locator = this.getContext(scope, next.getRepository());
                if (locator != null) {
                    if (IAccessGroup.ITEM_TYPE.equals(locator.getItemType())) {
                        accessGroupHandles.add(locator);
                    } else {
                        contextHandles.add(locator);
                    }
                    contextMap.put(next, locator);
                    continue;
                }
                result.put(next, ReadScopeWrapper.newWrapper(scope));
            }
            progress.setWorkRemaining(contextHandles.size() + accessGroupHandles.size());
            HashMap fetchedContexts = NewCollection.hashMap();
            if (!contextHandles.isEmpty()) {
                fetchedContexts.putAll(ItemFetcher.fetchCurrents((Collection)contextHandles, (boolean)false, (IProgressMonitor)progress.newChild(contextHandles.size())));
            }
            if (!accessGroupHandles.isEmpty()) {
                fetchedContexts.putAll(this.fetchAccessGroups(accessGroupHandles, (IProgressMonitor)progress.newChild(accessGroupHandles.size())));
            }
            for (AbstractWrapper next : toFetch) {
                locator = (ItemLocator)contextMap.get((Object)next);
                if (locator == null) continue;
                IReadScope scope = scopeMap.get((Object)next);
                IAuditable context = (IAuditable)fetchedContexts.get(locator);
                ReadScopeWrapper wrapper = ReadScopeWrapper.newWrapper(scope, context);
                result.put(next, wrapper);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    protected String getOperationName() {
        return Messages.ReadScopeFunction_operationName;
    }

    protected ReadScopeWrapper getDefaultValue() {
        return null;
    }

    protected Map<ItemLocator<IAuditable>, IAuditable> fetchAccessGroups(Collection<ItemLocator<IAuditable>> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap fetched = NewCollection.hashMap();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Map byNamespace = ItemLocator.groupByNamespace(handles);
        progress.setWorkRemaining(byNamespace.size());
        HashMap results = NewCollection.hashMap();
        for (Map.Entry next : byNamespace.entrySet()) {
            ITeamRepository repo = ((ItemNamespace)next.getKey()).getRepository();
            IAccessGroupClientService accessGroupService = (IAccessGroupClientService)repo.getClientLibrary(IAccessGroupClientService.class);
            SubMonitor namespaceProgress = progress.newChild(1).setWorkRemaining(((List)next.getValue()).size());
            for (ItemId accessGroupHandle : (List)next.getValue()) {
                IAccessGroup group = (IAccessGroup)fetched.get(accessGroupHandle.getItemUUID());
                if (group == null) {
                    group = accessGroupService.getAccessGroupForGroupContextId(accessGroupHandle.getItemUUID(), (IProgressMonitor)namespaceProgress.newChild(1));
                    fetched.put(group.getGroupContextId(), group);
                }
                ItemId id = new ItemId(IAccessGroup.ITEM_TYPE, group.getGroupContextId());
                ItemLocator locator = ItemLocator.create((ItemNamespace)((ItemNamespace)next.getKey()), (ItemId)id);
                results.put(locator, group);
            }
        }
        return results;
    }

    protected ItemLocator<IAuditable> getContext(IReadScope scope, ITeamRepository repository) {
        IAuditableHandle context = null;
        if (scope instanceof IContributorDeferringScope) {
            context = ((IContributorDeferringScope)scope).getScope();
        } else if (scope instanceof IProcessAreaScope) {
            context = ((IProcessAreaScope)scope).getProcessArea();
        } else if (scope instanceof AccessGroupScope) {
            context = ((AccessGroupScope)scope).getAccessGroup();
        } else if (scope instanceof ITeamAreaPrivateScope) {
            context = ((ITeamAreaPrivateScope)scope).getTeamArea();
        }
        if (context != null) {
            return new ItemLocator(repository, context);
        }
        return null;
    }
}

