/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.OwnerSearchQuery;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PlaceSearchQuery
extends OwnerSearchQuery<AbstractPlaceWrapper> {
    private PlaceSearchCriteria searchCriteria;
    private Set<ItemId<? extends IAuditable>> cachedOwners = Collections.EMPTY_SET;
    private boolean supportsDynamicUpdate = false;
    private long counter = 0L;
    private FilteredFetcher placeFetcher;
    private boolean allowFolderActions = false;
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> listener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        public void changed(FilteredFetcher source, List<ItemChangeEvent> property) {
            Realm realm = PlaceSearchQuery.this.getRealm();
            if (realm == null) {
                return;
            }
            final long timestamp = PlaceSearchQuery.this.counter;
            final HashSet<IWorkspace> added = new HashSet<IWorkspace>();
            final HashSet<IWorkspace> removed = new HashSet<IWorkspace>();
            for (ItemChangeEvent event : property) {
                boolean beforeWasIncluded = PlaceSearchQuery.this.passesFilter(event.getBeforeState());
                boolean afterWasIncluded = PlaceSearchQuery.this.passesFilter(event.getAfterState());
                if (beforeWasIncluded && !afterWasIncluded) {
                    IWorkspace toRemove = (IWorkspace)event.getSharedItem();
                    removed.add(toRemove);
                    added.remove(toRemove);
                }
                if (!afterWasIncluded || beforeWasIncluded) continue;
                IWorkspace toAdd = (IWorkspace)event.getSharedItem();
                added.add(toAdd);
                removed.remove(toAdd);
            }
            if (added.isEmpty() && removed.isEmpty()) {
                return;
            }
            SWTUtil.greedyExec((Realm)realm, (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PlaceSearchQuery placeSearchQuery = PlaceSearchQuery.this;
                    synchronized (placeSearchQuery) {
                        if (PlaceSearchQuery.this.counter != timestamp) {
                            return;
                        }
                        if (PlaceSearchQuery.this.getRealm() == null) {
                            return;
                        }
                    }
                    if (PlaceSearchQuery.this.supportsDynamicUpdate) {
                        PlaceSearchQuery.this.addElements(WorkspaceUtil.itemsToWrappers(PlaceSearchQuery.this.getRepository(), added, PlaceSearchQuery.this.allowFolderActions));
                    } else {
                        PlaceSearchQuery.this.setStale(true);
                    }
                    PlaceSearchQuery.this.removeElements(WorkspaceUtil.itemsToWrappers(PlaceSearchQuery.this.getRepository(), removed, PlaceSearchQuery.this.allowFolderActions));
                }
            });
        }
    };

    public PlaceSearchQuery(ITeamRepository repository, IOperationRunner runner, PlaceSearchCriteria searchCriteria) {
        this(repository, runner, searchCriteria, null);
    }

    public PlaceSearchQuery(ITeamRepository repository, IOperationRunner runner, PlaceSearchCriteria searchCriteria, IConnectedProjectAreaRegistry registry) {
        super(Realm.getDefault(), repository, runner, searchCriteria.getOwnedBy(), registry);
        this.placeFetcher = new FilteredFetcher(repository);
        this.searchCriteria = searchCriteria;
    }

    public void setAllowFolderActions(boolean allowFolderActions) {
        this.allowFolderActions = allowFolderActions;
    }

    public void setSupportDynamicUpdate(boolean supportsDynamicUpdate) {
        this.supportsDynamicUpdate = supportsDynamicUpdate;
    }

    @Override
    protected void attachListeners() {
        super.attachListeners();
        this.placeFetcher.addListener(this.searchCriteria.getItemType(), this.listener);
    }

    @Override
    protected void detachListeners() {
        this.placeFetcher.removeListener(this.searchCriteria.getItemType(), this.listener);
        super.detachListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkspaceSearchCriteria constructExpression(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceSearchCriteria searchCriteriaDTO = PlaceSearchCriteria.asSearchCriteriaDTO(this.searchCriteria);
        Set<ItemId<IAuditable>> owners = this.computeOwners(needsRefresh, (IProgressMonitor)progress);
        PlaceSearchQuery placeSearchQuery = this;
        synchronized (placeSearchQuery) {
            this.cachedOwners = owners;
        }
        if (owners.size() > 0) {
            searchCriteriaDTO.getFilterByOwnerOptional().clear();
            for (ItemId<IAuditable> owner : owners) {
                IAuditableHandle auditableHandle = (IAuditableHandle)owner.toHandle();
                if (auditableHandle == null) continue;
                searchCriteriaDTO.getFilterByOwnerOptional().add(auditableHandle);
            }
        }
        return searchCriteriaDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceSearchCriteria query = this.constructExpression(needsRefresh, (IProgressMonitor)progress.newChild(10));
        if (this.cachedOwners != null && this.cachedOwners.isEmpty() && this.cachedOwners != ALL_OWNERS) {
            return Collections.emptyList();
        }
        List workspaces = Collections.emptyList();
        try {
            List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).findWorkspaces(query, this.searchCriteria.getMaxResults(), (IProgressMonitor)progress.newChild(40));
            int fetchFlag = needsRefresh ? 1 : 0;
            workspaces = this.getRepository().itemManager().fetchCompleteItems(handles, fetchFlag, (IProgressMonitor)progress.newChild(40));
        }
        catch (TeamRepositoryException e) {
            LoggingHelper.log((String)"com.ibm.team.filesystem.ide.ui", (TeamRepositoryException)e);
            return Collections.emptyList();
        }
        PlaceSearchQuery placeSearchQuery = this;
        synchronized (placeSearchQuery) {
            ++this.counter;
        }
        return WorkspaceUtil.itemsToWrappers(this.getRepository(), workspaces, this.allowFolderActions);
    }

    public String getName() {
        return Messages.PlaceSearchQuery_queryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passesFilter(Object toTest) {
        if (toTest instanceof IWorkspace) {
            ItemId loggedInContributor;
            Set<ItemId<? extends IAuditable>> owners;
            Pattern pattern;
            IWorkspace workspace = (IWorkspace)toTest;
            String nameContains = this.searchCriteria.getNameOrPattern();
            if (nameContains != null && !nameContains.equals("") && !(pattern = this.searchCriteria.isIgnoreCase() ? Pattern.compile(WorkspaceUtil.convertToRegex(nameContains, false, true), 2) : Pattern.compile(WorkspaceUtil.convertToRegex(nameContains, false, true))).matcher(workspace.getName()).matches()) {
                return false;
            }
            PlaceSearchQuery placeSearchQuery = this;
            synchronized (placeSearchQuery) {
                owners = this.cachedOwners;
            }
            ItemId<? extends IAuditable> ownedBy = this.searchCriteria.getOwnedBy();
            if (ownedBy == OwnerSearchQuery.CURRENT_CONTRIBUTOR ? !(loggedInContributor = ItemUtil.getContributor((IContributor)this.getRepository().loggedInContributor())).equals((Object)ItemId.create((IItemHandle)workspace.getOwner())) : (ownedBy.isNull() ? !(loggedInContributor = ItemUtil.getContributor((IContributor)this.getRepository().loggedInContributor())).equals((Object)ItemId.create((IItemHandle)workspace.getOwner())) && workspace.getReadScope() instanceof IPrivateScope : !owners.contains(ItemUtil.getOwner((IWorkspace)workspace)))) {
                return false;
            }
            Object type = this.searchCriteria.getType();
            if (type != PlaceSearchCriteria.TYPE_ANY) {
                if (type == PlaceSearchCriteria.TYPE_STREAM && !workspace.isStream()) {
                    return false;
                }
                if (type == PlaceSearchCriteria.TYPE_WORKSPACE && workspace.isStream()) {
                    return false;
                }
            }
            Map customAttributesOnWS = workspace.getCustomAttributes();
            if (this.searchCriteria.getCustomAttributesArray() != null) {
                Object[] objectArray = this.searchCriteria.getCustomAttributesArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CustomAttributeEntry entry;
                    Object value;
                    Object object = objectArray[n2];
                    if (object instanceof CustomAttributeEntry && ((value = customAttributesOnWS.get((entry = (CustomAttributeEntry)object).getName())) == null || !value.equals(entry.getValue()))) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }
}

