/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForStreamQueryEditor;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ComponentCombo;
import com.ibm.team.internal.filesystem.ui.picker.OwnerSelectionField;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.wizards.component.BaselineSelectionPage;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.RadioAction;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class PlaceSearchCriteriaPart
extends AbstractSearchCriteriaPart<PlaceSearchCriteria> {
    PlaceSearchCriteria fInput;
    private Text fNameOrPatternText;
    private Button fIgnoreCaseButton;
    private ComponentCombo fComponentCombo;
    private TableViewer fBaselineTableViewer;
    private Set<Object> fBaselineTableViewerInput = new HashSet<Object>();
    private Button fAddBaselinesButton;
    private Button fRemoveBaselinesButton;
    private WritableValue searchType = new WritableValue(PlaceSearchCriteria.TYPE_ANY);
    private org.eclipse.core.databinding.observable.value.WritableValue searchValidation = new org.eclipse.core.databinding.observable.value.WritableValue((Object)Status.OK_STATUS, IStatus.class);
    private CustomAttributeSectionForStreamQueryEditor customAttributeSectionForQueryEditor;
    private IChangeListener listener;

    public PlaceSearchCriteriaPart(IControlSite site, PlaceSearchCriteria input) {
        super(site, input);
        this.fInput = input;
        WidgetFactoryContext context = site.getContext();
        MnemonicGenerator mnemonics = new MnemonicGenerator((IMnemonicGenerationAlgorithm)site.getMnemonicGenerator());
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        this.createRepoLabel(parent, context);
        this.createRepositoryCombo(parent, (Preferences)this.getConfigPrefs(), context);
        toolkit.createLabel(parent, mnemonics.generate(Messages.PlaceSearchCriteriaPart_workspaceNameFieldLabel));
        this.fNameOrPatternText = toolkit.createText(parent, "");
        String inputNameOrPattern = input.getNameOrPattern();
        if (inputNameOrPattern != null) {
            this.fNameOrPatternText.setText(inputNameOrPattern);
        }
        this.fNameOrPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PlaceSearchCriteriaPart.this.updateValidation();
                PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        new Label(parent, 0);
        this.fIgnoreCaseButton = toolkit.createButton(parent, Messages.PlaceSearchCriteriaPart_IgnoreCaseButton, 32);
        this.fIgnoreCaseButton.setSelection(input.isIgnoreCase());
        this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlaceSearchCriteriaPart.this.updateValidation();
                PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        this.createOwnerLabel(parent, context, Messages.PlaceSearchCriteriaPart_ownedByComboLabel);
        this.createOwnerCombo(parent, context, 15);
        this.createComponentLabel(Messages.PlaceSearchCriteriaPart_HasComponentLabel, parent, context);
        this.fComponentCombo = this.createComponentCombo(parent, context, 1);
        if (input.getRepository() != null && input.getComponentHandle() != null) {
            this.fComponentCombo.setSelectedComponent(input.getRepository(), (ItemId<IComponent>)new ItemId((IItemHandle)input.getComponentHandle()));
        }
        this.createBaselineWidgets(context, parent);
        Group searchFor = new Group(parent, 0);
        searchFor.setText(Messages.PlaceSearchCriteriaPart_searchForGroup);
        this.searchType.setValue(input.getType());
        ToolkitUtil.createButton((WidgetToolkit)toolkit, (MnemonicGenerator)mnemonics, (Composite)searchFor, (IActionExt)new RadioAction(Messages.PlaceSearchCriteriaPart_workspacesRadio, PlaceSearchCriteria.TYPE_WORKSPACE, this.searchType));
        ToolkitUtil.createButton((WidgetToolkit)toolkit, (MnemonicGenerator)mnemonics, (Composite)searchFor, (IActionExt)new RadioAction(Messages.PlaceSearchCriteriaPart_streamsRadio, PlaceSearchCriteria.TYPE_STREAM, this.searchType));
        ToolkitUtil.createButton((WidgetToolkit)toolkit, (MnemonicGenerator)mnemonics, (Composite)searchFor, (IActionExt)new RadioAction(Messages.PlaceSearchCriteriaPart_allOfTheAboveRadio, PlaceSearchCriteria.TYPE_ANY, this.searchType));
        Dialog.applyDialogFont((Control)searchFor);
        GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)searchFor);
        GridDataFactory.generate((Control)searchFor, (int)2, (int)1);
        this.searchType.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                PlaceSearchCriteriaPart.this.updateValidation();
                PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        this.createCustomAttributeFilter(parent, toolkit, input);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
        this.initialize(input.getRepository(), null, null, input.getOwnedBy(), null);
        this.getValidationStatus().addStatus((IObservableValue)this.searchValidation);
        this.updateValidation();
    }

    private void createBaselineWidgets(final WidgetFactoryContext context, Composite parent) {
        Label baselinesLabel = new Label(parent, 0);
        baselinesLabel.setText(Messages.PlaceSearchCriteriaPart_hasBaselinesLabel);
        GridDataFactory.defaultsFor((Control)baselinesLabel).grab(false, false).align(4, 128).applyTo((Control)baselinesLabel);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.fBaselineTableViewer = new TableViewer(composite, 2820);
        this.fBaselineTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBaselineTableViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof String) {
                    label.setText((String)element);
                    label.setImage(null);
                } else {
                    super.updateLabel(label, element);
                }
            }
        });
        this.fBaselineTableViewer.setSorter(new ViewerSorter());
        this.fBaselineTableViewer.setInput(this.fBaselineTableViewerInput);
        this.fBaselineTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlaceSearchCriteriaPart.this.updateBaselineWidgets();
            }
        });
        final Display display = parent.getDisplay();
        final ITeamRepository repo = this.fInput.getRepository();
        final IComponentHandle component = this.fInput.getComponentHandle();
        final Map<UUID, IBaselineHandle> baselines = this.fInput.getBaselines();
        if (repo != null && component != null && baselines != null && !baselines.isEmpty()) {
            context.getUserOperationRunner().enqueue(Messages.PlaceSearchCriteriaPart_FetchingBaselinesJobName, (Operation)new RepositoryOperation(repo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    ArrayList<Object> itemsToFetch = new ArrayList<Object>(1 + baselines.size());
                    itemsToFetch.add(component);
                    itemsToFetch.addAll(baselines.values());
                    IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(itemsToFetch, 0, monitor);
                    final HashSet<BaselineWrapper> baselineWrappers = new HashSet<BaselineWrapper>(fetchResult.getRetrievedItems().size());
                    IComponent component2 = null;
                    for (Object o : fetchResult.getRetrievedItems()) {
                        if (!(o instanceof IComponent)) continue;
                        component2 = (IComponent)o;
                    }
                    if (component2 == null) {
                        return;
                    }
                    for (Object o : fetchResult.getRetrievedItems()) {
                        if (!(o instanceof IBaseline)) continue;
                        IBaseline baseline = (IBaseline)o;
                        baselineWrappers.add(new BaselineWrapper(repo, baseline, component2));
                    }
                    if (!baselineWrappers.isEmpty()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (PlaceSearchCriteriaPart.this.fBaselineTableViewer.getTable().isDisposed()) {
                                    return;
                                }
                                PlaceSearchCriteriaPart.this.fBaselineTableViewerInput.clear();
                                PlaceSearchCriteriaPart.this.fBaselineTableViewerInput.addAll(baselineWrappers);
                                PlaceSearchCriteriaPart.this.fBaselineTableViewer.getTable().setEnabled(true);
                                PlaceSearchCriteriaPart.this.fAddBaselinesButton.setEnabled(true);
                                PlaceSearchCriteriaPart.this.fBaselineTableViewer.refresh();
                                PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                            }
                        });
                    }
                }
            });
        }
        GC gc = new GC((Drawable)this.fBaselineTableViewer.getControl());
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.heightHint = fontMetrics.getHeight() * 3;
        gd.widthHint = fontMetrics.getAverageCharWidth() * 60;
        Table table = this.fBaselineTableViewer.getTable();
        table.setLayoutData((Object)gd);
        this.fAddBaselinesButton = new Button(composite, 8);
        this.fAddBaselinesButton.setText(Messages.PlaceSearchCriteriaPart_AddBaselineButton);
        GridDataFactory.defaultsFor((Control)this.fAddBaselinesButton).grab(false, false).align(131072, 128).applyTo((Control)this.fAddBaselinesButton);
        this.fAddBaselinesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository repo = PlaceSearchCriteriaPart.this.getRepository();
                ComponentWrapper component = PlaceSearchCriteriaPart.this.getComponentCombo().getComponent();
                if (repo == null || component == null) {
                    return;
                }
                RepositoryUtils.asyncLogin(repo, context.getBackgroundOperationRunner());
                final BaselineSelectionPage page = new BaselineSelectionPage();
                page.setTitle(Messages.PlaceSearchCriteriaPart_BaselineSelectionDialogTitle);
                page.setDescription(NLS.bind((String)Messages.PlaceSearchCriteriaPart_BaselineSelectionDialogDescription, (Object)component.getComponent().getName()));
                page.setContext(repo, (IComponentHandle)component.getComponent(), null, null);
                WizardUtil.open((Shell)PlaceSearchCriteriaPart.this.fAddBaselinesButton.getShell(), (String)Messages.PlaceSearchCriteriaPart_BaselineSelectionDialogTitle, (IWizardPage)page, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

                    public Boolean run() {
                        BaselineWrapper baseline;
                        if (!PlaceSearchCriteriaPart.this.fBaselineTableViewer.getTable().isDisposed() && (baseline = page.getBaseline()) != null) {
                            PlaceSearchCriteriaPart.this.fBaselineTableViewerInput.add(baseline);
                            PlaceSearchCriteriaPart.this.fBaselineTableViewer.getTable().setEnabled(true);
                            PlaceSearchCriteriaPart.this.fBaselineTableViewer.refresh();
                            PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                        }
                        return true;
                    }
                }, (String)"com.ibm.team.filesystem.BaselinePicker");
            }
        });
        this.fRemoveBaselinesButton = new Button(composite, 8);
        this.fRemoveBaselinesButton.setText(Messages.PlaceSearchCriteriaPart_RemoveBaselinesButton);
        GridDataFactory.defaultsFor((Control)this.fRemoveBaselinesButton).grab(false, false).align(131072, 128).applyTo((Control)this.fRemoveBaselinesButton);
        this.fRemoveBaselinesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = PlaceSearchCriteriaPart.this.fBaselineTableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    ArrayList<BaselineWrapper> baselines = new ArrayList<BaselineWrapper>();
                    for (Object element : structuredSelection) {
                        if (!(element instanceof BaselineWrapper)) continue;
                        baselines.add((BaselineWrapper)element);
                    }
                    if (baselines.size() > 0) {
                        PlaceSearchCriteriaPart.this.fBaselineTableViewerInput.removeAll(baselines);
                        if (PlaceSearchCriteriaPart.this.fBaselineTableViewerInput.isEmpty()) {
                            PlaceSearchCriteriaPart.this.fBaselineTableViewer.getTable().setEnabled(false);
                        }
                        PlaceSearchCriteriaPart.this.fBaselineTableViewer.refresh();
                        PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                    }
                }
            }
        });
        this.updateBaselineWidgets();
    }

    private void createCustomAttributeFilter(Composite parent, WidgetToolkit toolkit, PlaceSearchCriteria input) {
        this.customAttributeSectionForQueryEditor = new CustomAttributeSectionForStreamQueryEditor(this.getControlSite().getOperationRunner(), parent, toolkit, input);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.customAttributeSectionForQueryEditor.getControl());
        this.customAttributeSectionForQueryEditor.setInput(input);
        this.listener = new IChangeListener(){

            public void changed(Object source, Object property) {
                PlaceSearchCriteriaPart.this.updateValidation();
                PlaceSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        };
        this.customAttributeSectionForQueryEditor.addListener(this.listener);
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    @Override
    public void ownerComboSelectionChanged() {
        this.updateValidation();
        this.notifySearchCriteriaUpdated();
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void repositoryComboSelectionChanged(SelectionChangedEvent event) {
        super.repositoryComboSelectionChanged(event);
        this.updateBaselineWidgets();
        this.updateValidation();
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        super.updateRepository(repository);
        OwnerSelectionField owner = this.getOwnerCombo();
        if (owner != null) {
            owner.selectTheAnyNode();
        }
        if (this.fComponentCombo != null) {
            this.fComponentCombo.addTheAnyNode();
            this.fComponentCombo.selectTheAnyNode();
        }
        this.updateBaselineWidgets();
    }

    @Override
    public void componentComboSelectionChanged() {
        super.componentComboSelectionChanged();
        this.updateBaselineWidgets();
        this.updateValidation();
    }

    public void updateBaselineWidgets() {
        if (this.fBaselineTableViewer.getTable().isDisposed()) {
            return;
        }
        ITeamRepository repo = this.getRepository();
        ComponentWrapper component = this.getComponentCombo().getComponent();
        boolean baselinesChanged = false;
        if (repo == null || component == null) {
            if (!this.fBaselineTableViewerInput.isEmpty()) {
                this.fBaselineTableViewerInput.clear();
                this.fBaselineTableViewer.refresh();
                baselinesChanged = true;
            }
            this.fBaselineTableViewer.getTable().setEnabled(false);
            this.fAddBaselinesButton.setEnabled(false);
            this.fRemoveBaselinesButton.setEnabled(false);
        } else {
            boolean hasBaselines = false;
            Iterator<Object> iterator = this.fBaselineTableViewerInput.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof BaselineWrapper)) continue;
                BaselineWrapper baselineWrapper = (BaselineWrapper)o;
                if (component.getComponent().sameItemId((IItemHandle)baselineWrapper.getComponent())) {
                    hasBaselines = true;
                    continue;
                }
                baselinesChanged = true;
                iterator.remove();
            }
            this.fBaselineTableViewer.getTable().setEnabled(hasBaselines);
            this.fAddBaselinesButton.setEnabled(true);
            if (baselinesChanged) {
                this.fBaselineTableViewer.refresh();
            }
            boolean hasSelectedBaselines = false;
            Iterator iter = ((IStructuredSelection)this.fBaselineTableViewer.getSelection()).iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof BaselineWrapper)) continue;
                hasSelectedBaselines = true;
                break;
            }
            this.fRemoveBaselinesButton.setEnabled(hasSelectedBaselines);
        }
        if (baselinesChanged) {
            this.notifySearchCriteriaUpdated();
        }
    }

    public void updateValidation() {
        if (this.searchType.getValue() != PlaceSearchCriteria.TYPE_STREAM && this.fNameOrPatternText.getText().equals("") && this.getOwnerCombo().getSelection() == null && this.getComponentCombo().getComponent() == null && this.customAttributeSectionForQueryEditor.getCustomAttributes().length == 0) {
            this.searchValidation.setValue((Object)StatusUtil.newStatus((Object)((Object)this), (int)4, (int)-1163014131, (String)Messages.ChangeSetSearchCriteriaWizardPage_pageDescription));
        } else {
            this.searchValidation.setValue((Object)Status.OK_STATUS);
        }
    }

    @Override
    public PlaceSearchCriteria getResult() {
        Object[] customAttributesArray;
        ItemId selectedOwner = this.getOwnerCombo().getSelection();
        if (selectedOwner == null) {
            selectedOwner = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        PlaceSearchCriteria placeSearchCriteria = new PlaceSearchCriteria(this.getRepository(), null, this.fNameOrPatternText.getText(), this.searchType.getValue(), (ItemId<? extends IAuditable>)selectedOwner);
        placeSearchCriteria.setIgnoreCase(this.fIgnoreCaseButton.getSelection());
        ComponentWrapper componentWrapper = this.getComponentCombo().getComponent();
        if (componentWrapper == null) {
            placeSearchCriteria.setComponentHandle(null);
            placeSearchCriteria.getBaselines().clear();
        } else {
            placeSearchCriteria.setComponentHandle((IComponentHandle)componentWrapper.getComponent());
            Map<UUID, IBaselineHandle> baselinesMap = placeSearchCriteria.getBaselines();
            for (Object o : this.fBaselineTableViewerInput) {
                if (!(o instanceof BaselineWrapper)) continue;
                BaselineWrapper baselineWrapper = (BaselineWrapper)o;
                baselinesMap.put(baselineWrapper.getBaseline().getItemId(), (IBaselineHandle)baselineWrapper.getBaseline());
            }
        }
        Object[] objectArray = customAttributesArray = this.customAttributeSectionForQueryEditor.getCustomAttributes();
        int n = customAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CustomAttributeEntry) {
                CustomAttributeEntry entry = (CustomAttributeEntry)object;
                placeSearchCriteria.setCustomAttribute(entry.getName(), entry.getValue());
            }
            ++n2;
        }
        return placeSearchCriteria;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.fNameOrPatternText != null && !this.fNameOrPatternText.isDisposed()) {
            this.fNameOrPatternText.setEnabled(isEnabled);
        }
        if (this.fIgnoreCaseButton != null && !this.fIgnoreCaseButton.isDisposed()) {
            this.fIgnoreCaseButton.setEnabled(isEnabled);
        }
    }

    @Override
    protected void dispose() {
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.removeListener(this.listener);
        }
        super.dispose();
    }
}

