/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.WorkspaceSearchInput;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentFilter;
import com.ibm.team.scm.common.dto.ICustomAttributeSearchFilter;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class PlaceSearchCriteria
extends WorkspaceSearchInput {
    public static final Object TYPE_STREAM = new String("Stream");
    public static final Object TYPE_WORKSPACE = new String("Repository Workspace");
    public static final Object TYPE_ANY = new String("Any");
    private IConnectedProjectAreaRegistry registry;
    private ITeamRepository repository;
    private String nameOrPattern = "";
    private boolean ignoreCase = false;
    private Object type;
    private ItemId<? extends IAuditable> ownedBy;
    private IComponentHandle componentHandle;
    private Map<UUID, IBaselineHandle> baselines = new HashMap<UUID, IBaselineHandle>();
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();

    public static PlaceSearchCriteria createFromSearchCriteriaDTO(ITeamRepository repository, IConnectedProjectAreaRegistry registry, IWorkspaceSearchCriteria searchCriteriaDTO) {
        String nameOrPattern = "";
        boolean ignoreCase = false;
        Object type = TYPE_ANY;
        ItemId owner = ItemId.getNullItem((IItemType)ITeamArea.ITEM_TYPE);
        IComponentHandle component = null;
        HashMap<UUID, IBaselineHandle> baselines = new HashMap<UUID, IBaselineHandle>();
        HashMap<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
        if (searchCriteriaDTO != null) {
            List filterByCustomAttributeOptional;
            IComponentFilter componentFilter;
            String exactName = searchCriteriaDTO.getExactName();
            String partialNameIgnoreCase = searchCriteriaDTO.getPartialNameIgnoreCase();
            NameFilter nameFilter = searchCriteriaDTO.getOptionalNameFilter();
            if (exactName != null) {
                nameOrPattern = exactName;
            } else if (partialNameIgnoreCase != null) {
                nameOrPattern = partialNameIgnoreCase;
                ignoreCase = true;
            } else if (nameFilter != null && nameFilter.getMatchPattern() != null) {
                nameOrPattern = nameFilter.getMatchPattern();
            }
            if (2 == searchCriteriaDTO.getWorkspaceKind()) {
                type = TYPE_WORKSPACE;
            } else if (1 == searchCriteriaDTO.getWorkspaceKind()) {
                type = TYPE_STREAM;
            }
            List owners = searchCriteriaDTO.getFilterByOwnerOptional();
            if (owners != null && owners.size() > 0 && owners.get(0) != null) {
                owner = ItemId.create((IItemHandle)((IItemHandle)owners.get(0)));
            }
            if ((componentFilter = searchCriteriaDTO.getComponentFilter()) != null) {
                component = componentFilter.getComponent();
                for (IBaselineHandle baselineHandle : componentFilter.getBaselines()) {
                    baselines.put(baselineHandle.getItemId(), baselineHandle);
                }
            }
            if ((filterByCustomAttributeOptional = searchCriteriaDTO.getFilterByCustomAttributeOptional()) != null && !filterByCustomAttributeOptional.isEmpty()) {
                for (ICustomAttributeSearchFilter customAttributeSearchFilter : filterByCustomAttributeOptional) {
                    CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(customAttributeSearchFilter.getName(), customAttributeSearchFilter.getStringValue());
                    customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
                }
            }
        }
        PlaceSearchCriteria placeSearchCriteria = new PlaceSearchCriteria(repository, registry, nameOrPattern, type, (ItemId<? extends IAuditable>)owner);
        placeSearchCriteria.setIgnoreCase(ignoreCase);
        placeSearchCriteria.setComponentHandle(component);
        placeSearchCriteria.baselines = baselines;
        placeSearchCriteria.customAttributes = customAttributes;
        return placeSearchCriteria;
    }

    public PlaceSearchCriteria(ITeamRepository repository) {
        this(repository, null);
    }

    public PlaceSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry) {
        this(repository, registry, "", TYPE_ANY, (ItemId<? extends IAuditable>)ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE));
    }

    public PlaceSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry, String nameOrPattern, Object type, ItemId<? extends IAuditable> ownedBy) {
        this.nameOrPattern = nameOrPattern;
        this.type = type;
        this.ownedBy = ownedBy;
        this.repository = repository;
        this.registry = registry;
    }

    public PlaceSearchCriteria withType(Object type) {
        PlaceSearchCriteria result = this.copy();
        result.type = type;
        return result;
    }

    public PlaceSearchCriteria withOwnedBy(ItemId<? extends IAuditable> ownedBy) {
        PlaceSearchCriteria result = this.copy();
        result.ownedBy = ownedBy;
        return result;
    }

    public PlaceSearchCriteria withNameOrPattern(String nameOrPattern) {
        PlaceSearchCriteria result = this.copy();
        result.nameOrPattern = nameOrPattern;
        return result;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public PlaceSearchCriteria withRepository(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository should not be null");
        }
        PlaceSearchCriteria result = this.copy();
        result.repository = repository;
        return result;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    public PlaceSearchCriteria copy() {
        PlaceSearchCriteria placeSearchCriteria = new PlaceSearchCriteria(this.repository, this.registry, this.nameOrPattern, this.type, this.ownedBy);
        placeSearchCriteria.ignoreCase = this.ignoreCase;
        placeSearchCriteria.setComponentHandle(this.componentHandle);
        placeSearchCriteria.baselines = this.baselines;
        for (Map.Entry<String, CustomAttributeEntry> entry : this.customAttributes.entrySet()) {
            placeSearchCriteria.customAttributes.put(entry.getKey(), entry.getValue());
        }
        placeSearchCriteria.setMaxResults(this.getMaxResults());
        placeSearchCriteria.setMaxResultPreference(this.preferenceStore, this.maxResultKey);
        return placeSearchCriteria;
    }

    public String getNameOrPattern() {
        return this.nameOrPattern;
    }

    public Object getType() {
        return this.type;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        String searchName = Messages.PlaceSearchCriteria_workspacesAndStreamsNoun;
        if (this.getType() == TYPE_STREAM) {
            searchName = Messages.PlaceSearchCriteria_streamsOnlyNoun;
        } else if (this.getType() == TYPE_WORKSPACE) {
            searchName = Messages.PlaceSearchCriteria_workspacesOnlyNoun;
        }
        if (!this.getNameOrPattern().equals("")) {
            searchName = NLS.bind((String)Messages.PlaceSearchCriteria_nameStartsWithTextPhrase, (Object)searchName, (Object)this.getNameOrPattern());
        }
        searchName = this.getOwnedBy().isNull() ? NLS.bind((String)Messages.PlaceSearchCriteria_workspaceWithAnyOwnerPhrase, (Object)searchName) : NLS.bind((String)Messages.PlaceSearchCriteria_workspaceWithParticularOwnerPhrase, (Object)searchName, (Object)this.computeOwnerName(monitor));
        searchName = NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)searchName, (Object)RepositoryUtils.getLabel(this.repository));
        if (!this.customAttributes.isEmpty()) {
            searchName = NLS.bind((String)Messages.AbstractSearchInput_filterByCustomAttributes, (Object)searchName);
        }
        return searchName;
    }

    private String computeOwnerName(IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), this.ownedBy, (IProgressMonitor)monitor);
        if (item instanceof IProcessArea) {
            IProcessArea processArea = (IProcessArea)item;
            return processArea.getName();
        }
        if (item instanceof IContributor) {
            IContributor contributor = (IContributor)item;
            return contributor.getName();
        }
        return Messages.PlaceSearchCriteria_unknownOwnerTypeLabel;
    }

    public ISetWithListeners<AbstractPlaceWrapper> getQuery(IOperationRunner runner) {
        return this.getQuery(runner, false);
    }

    @Override
    public ISetWithListeners<AbstractPlaceWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        PlaceSearchQuery result = new PlaceSearchQuery(this.repository, runner, this, this.registry);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    public ItemId<? extends IAuditable> getOwnedBy() {
        return this.ownedBy;
    }

    public IItemType getItemType() {
        return IWorkspace.ITEM_TYPE;
    }

    public IComponentHandle getComponentHandle() {
        return this.componentHandle;
    }

    public void setComponentHandle(IComponentHandle componentHandle) {
        this.componentHandle = componentHandle;
    }

    public Map<UUID, IBaselineHandle> getBaselines() {
        return this.baselines;
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(name, newValue);
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        for (CustomAttributeEntry customAttributeEntry : toRemove) {
            this.customAttributes.remove(customAttributeEntry.getName());
        }
    }

    public void addCustomAttribute(CustomAttributeEntry entry) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(entry.getName(), entry.getValue());
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public Object[] getCustomAttributesArray() {
        return this.customAttributes.values().toArray(new CustomAttributeEntry[this.customAttributes.size()]);
    }

    public Map<String, CustomAttributeEntry> getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria otherCriteria) {
        if (otherCriteria instanceof IWorkspaceSearchCriteria) {
            IWorkspaceSearchCriteria otherWSCriteria = (IWorkspaceSearchCriteria)otherCriteria;
            return otherWSCriteria.asQueryCriteria().sameAs(PlaceSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput otherCriteria) {
        if (otherCriteria instanceof PlaceSearchCriteria) {
            PlaceSearchCriteria otherUICriteria = (PlaceSearchCriteria)otherCriteria;
            ITeamRepository thisRepo = this.getRepository();
            ITeamRepository otherRepo = otherCriteria.getRepository();
            if (thisRepo == null ? otherRepo != null : !thisRepo.equals(otherRepo)) {
                return false;
            }
            return PlaceSearchCriteria.asSearchCriteriaDTO(otherUICriteria).asQueryCriteria().sameAs(PlaceSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    public static IWorkspaceSearchCriteria asSearchCriteriaDTO(PlaceSearchCriteria searchCriteria) {
        Object type;
        ItemId<? extends IAuditable> searchCriteriaOwner;
        IWorkspaceSearchCriteria searchCriteriaDTO = IWorkspaceSearchCriteria.FACTORY.newInstance();
        String nameOrPattern = searchCriteria.getNameOrPattern();
        if (nameOrPattern != null && !nameOrPattern.equals("")) {
            if (searchCriteria.isIgnoreCase()) {
                searchCriteriaDTO.setPartialNameIgnoreCase(nameOrPattern);
            } else {
                searchCriteriaDTO.setPartialName(nameOrPattern);
            }
        }
        if ((searchCriteriaOwner = searchCriteria.getOwnedBy()) != null && !searchCriteriaOwner.isNull()) {
            searchCriteriaDTO.getFilterByOwnerOptional().add((IAuditableHandle)searchCriteriaOwner.toHandle());
        }
        if ((type = searchCriteria.getType()) == TYPE_STREAM) {
            searchCriteriaDTO.setKind(1);
        } else if (type == TYPE_WORKSPACE) {
            searchCriteriaDTO.setKind(2);
        } else {
            searchCriteriaDTO.setKind(3);
        }
        IComponentHandle componentHandle = searchCriteria.getComponentHandle();
        Map<UUID, IBaselineHandle> baselines = searchCriteria.getBaselines();
        if (componentHandle != null) {
            IComponentFilter componentFilter = null;
            componentFilter = baselines != null && !baselines.isEmpty() ? IComponentFilter.FACTORY.containingComponentAtBaseline(componentHandle, baselines.values()) : IComponentFilter.FACTORY.containingComponent(componentHandle);
            searchCriteriaDTO.setComponentFilter(componentFilter);
        }
        for (Map.Entry<String, CustomAttributeEntry> entry : searchCriteria.getCustomAttributes().entrySet()) {
            searchCriteriaDTO.getFilterByCustomAttributeOptional().add(entry.getValue().asCustomAttributeSearchFilter());
        }
        return searchCriteriaDTO;
    }
}

