/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.workspace;

import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessRCPUI;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class OwnerSearchQuery<T>
extends RepositoryQuery<T> {
    protected static final Set<ItemId<? extends IAuditable>> ALL_OWNERS = NewCollection.hashSet();
    public static final ItemId<IContributor> CURRENT_CONTRIBUTOR = new ItemId(IContributor.ITEM_TYPE, ItemId.getNullItemUUID());
    private ItemId<? extends IAuditable> owner;
    private IConnectedProjectAreaRegistry registry;
    private List<IItem> listeningAreas;
    private IConnectedProjectAreaRegistryListener projectAreaListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            IItemHandle ownerHandle;
            ITeamRepository teamRepository = changeEvent.getTeamRepository();
            if (OwnerSearchQuery.this.owner != null && teamRepository == OwnerSearchQuery.this.getRepository() && (ownerHandle = OwnerSearchQuery.this.owner.toHandle((Object)OwnerSearchQuery.this.getRepository())) instanceof IProjectAreaHandle) {
                OwnerSearchQuery.this.update();
            }
        }
    };
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> itemListener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        public void changed(FilteredFetcher source, List<ItemChangeEvent> property) {
            boolean refresh = false;
            for (ItemChangeEvent event : property) {
                if (event.getBeforeState() == null) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                OwnerSearchQuery.this.update();
            }
        }
    };
    private FilteredFetcher fetcher;

    public OwnerSearchQuery(Realm realm, ITeamRepository repository, IOperationRunner runner, ItemId<? extends IAuditable> owner, IConnectedProjectAreaRegistry registry) {
        super(realm, repository, runner);
        this.fetcher = new FilteredFetcher(repository);
        this.owner = owner;
        this.registry = registry;
        this.listeningAreas = new ArrayList<IItem>();
    }

    protected void attachListeners() {
        if (this.registry != null) {
            this.registry.addListener(this.projectAreaListener);
        }
    }

    protected void detachListeners() {
        if (this.registry != null) {
            this.registry.removeListener(this.projectAreaListener);
        }
        this.removeFetcherListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFetcherListeners() {
        OwnerSearchQuery ownerSearchQuery = this;
        synchronized (ownerSearchQuery) {
            for (IItem next : this.listeningAreas) {
                this.fetcher.removeListener(next, this.itemListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFetcherListeners(Collection<? extends IItem> items) {
        OwnerSearchQuery ownerSearchQuery = this;
        synchronized (ownerSearchQuery) {
            for (IItem processArea : this.listeningAreas) {
                this.fetcher.addListener(processArea, this.itemListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ItemId<? extends IAuditable>> computeOwners(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.removeFetcherListeners();
        if (this.owner == CURRENT_CONTRIBUTOR) {
            HashSet result = NewCollection.hashSet();
            ItemId current = ItemUtil.getContributor((IContributor)this.getRepository().loggedInContributor());
            result.add(current);
            return result;
        }
        IItemHandle ownerHandle = this.owner.toHandle((Object)this.getRepository());
        if (ownerHandle instanceof IProjectAreaHandle) {
            IProjectAreaHandle pah = (IProjectAreaHandle)ownerHandle;
            ArrayList<ItemId> processAreaHandles = this.registry != null ? ItemLists.handlesToIds((Collection)this.registry.getSelectedProcessAreas(pah)) : new ArrayList<ItemId>(Arrays.asList(new ItemId((IItemHandle)pah)));
            Map processAreas = RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), processAreaHandles, (boolean)needsRefresh, (IProgressMonitor)progress.newChild(100));
            if (this.registry != null) {
                this.filterArchivedProcessAreasIfNeeded(processAreas);
            }
            OwnerSearchQuery ownerSearchQuery = this;
            synchronized (ownerSearchQuery) {
                this.removeFetcherListeners();
                this.addFetcherListeners(processAreas.values());
            }
            HashSet<ItemId<? extends IAuditable>> result = new HashSet<ItemId<? extends IAuditable>>(processAreas.keySet());
            return result;
        }
        if (!this.owner.isNull()) {
            HashSet result = NewCollection.hashSet();
            result.add(this.owner);
            return result;
        }
        return ALL_OWNERS;
    }

    private void filterArchivedProcessAreasIfNeeded(Map<ItemId<IProcessArea>, IProcessArea> processAreas) {
        boolean shouldFilterArchived;
        boolean bl = shouldFilterArchived = !ProcessRCPUI.getPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived");
        if (shouldFilterArchived) {
            this.filterArchivedProcessAreas(processAreas);
        }
    }

    private void filterArchivedProcessAreas(Map<ItemId<IProcessArea>, IProcessArea> processAreas) {
        Collection<IProcessArea> processAreaList = processAreas.values();
        Iterator<IProcessArea> iterator = processAreaList.iterator();
        while (iterator.hasNext()) {
            IProcessArea processArea = iterator.next();
            if (!processArea.isArchived()) continue;
            iterator.remove();
        }
    }
}

