/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.snapshot;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SnapshotLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SimpleLocalSelectionTargetAdapter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Date;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class SnapshotSearchView
extends AbstractSearchPage<SnapshotWrapper> {
    public SnapshotSearchView(IControlSite site, AbstractSearchInput<SnapshotWrapper> input) {
        super(site, input);
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<SnapshotWrapper> viewer) {
        String dateColumnTitle = Messages.SnapshotSearchView_creationDateColumn;
        IConversion<SnapshotWrapper, Date> snapshotToDateConversion = new IConversion<SnapshotWrapper, Date>(){

            public Date createAdapter(SnapshotWrapper snapshot) {
                return snapshot.getSnapshot().getCreationDate();
            }
        };
        ConvertColumn dateColumn = new ConvertColumn(viewer, dateColumnTitle, 150, (IConversion)snapshotToDateConversion);
        dateColumn.setShowItemInContextMenu(false);
        dateColumn.setCellComparator(dateComparator);
        String nameColumnTitle = Messages.SnapshotSearchView_snapshotNameColumn;
        LabelColumn nameColumn = new LabelColumn(viewer, nameColumnTitle, 350, (IViewerLabelProvider)new SnapshotLabelProvider());
        nameColumn.setComparator(snapshotWrapperComparator);
        String ownerColumnTitle = Messages.SnapshotSearchView_snapshotOwnerColumn;
        IConversion<SnapshotWrapper, AbstractPlaceWrapper> snapshotOwner = new IConversion<SnapshotWrapper, AbstractPlaceWrapper>(){

            public AbstractPlaceWrapper createAdapter(SnapshotWrapper source) {
                SnapshotWrapper wrapper = source;
                if (wrapper.getWorkspace() != null) {
                    return AbstractPlaceWrapper.newWrapper(wrapper.getWorkspace());
                }
                return null;
            }
        };
        ConvertColumn ownerColumn = new ConvertColumn(viewer, ownerColumnTitle, 200, (IConversion)snapshotOwner);
        ownerColumn.setCellComparator(abstractPlaceWrapperComparator);
        viewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SimpleLocalSelectionTargetAdapter(viewer));
        viewer.setSortColumn((TableViewerColumn)dateColumn, false);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.snapshot";
    }
}

