/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.snapshot;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchCriteria;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class SnapshotSearchQuery
extends RepositoryQuery<RawSnapshotWrapper> {
    private SnapshotSearchCriteria uiCriteria;
    private FilteredFetcher fetcher;
    private boolean shouldFetchOwners = true;
    private boolean allowFolderActions = false;
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> itemChangeListener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        public void changed(FilteredFetcher source, List<ItemChangeEvent> events) {
            boolean containsAdditions = false;
            ArrayList<UUID> deletedSnapshots = new ArrayList<UUID>();
            for (ItemChangeEvent event : events) {
                if (event.getBeforeState() == null && event.getAfterState() != null) {
                    containsAdditions = true;
                }
                if (!(event.getBeforeState() instanceof IBaselineSet) || event.getAfterState() != null) continue;
                deletedSnapshots.add(((IBaselineSet)event.getBeforeState()).getItemId());
            }
            if (containsAdditions) {
                SnapshotSearchQuery.this.update();
                SWTUtil.greedyExec((Realm)SnapshotSearchQuery.this.getRealm(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SnapshotSearchQuery.this.attachListeners();
                    }
                });
            }
            if (!deletedSnapshots.isEmpty()) {
                final ArrayList<RawSnapshotWrapper> elementsToRemove = new ArrayList<RawSnapshotWrapper>();
                for (RawSnapshotWrapper wrapper : SnapshotSearchQuery.this.computeElements()) {
                    if (!deletedSnapshots.contains(wrapper.getSnapshot().getItemId())) continue;
                    elementsToRemove.add(wrapper);
                }
                if (!elementsToRemove.isEmpty()) {
                    SWTUtil.greedyExec((Realm)SnapshotSearchQuery.this.getRealm(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SnapshotSearchQuery.this.removeElements(elementsToRemove);
                        }
                    });
                }
            }
        }
    };

    public SnapshotSearchQuery(ITeamRepository repository, IOperationRunner runner, SnapshotSearchCriteria searchCriteria) {
        super(Realm.getDefault(), repository, runner);
        this.uiCriteria = searchCriteria;
        this.fetcher = new FilteredFetcher(repository);
    }

    public void setShouldFetchOwners(boolean shouldFetchOwners) {
        this.shouldFetchOwners = shouldFetchOwners;
    }

    public void setAllowFolderActions(boolean allowFolderActions) {
        this.allowFolderActions = allowFolderActions;
    }

    protected List<RawSnapshotWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.getRepository();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        ArrayList baselineSets = new ArrayList();
        IBaselineSetSearchCriteria searchCriteriaDTO = SnapshotSearchCriteria.asSearchCriteriaDTO(this.uiCriteria);
        baselineSets.addAll(ItemLists.handlesToIds((Collection)workspaceManager.findBaselineSets(searchCriteriaDTO, this.uiCriteria.getMaxResults(), (IProgressMonitor)progress.newChild(30))));
        for (Map.Entry<String, CustomAttributeEntry> entry : this.uiCriteria.getCustomAttributes().entrySet()) {
            searchCriteriaDTO.getFilterByCustomAttributeOptional().add(entry.getValue().asCustomAttributeSearchFilter());
        }
        Map fetched = this.fetcher.fetchCurrents(baselineSets, needsRefresh, (IProgressMonitor)progress.newChild(20));
        ArrayList<RawSnapshotWrapper> baselineWrappers = new ArrayList<RawSnapshotWrapper>();
        if (this.shouldFetchOwners) {
            IItemManager itemManager = repo.itemManager();
            HashMap<UUID, IWorkspaceHandle> wsHandles = new HashMap<UUID, IWorkspaceHandle>();
            HashMap<UUID, IWorkspace> workspaceMap = new HashMap<UUID, IWorkspace>();
            for (IBaselineSet snapshot : fetched.values()) {
                if (snapshot.getOwner() == null) continue;
                wsHandles.put(snapshot.getOwner().getItemId(), snapshot.getOwner());
            }
            ArrayList listHandles = new ArrayList(wsHandles.values());
            try {
                IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(listHandles, 0, (IProgressMonitor)progress.newChild(80));
                for (Object listItem : fetchResult.getRetrievedItems()) {
                    if (!(listItem instanceof IWorkspace)) continue;
                    IWorkspace ws = (IWorkspace)listItem;
                    workspaceMap.put(ws.getItemId(), ws);
                }
            }
            catch (OperationCanceledException fetchResult) {
                // empty catch block
            }
            for (IBaselineSet snapshot : fetched.values()) {
                IWorkspaceHandle wsH;
                IWorkspace owner = null;
                if (snapshot.getOwner() != null && workspaceMap.containsKey((wsH = snapshot.getOwner()).getItemId())) {
                    owner = (IWorkspace)workspaceMap.get(wsH.getItemId());
                }
                SnapshotWrapper wrapper = new SnapshotWrapper(owner, snapshot);
                wrapper.setAllowFolderActions(this.allowFolderActions);
                baselineWrappers.add(wrapper);
            }
        } else {
            for (IBaselineSet snapshot : fetched.values()) {
                if (snapshot == null) continue;
                RawSnapshotWrapper wrapper = new RawSnapshotWrapper(snapshot);
                wrapper.setAllowFolderActions(this.allowFolderActions);
                baselineWrappers.add(wrapper);
            }
        }
        return baselineWrappers;
    }

    protected void attachListeners() {
        this.fetcher.addListener(IBaselineSet.ITEM_TYPE, this.itemChangeListener);
    }

    protected void detachListeners() {
        this.fetcher.removeListener(IBaselineSet.ITEM_TYPE, this.itemChangeListener);
    }

    public String getName() {
        return Messages.SnapshotSearchQuery_queryName;
    }
}

