/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.snapshot;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForSnapshotQueryEditor;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.LocationCombo;
import com.ibm.team.internal.filesystem.ui.util.NoteComposite;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class SnapshotSearchCriteriaPart
extends AbstractSearchCriteriaPart<SnapshotSearchCriteria> {
    private Text nameOrPatternText;
    private Button ignoreCaseButton;
    private CustomAttributeSectionForSnapshotQueryEditor customAttributeSectionForQueryEditor;
    private IChangeListener listener;

    public SnapshotSearchCriteriaPart(IControlSite site, SnapshotSearchCriteria input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        MnemonicGenerator mnemonics = new MnemonicGenerator((IMnemonicGenerationAlgorithm)site.getMnemonicGenerator());
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        this.createRepoLabel(parent, context);
        this.createRepositoryCombo(parent, (Preferences)this.getConfigPrefs(), context);
        toolkit.createLabel(parent, mnemonics.generate(Messages.SnapshotSearchCriteriaPart_nameBeginsWithFieldLabel));
        this.nameOrPatternText = toolkit.createText(parent, "");
        String inputNameOrPattern = input.getNameOrPattern();
        if (inputNameOrPattern != null) {
            this.nameOrPatternText.setText(inputNameOrPattern);
        }
        this.nameOrPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnapshotSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        new Label(parent, 0);
        this.ignoreCaseButton = toolkit.createButton(parent, Messages.SnapshotSearchCriteriaPart_IgnoreCaseButton, 32);
        this.ignoreCaseButton.setSelection(input.isIgnoreCase());
        this.ignoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnapshotSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        this.createOwnerLabel(parent, context, Messages.PlaceSearchCriteriaPart_ownedByComboLabel);
        this.createLocationCombo(parent, context, 5, Messages.SnapshotSearchCriteriaPart_ANY_OWNER);
        NoteComposite.createNoteComposite(JFaceResources.getDialogFont(), parent, Messages.SnapshotSearchCriteriaPart_NOTE_TITLE, Messages.SnapshotSearchCriteriaPart_NOTE_MESSAGE);
        this.createCustomAttributeFilter(parent, toolkit, input);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
        this.initialize(input.getRepository(), null, (IContextHandle)input.getSnapshotOwner(), null, null);
    }

    private void createCustomAttributeFilter(Composite parent, WidgetToolkit toolkit, SnapshotSearchCriteria input) {
        this.customAttributeSectionForQueryEditor = new CustomAttributeSectionForSnapshotQueryEditor(this.getControlSite().getOperationRunner(), parent, toolkit, input);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(0, 10).applyTo(this.customAttributeSectionForQueryEditor.getControl());
        this.customAttributeSectionForQueryEditor.setInput(input);
        this.listener = new IChangeListener(){

            public void changed(Object source, Object property) {
                SnapshotSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        };
        this.customAttributeSectionForQueryEditor.addListener(this.listener);
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    @Override
    public void repositoryComboSelectionChanged(SelectionChangedEvent event) {
        super.repositoryComboSelectionChanged(event);
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void locationComboSelectionChanged() {
        super.locationComboSelectionChanged();
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        super.updateRepository(repository);
        LocationCombo owner = this.getLocationCombo();
        if (owner != null) {
            owner.selectTheAnyNode();
        }
    }

    @Override
    public SnapshotSearchCriteria getResult() {
        Object[] customAttributesArray;
        IContextHandle contextHandle;
        ContextWrapper locationComboSelection = this.getLocationCombo().getSelectedLocation();
        IWorkspaceHandle owner = null;
        if (locationComboSelection != null && (contextHandle = locationComboSelection.getContextHandle()) instanceof IWorkspaceHandle) {
            owner = (IWorkspaceHandle)contextHandle;
        }
        SnapshotSearchCriteria snapshotSearchCriteria = new SnapshotSearchCriteria(this.getRepository(), this.nameOrPatternText.getText(), owner);
        snapshotSearchCriteria.setIgnoreCase(this.ignoreCaseButton.getSelection());
        Object[] objectArray = customAttributesArray = this.customAttributeSectionForQueryEditor.getCustomAttributes();
        int n = customAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CustomAttributeEntry) {
                CustomAttributeEntry entry = (CustomAttributeEntry)object;
                snapshotSearchCriteria.setCustomAttribute(entry.getName(), entry.getValue());
            }
            ++n2;
        }
        return snapshotSearchCriteria;
    }

    public Text getNameOrPatternText() {
        return this.nameOrPatternText;
    }

    public Button getIgnoreCaseButton() {
        return this.ignoreCaseButton;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        Button ignoreCaseButton;
        super.setEnabled(isEnabled);
        Text nameText = this.getNameOrPatternText();
        if (nameText != null && !nameText.isDisposed()) {
            nameText.setEnabled(isEnabled);
        }
        if ((ignoreCaseButton = this.getIgnoreCaseButton()) != null && !ignoreCaseButton.isDisposed()) {
            ignoreCaseButton.setEnabled(isEnabled);
        }
    }

    @Override
    protected void dispose() {
        if (this.customAttributeSectionForQueryEditor != null) {
            this.customAttributeSectionForQueryEditor.removeListener(this.listener);
        }
        super.dispose();
    }
}

