/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.snapshot;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.ICustomAttributeSearchFilter;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class SnapshotSearchCriteria
extends AbstractSearchInput<RawSnapshotWrapper> {
    private ITeamRepository repository;
    private String nameOrPattern = "";
    private boolean ignoreCase = false;
    private IWorkspaceHandle snapshotOwner;
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();

    public SnapshotSearchCriteria(ITeamRepository repository) {
        this(repository, "", null);
    }

    public SnapshotSearchCriteria(ITeamRepository repository, String nameOrPattern, IWorkspaceHandle snapshotOwner) {
        this.repository = repository;
        this.nameOrPattern = nameOrPattern;
        this.snapshotOwner = snapshotOwner;
    }

    public SnapshotSearchCriteria withRepository(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository should not be null");
        }
        SnapshotSearchCriteria result = this.copy();
        result.repository = repository;
        return result;
    }

    public SnapshotSearchCriteria withOwnedBy(IWorkspaceHandle snapshotOwner) {
        SnapshotSearchCriteria result = this.copy();
        result.snapshotOwner = snapshotOwner;
        return result;
    }

    public SnapshotSearchCriteria startsWithNameOrPattern(String nameOrPattern) {
        SnapshotSearchCriteria result = this.copy();
        result.nameOrPattern = nameOrPattern;
        return result;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(name, newValue);
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        for (CustomAttributeEntry customAttributeEntry : toRemove) {
            this.customAttributes.remove(customAttributeEntry.getName());
        }
    }

    public void addCustomAttribute(CustomAttributeEntry entry) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(entry.getName(), entry.getValue());
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public Object[] getCustomAttributesArray() {
        return this.customAttributes.values().toArray(new CustomAttributeEntry[this.customAttributes.size()]);
    }

    public Map<String, CustomAttributeEntry> getCustomAttributes() {
        return this.customAttributes;
    }

    public SnapshotSearchCriteria copy() {
        SnapshotSearchCriteria criteria = new SnapshotSearchCriteria(this.repository, this.nameOrPattern, this.snapshotOwner);
        criteria.ignoreCase = this.ignoreCase;
        for (Map.Entry<String, CustomAttributeEntry> entry : this.customAttributes.entrySet()) {
            criteria.customAttributes.put(entry.getKey(), entry.getValue());
        }
        return criteria;
    }

    public String getNameOrPattern() {
        if (this.nameOrPattern == null) {
            this.nameOrPattern = "";
        }
        return this.nameOrPattern;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        String searchName = Messages.SnapshotSearchCriteria_snapshotNoun;
        String nameOrPattern = this.getNameOrPattern();
        if (!nameOrPattern.equals("")) {
            searchName = NLS.bind((String)Messages.SnapshotSearchCriteria_nameStartsWithPhrase, (Object)searchName, (Object)nameOrPattern);
        }
        searchName = this.getSnapshotOwner() == null ? NLS.bind((String)Messages.SnapshotSearchCriteria_anyOwnerPhrase, (Object)searchName) : NLS.bind((String)Messages.SnapshotSearchCriteria_particularOwnerPhrase, (Object)searchName, (Object)this.computeOwnerName(monitor));
        searchName = NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)searchName, (Object)RepositoryUtils.getLabel(this.repository));
        if (!this.customAttributes.isEmpty()) {
            searchName = NLS.bind((String)Messages.AbstractSearchInput_filterByCustomAttributes, (Object)searchName);
        }
        return searchName;
    }

    private String computeOwnerName(IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item;
        if (this.snapshotOwner != null && (item = RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), (ItemId)ItemId.create((IItemHandle)this.snapshotOwner), (IProgressMonitor)monitor)) instanceof IWorkspace) {
            IWorkspace workspace = (IWorkspace)item;
            return workspace.getName();
        }
        return Messages.SnapshotSearchCriteria_unknownOwnerPhrase;
    }

    @Override
    public ISetWithListeners<RawSnapshotWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        SnapshotSearchQuery result = new SnapshotSearchQuery(this.repository, runner, this);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    public IWorkspaceHandle getSnapshotOwner() {
        return this.snapshotOwner;
    }

    public IItemType getItemType() {
        return IBaselineSet.ITEM_TYPE;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria otherCriteria) {
        if (otherCriteria instanceof IBaselineSetSearchCriteria) {
            IBaselineSetSearchCriteria otherSnapshotCriteria = (IBaselineSetSearchCriteria)otherCriteria;
            return otherSnapshotCriteria.asQueryCriteria().sameAs(SnapshotSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput otherCriteria) {
        if (otherCriteria instanceof SnapshotSearchCriteria) {
            SnapshotSearchCriteria otherUICriteria = (SnapshotSearchCriteria)otherCriteria;
            ITeamRepository thisRepo = this.getRepository();
            ITeamRepository otherRepo = otherCriteria.getRepository();
            if (thisRepo == null ? otherRepo != null : !thisRepo.equals(otherRepo)) {
                return false;
            }
            return SnapshotSearchCriteria.asSearchCriteriaDTO(otherUICriteria).asQueryCriteria().sameAs(SnapshotSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    public static IBaselineSetSearchCriteria asSearchCriteriaDTO(SnapshotSearchCriteria uiSearchCriteria) {
        IBaselineSetSearchCriteria searchCriteriaDTO = IBaselineSetSearchCriteria.FACTORY.newInstance();
        if (uiSearchCriteria != null) {
            String nameOrPattern = uiSearchCriteria.getNameOrPattern();
            if (uiSearchCriteria.isIgnoreCase()) {
                searchCriteriaDTO.setPartialNameIgnoreCase(nameOrPattern);
            } else {
                searchCriteriaDTO.setPartialName(nameOrPattern);
            }
            searchCriteriaDTO.setOwnerWorkspaceOptional(uiSearchCriteria.getSnapshotOwner());
            for (Map.Entry<String, CustomAttributeEntry> entry : uiSearchCriteria.getCustomAttributes().entrySet()) {
                searchCriteriaDTO.getFilterByCustomAttributeOptional().add(entry.getValue().asCustomAttributeSearchFilter());
            }
        }
        return searchCriteriaDTO;
    }

    public static SnapshotSearchCriteria createFromSearchCriteriaDTO(ITeamRepository repo, IBaselineSetSearchCriteria searchCriteriaDTO) {
        String nameOrPattern = "";
        boolean ignoreCase = false;
        IWorkspaceHandle owner = null;
        HashMap<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
        if (searchCriteriaDTO != null) {
            String exactName = searchCriteriaDTO.getExactName();
            String partialNameIgnoreCase = searchCriteriaDTO.getPartialNameIgnoreCase();
            NameFilter nameFilter = searchCriteriaDTO.getOptionalNameFilter();
            if (exactName != null) {
                nameOrPattern = exactName;
            } else if (partialNameIgnoreCase != null) {
                nameOrPattern = partialNameIgnoreCase;
                ignoreCase = true;
            } else if (nameFilter != null && nameFilter.getMatchPattern() != null) {
                nameOrPattern = nameFilter.getMatchPattern();
            }
            owner = searchCriteriaDTO.getOwnerWorkspaceOptional();
            List filterByCustomAttributeOptional = searchCriteriaDTO.getFilterByCustomAttributeOptional();
            if (filterByCustomAttributeOptional != null && !filterByCustomAttributeOptional.isEmpty()) {
                for (ICustomAttributeSearchFilter customAttributeSearchFilter : filterByCustomAttributeOptional) {
                    CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(customAttributeSearchFilter.getName(), customAttributeSearchFilter.getStringValue());
                    customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
                }
            }
        }
        SnapshotSearchCriteria snapshotSearchCriteria = new SnapshotSearchCriteria(repo, nameOrPattern, owner);
        snapshotSearchCriteria.setIgnoreCase(ignoreCase);
        snapshotSearchCriteria.customAttributes = customAttributes;
        return snapshotSearchCriteria;
    }
}

