/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.query;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.query.ScmQueryItemSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.OwnerSearchQuery;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IScmItemQueryResult;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IQueryItemSearchCriteria;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ScmQueryItemSearchQuery
extends OwnerSearchQuery<QueryItemWrapper> {
    private ScmQueryItemSearchCriteria fSearchCriteria;
    private Set<ItemId<? extends IAuditable>> fCachedOwners = Collections.emptySet();
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> fListener;
    private long fCounter = 0L;
    private FilteredFetcher fQueryFetcher;

    ScmQueryItemSearchQuery(ITeamRepository repository, IOperationRunner runner, ScmQueryItemSearchCriteria searchCriteria, IConnectedProjectAreaRegistry registry) {
        super(Realm.getDefault(), repository, runner, searchCriteria.getOwner(), registry);
        this.fQueryFetcher = new FilteredFetcher(repository);
        this.fSearchCriteria = searchCriteria;
        this.fListener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

            public void changed(FilteredFetcher source, List<ItemChangeEvent> property) {
                Realm realm = ScmQueryItemSearchQuery.this.getRealm();
                if (realm == null) {
                    return;
                }
                final long timestamp = ScmQueryItemSearchQuery.this.fCounter;
                final HashSet<IQueryItem> added = new HashSet<IQueryItem>();
                final HashSet<IQueryItem> removed = new HashSet<IQueryItem>();
                for (ItemChangeEvent event : property) {
                    boolean beforeWasIncluded = ScmQueryItemSearchQuery.this.passesFilter(event.getBeforeState());
                    boolean afterWasIncluded = ScmQueryItemSearchQuery.this.passesFilter(event.getAfterState());
                    if (beforeWasIncluded && !afterWasIncluded) {
                        IQueryItem toRemove = (IQueryItem)event.getSharedItem();
                        removed.add(toRemove);
                        added.remove(toRemove);
                    }
                    if (!afterWasIncluded || beforeWasIncluded) continue;
                    IQueryItem toAdd = (IQueryItem)event.getSharedItem();
                    added.add(toAdd);
                    removed.remove(toAdd);
                }
                if (added.isEmpty() && removed.isEmpty()) {
                    return;
                }
                SWTUtil.greedyExec((Realm)realm, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ScmQueryItemSearchQuery scmQueryItemSearchQuery = ScmQueryItemSearchQuery.this;
                        synchronized (scmQueryItemSearchQuery) {
                            if (ScmQueryItemSearchQuery.this.fCounter != timestamp) {
                                return;
                            }
                            if (ScmQueryItemSearchQuery.this.getRealm() == null) {
                                return;
                            }
                        }
                        ScmQueryItemSearchQuery.this.addElements(ScmQueryItemSearchQuery.this.createWrappers(ScmQueryItemSearchQuery.this.getRepository(), added));
                        ScmQueryItemSearchQuery.this.removeElements(ScmQueryItemSearchQuery.this.createWrappers(ScmQueryItemSearchQuery.this.getRepository(), removed));
                    }
                });
            }
        };
    }

    List<QueryItemWrapper> createWrappers(ITeamRepository repo, Collection<IQueryItem> queries) {
        ArrayList<QueryItemWrapper> wrappers = new ArrayList<QueryItemWrapper>(queries.size());
        for (IQueryItem query : queries) {
            if (!(query instanceof IQueryItem) || 5 != query.getType() && 2 != query.getType() && 1 != query.getType()) continue;
            QueryItemWrapper wrapper = QueryItemWrapper.newWrapper(repo, query);
            wrapper.setAllowFolderActions(true);
            wrappers.add(wrapper);
        }
        return wrappers;
    }

    @Override
    protected void attachListeners() {
        this.fQueryFetcher.addListener(IQueryItem.ITEM_TYPE, this.fListener);
        super.attachListeners();
    }

    @Override
    protected void detachListeners() {
        this.fQueryFetcher.removeListener(IQueryItem.ITEM_TYPE, this.fListener);
        super.detachListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<QueryItemWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IQueryItem> fetchedQueryItems = new ArrayList<IQueryItem>();
        try {
            Set<ItemId<IAuditable>> owners = this.computeOwners(needsRefresh, (IProgressMonitor)progress.newChild(10));
            ScmQueryItemSearchQuery scmQueryItemSearchQuery = this;
            synchronized (scmQueryItemSearchQuery) {
                this.fCachedOwners = owners;
            }
            if (this.fCachedOwners != null && this.fCachedOwners.isEmpty() && this.fCachedOwners != ALL_OWNERS) {
                return Collections.emptyList();
            }
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
            IQueryPageDescriptor page = null;
            ArrayList queryItemHandles = new ArrayList();
            do {
                IQueryItemSearchCriteria queryItemSearchCriteria = IQueryItemSearchCriteria.FACTORY.newInstance();
                if (owners.size() > 0) {
                    for (ItemId<IAuditable> owner : owners) {
                        IAuditableHandle auditableHandle = (IAuditableHandle)owner.toHandle();
                        if (auditableHandle == null) continue;
                        queryItemSearchCriteria.getFilterByOwnerOptional().add(auditableHandle);
                    }
                }
                queryItemSearchCriteria.setQueryType(this.fSearchCriteria.getType());
                queryItemSearchCriteria.setPartialName(this.fSearchCriteria.getName());
                IScmItemQueryResult queryResult = workspaceManager.findQueryItems(queryItemSearchCriteria, page, (IProgressMonitor)progress.newChild(40));
                queryItemHandles.addAll(queryResult.getItemHandles());
                page = queryResult.getNextPageDescriptor();
                if (page == null) continue;
                progress.setWorkRemaining(90);
            } while (page != null);
            if (!queryItemHandles.isEmpty()) {
                IFetchResult fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(queryItemHandles, 0, (IProgressMonitor)progress.newChild(50));
                for (Object o : fetchResult.getRetrievedItems()) {
                    if (!(o instanceof IQueryItem)) continue;
                    fetchedQueryItems.add((IQueryItem)o);
                }
            }
        }
        catch (TeamRepositoryException e) {
            LoggingHelper.log((String)"com.ibm.team.filesystem.ide.ui", (TeamRepositoryException)e);
            return Collections.emptyList();
        }
        ScmQueryItemSearchQuery scmQueryItemSearchQuery = this;
        synchronized (scmQueryItemSearchQuery) {
            ++this.fCounter;
        }
        return this.createWrappers(this.getRepository(), fetchedQueryItems);
    }

    public String getName() {
        return Messages.ScmQuerySearchQuery_SEARCH_QUERY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passesFilter(Object toTest) {
        if (toTest instanceof IQueryItem) {
            ItemId loggedInContributor;
            Set<ItemId<? extends IAuditable>> owners;
            IQueryItem scmQuery = (IQueryItem)toTest;
            String name = this.fSearchCriteria.getName();
            if (name != null && !name.equals(scmQuery.getName())) {
                return false;
            }
            int type = this.fSearchCriteria.getType();
            if (type != 0 && type != scmQuery.getType()) {
                return false;
            }
            ScmQueryItemSearchQuery scmQueryItemSearchQuery = this;
            synchronized (scmQueryItemSearchQuery) {
                owners = this.fCachedOwners;
            }
            ItemId<? extends IAuditable> ownedBy = this.fSearchCriteria.getOwner();
            return !(ownedBy == OwnerSearchQuery.CURRENT_CONTRIBUTOR ? !(loggedInContributor = ItemUtil.getContributor((IContributor)this.getRepository().loggedInContributor())).equals((Object)ItemId.create((IItemHandle)scmQuery.getOwner())) : (ownedBy.isNull() ? !(loggedInContributor = ItemUtil.getContributor((IContributor)this.getRepository().loggedInContributor())).equals((Object)ItemId.create((IItemHandle)scmQuery.getOwner())) && scmQuery.getReadScope() instanceof IPrivateScope : !owners.contains(ItemUtil.getOwner((IQueryItem)scmQuery))));
        }
        return false;
    }
}

