/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.query;

import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.query.ScmQueryItemSearchQuery;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class ScmQueryItemSearchCriteria
extends AbstractSearchInput<QueryItemWrapper> {
    private ITeamRepository fRepository;
    private ItemId<? extends IAuditable> fOwner;
    private int fQueryType;
    private String fName;
    private IConnectedProjectAreaRegistry fRegistry;

    public ScmQueryItemSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry) {
        this(repository, registry, 0, (ItemId<? extends IAuditable>)ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE), null);
    }

    public ScmQueryItemSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry, int type, ItemId<? extends IAuditable> owner, String name) {
        if (repository == null) {
            throw new IllegalArgumentException(Messages.ScmQuerySearchCriteria_REPO_CANNOT_BE_NULL_MSG);
        }
        this.fRepository = repository;
        this.fRegistry = registry;
        this.fQueryType = type;
        this.fOwner = owner;
        this.fName = name;
    }

    public ScmQueryItemSearchCriteria withRepository(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Messages.ScmQuerySearchCriteria_REPO_CANNOT_BE_NULL_MSG);
        }
        ScmQueryItemSearchCriteria result = this.copy();
        result.fRepository = repository;
        return result;
    }

    public ScmQueryItemSearchCriteria withType(int type) {
        ScmQueryItemSearchCriteria result = this.copy();
        result.fQueryType = type;
        return result;
    }

    public ScmQueryItemSearchCriteria withOwner(ItemId<? extends IAuditable> owner) {
        ScmQueryItemSearchCriteria result = this.copy();
        result.fOwner = owner;
        return result;
    }

    public ScmQueryItemSearchCriteria withName(String name) {
        ScmQueryItemSearchCriteria result = this.copy();
        result.fName = name;
        return result;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fRepository;
    }

    public int getType() {
        return this.fQueryType;
    }

    public ItemId<? extends IAuditable> getOwner() {
        return this.fOwner;
    }

    public String getName() {
        return this.fName;
    }

    public ScmQueryItemSearchCriteria copy() {
        ScmQueryItemSearchCriteria criteria = new ScmQueryItemSearchCriteria(this.fRepository, this.fRegistry, this.fQueryType, this.fOwner, this.fName);
        criteria.setMaxResults(this.getMaxResults());
        criteria.setMaxResultPreference(this.preferenceStore, this.maxResultKey);
        return criteria;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        String queryName = Messages.ScmQuerySearchCriteria_DEFAULT_QUERY_NAME;
        if (1 == this.getType()) {
            queryName = Messages.ScmQuerySearchCriteria_BASELINE_QUERY_NAME;
        } else if (3 == this.getType()) {
            queryName = Messages.ScmQuerySearchCriteria_CHANGE_SET_QUERY_NAME;
        } else if (4 == this.getType()) {
            queryName = Messages.ScmQuerySearchCriteria_COMPONENT_QUERY_NAME;
        } else if (2 == this.getType()) {
            queryName = Messages.ScmQuerySearchCriteria_SNAPSHOT_QUERY_NAME;
        } else if (5 == this.getType()) {
            queryName = Messages.ScmQuerySearchCriteria_WORKSPACE_QUERY_NAME;
        }
        if (!this.getName().equals("")) {
            queryName = NLS.bind((String)Messages.ScmQuerySearchCriteria_QUERY_CALLED, (Object)queryName, (Object)this.getName());
        }
        if (this.getOwner().isNull()) {
            return NLS.bind((String)Messages.ScmQuerySearchCriteria_QUERY_NAME_NO_OWNER, (Object)queryName);
        }
        return NLS.bind((String)Messages.ScmQuerySearchCriteria_QUERY_NAME_WITH_OWNER, (Object)queryName, (Object)this.computeOwnerName(monitor));
    }

    private String computeOwnerName(IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), this.fOwner, (IProgressMonitor)monitor);
        if (item instanceof IProcessArea) {
            IProcessArea processArea = (IProcessArea)item;
            return processArea.getName();
        }
        if (item instanceof IContributor) {
            IContributor contributor = (IContributor)item;
            return contributor.getName();
        }
        return Messages.ScmQuerySearchCriteria_UNKNOWN_OWNER_TYPE;
    }

    public ISetWithListeners<QueryItemWrapper> getQuery(IOperationRunner runner) {
        return this.getQuery(runner, false);
    }

    @Override
    public ISetWithListeners<QueryItemWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        ScmQueryItemSearchQuery result = new ScmQueryItemSearchQuery(this.fRepository, runner, this, this.fRegistry);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria criteria) {
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput criteria) {
        return false;
    }
}

