/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForLocksAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ContributorPicker;
import com.ibm.team.internal.filesystem.ui.util.UnlockConfirmationHandler;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.lock.actions.LockSearchUnlockAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockTransferAction
extends LockSearchUnlockAction {
    @Override
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Map<ITeamRepository, List<LockEntry>> repoBatch = LockEntry.getLockEntriesBatchedByRepo(selection.toList());
        if (repoBatch.size() > 1) {
            JFaceUtils.showMessage((String)Messages.LockTransferAction_0, (String)Messages.LockTransferAction_1, (int)1);
            return;
        }
        ItemId<IContributor> contributor = null;
        ITeamRepository repo = repoBatch.keySet().iterator().next();
        try {
            String shellTitle = Messages.OwnerSelectionField_4;
            String dialogTitle = Messages.OwnerSelectionField_9;
            String dialogMessage = Messages.LockTransferAction_3;
            contributor = ContributorPicker.pickContributor(this.getContext(), shellTitle, dialogTitle, dialogMessage, repo, Collections.EMPTY_LIST);
        }
        catch (OperationCanceledException e) {
            return;
        }
        final IContributorHandle contributorHandle = (IContributorHandle)contributor.toHandle();
        final UIContext context = this.getContext();
        this.getOperationRunner().enqueue(Messages.LockTransferAction_0, (Operation)new RepositoryOperation(repoBatch.keySet()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ITransferLockOperation transferLockOperation = IOperationFactory.instance.getTransferLockOperation((LockDilemmaHandler)new UnlockConfirmationHandler());
                LockSearchCriteria criteria = null;
                for (List lockEntries : repoBatch.values()) {
                    for (LockEntry lockEntry : lockEntries) {
                        transferLockOperation.transfer(lockEntry.getWorkspaceConnection(monitor), lockEntry.getComponent(), lockEntry.getVersionable(), lockEntry.getContributor(), contributorHandle);
                        if (criteria != null) continue;
                        criteria = lockEntry.getLockSearchCriteria();
                    }
                }
                transferLockOperation.run(monitor);
                if (context != null && criteria != null) {
                    AbstractSearchAction.openSearch(context, SearchForLocksAction.ARGS.searchViewImage, criteria, LockSearchView.class);
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(true);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Map<ITeamRepository, List<LockEntry>> repoBatch = LockEntry.getLockEntriesBatchedByRepo(sSelection.toList());
            for (Map.Entry<ITeamRepository, List<LockEntry>> entry : repoBatch.entrySet()) {
                ITeamRepository repo = entry.getKey();
                for (LockEntry lockEntry : entry.getValue()) {
                    if (lockEntry.getContributor() == null || lockEntry.getContributor().sameItemId((IItemHandle)repo.loggedInContributor())) continue;
                    action.setEnabled(false);
                    return;
                }
            }
        }
    }
}

