/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntryToAbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntryToContributorWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntryToVersionableWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntryToWorkspaceComponentWrapper;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Display;

public class LockSearchView
extends AbstractSearchPage<LockEntry> {
    public LockSearchView(IControlSite site, AbstractSearchInput<LockEntry> initialInput) {
        super(site, initialInput);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.lock";
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<LockEntry> viewer) {
        ISetWithListeners lockEntries = viewer.getKnownElements();
        IOperationRunner opRunner = this.getControlSite().getOperationRunner();
        Display display = Display.getCurrent();
        String nameColumnTitle = Messages.LockSearchView_3;
        LockEntryToVersionableWrapper versionableFunction = new LockEntryToVersionableWrapper((ISetWithListeners<LockEntry>)lockEntries, opRunner, display, true);
        BaseLabelProvider labelProvider = new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                String text = null;
                ImageDescriptor imageDescriptor = null;
                if (element instanceof FileItemWrapper) {
                    FileItemWrapper wrapper = (FileItemWrapper)((Object)element);
                    text = wrapper.getFQName();
                    imageDescriptor = UiPlugin.getFileSystemImageDescriptor(wrapper.getName());
                } else if (element instanceof FolderItemWrapper) {
                    FolderItemWrapper wrapper = (FolderItemWrapper)((Object)element);
                    text = wrapper.getFQName();
                    imageDescriptor = UiPlugin.getFileSystemImageDescriptor(null);
                } else if (element instanceof SymbolicLinkItemWrapper) {
                    SymbolicLinkItemWrapper wrapper = (SymbolicLinkItemWrapper)((Object)element);
                    text = wrapper.getFQName();
                    imageDescriptor = ImagePool.SYMBOLIC_LINK;
                } else {
                    text = Messages.LockSearchView_6;
                }
                label.setText(text);
                label.setImage(this.getImage(imageDescriptor));
            }
        };
        ConvertColumn nameColumn = new ConvertColumn(viewer, nameColumnTitle, null, 200, (IDynamicFunction)versionableFunction, (IViewerLabelProvider)labelProvider, false);
        nameColumn.setCellComparator(abstractFileSystemItemWrapperComparator);
        String ownerColumnTitle = Messages.ComponentSearchView_ownerColumn;
        LockEntryToContributorWrapper lockOwnerFunction = new LockEntryToContributorWrapper(lockEntries, opRunner);
        ConvertColumn ownerColumn = new ConvertColumn(viewer, ownerColumnTitle, 200, (IDynamicFunction)lockOwnerFunction);
        ownerColumn.setCellComparator(ownerComparator);
        String componentColumnTitle = Messages.LockSearchView_4;
        LockEntryToWorkspaceComponentWrapper componentFunction = new LockEntryToWorkspaceComponentWrapper((ISetWithListeners<LockEntry>)lockEntries, opRunner, display, true);
        ConvertColumn componentColumn = new ConvertColumn(viewer, componentColumnTitle, 200, (IDynamicFunction)componentFunction);
        componentColumn.setCellComparator(workspaceComponentWrapperComparator);
        String streamColumnTitle = Messages.LockSearchView_5;
        LockEntryToAbstractPlaceWrapper streamFunction = new LockEntryToAbstractPlaceWrapper((ISetWithListeners<LockEntry>)lockEntries, opRunner, display, true);
        ConvertColumn streamColumn = new ConvertColumn(viewer, streamColumnTitle, 200, (IDynamicFunction)streamFunction);
        streamColumn.setCellComparator(abstractPlaceWrapperComparator);
    }
}

