/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.dto.ILockPageFetchDescriptor;
import com.ibm.team.scm.common.dto.ILockSearchResult2;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LockSearchQuery
extends RepositoryQuery<LockEntry> {
    private LockSearchCriteria criteria;

    public LockSearchQuery(ITeamRepository repository, LockSearchCriteria criteria, IOperationRunner runner) {
        super(repository, runner);
        this.criteria = criteria;
    }

    protected List<LockEntry> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        int maxResults = this.criteria.getMaxResults() > 0 ? this.criteria.getMaxResults() : 2048;
        ILockPageFetchDescriptor pageDescriptor = ILockPageFetchDescriptor.FACTORY.maxEntries(2048);
        ArrayList<LockEntry> locks = new ArrayList<LockEntry>();
        while (pageDescriptor != null && locks.size() < maxResults) {
            int pageSize = Math.min(maxResults - locks.size(), 2048);
            pageDescriptor.setLocksPerPage(pageSize);
            ILockSearchResult2 searchResult = workspaceManager.searchLocks(this.criteria.getLockSearchCriteria(), pageDescriptor, monitor);
            for (IStreamLockReport streamLockReport : searchResult.getReports()) {
                locks.addAll(LockEntry.createEntries(this.getRealm(), this.criteria, this.getRepository(), streamLockReport));
            }
            pageDescriptor = searchResult.getNextFetchDescriptor();
        }
        return locks;
    }

    public String getName() {
        return Messages.LockSearchQuery_0;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }
}

