/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ComponentCombo;
import com.ibm.team.internal.filesystem.ui.picker.LocationCombo;
import com.ibm.team.internal.filesystem.ui.picker.OwnerSelectionField;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.Preferences;

public class LockSearchCriteriaPart
extends AbstractSearchCriteriaPart<LockSearchCriteria> {
    public LockSearchCriteriaPart(IControlSite site, Input input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        Composite parent = site.getParent();
        this.createRepoLabel(parent, context);
        this.createRepositoryCombo(parent, (Preferences)LockSearchCriteriaPart.getConfigPrefs(), context);
        this.createOwnerLabel(parent, context, Messages.PlaceSearchCriteriaPart_ownedByComboLabel);
        this.createOwnerCombo(parent, context, 5);
        this.createComponentLabel(parent, context);
        this.createComponentCombo(parent, context);
        this.createLocationLabel(parent, context);
        this.createLocationCombo(parent, context, 1);
        context.getToolkit().createLabel(parent, Messages.LockSearchCriteriaPart_0);
        Composite vComposite = new Composite(parent, 0);
        this.createVersionablePicker(vComposite, context);
        Control textControl = this.getVersionablePicker().getTextControl();
        GridDataFactory.defaultsFor((Control)textControl).hint(200, -1).grab(true, false).applyTo(textControl);
        Dialog.applyDialogFont((Control)vComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(vComposite);
        GridDataFactory.defaultsFor((Control)vComposite).grab(true, false).applyTo((Control)vComposite);
        this.createMaxResultLabel(parent, context);
        this.createMaxResultText(parent, (Preferences)LockSearchCriteriaPart.getConfigPrefs(), context);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
        this.initialize(input.getRepository(), input.getComponents() == null || input.getComponents().size() == 0 ? null : input.getComponents().iterator().next(), input.getStreams() == null || input.getStreams().size() == 0 ? null : (IContextHandle)input.getStreams().iterator().next(), input.getContributor(), input.getVersionables() == null || input.getVersionables().size() == 0 ? null : input.getVersionables().iterator().next().toHandle());
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        LocationCombo location;
        ComponentCombo component;
        super.updateRepository(repository);
        OwnerSelectionField owner = this.getOwnerCombo();
        if (owner != null) {
            owner.selectTheAnyNode();
        }
        if ((component = this.getComponentCombo()) != null) {
            component.selectTheAnyNode();
        }
        if ((location = this.getLocationCombo()) != null) {
            location.selectTheAnyNode();
        }
    }

    public static IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + LockSearchCriteria.class.getName());
        return result;
    }

    public static int getLockSearchMaxResults() {
        String string = LockSearchCriteriaPart.getConfigPrefs().get("maxResults", "100");
        int maxResults = 100;
        try {
            maxResults = Integer.parseInt(string);
            if (maxResults < 1) {
                maxResults = 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxResults;
    }

    @Override
    public LockSearchCriteria getResult() {
        SiloedItemId<IVersionable> versionable;
        IContextHandle contextHandle;
        ContextWrapper location;
        ComponentWrapper componentWrapper;
        Set<IWorkspaceHandle> workspaceHandles = null;
        Set<IComponentHandle> componentHandles = null;
        IContributorHandle contributorHandle = null;
        Set<SiloedItemId<IVersionable>> versionableHandles = null;
        ItemId<? extends IAuditable> selectedOwner = this.getOwnerCombo().getSelection();
        if (selectedOwner != null) {
            contributorHandle = (IContributorHandle)selectedOwner.toHandle();
        }
        if ((componentWrapper = this.getComponentCombo().getComponent()) != null) {
            IComponentHandle componentHandle = (IComponentHandle)componentWrapper.getLocator().toHandle();
            componentHandles = Collections.singleton(componentHandle);
        }
        if ((location = this.getLocationCombo().getSelectedLocation()) != null && (contextHandle = location.getContextHandle()) instanceof IWorkspaceHandle) {
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)contextHandle;
            workspaceHandles = Collections.singleton(workspaceHandle);
        }
        if ((versionable = this.getVersionablePicker().getSelection()) != null && !versionable.isNull()) {
            versionableHandles = Collections.singleton(versionable);
        }
        int maxResults = 100;
        String text = this.getMaxResultsText().getText();
        try {
            maxResults = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LockSearchCriteria criteria = new LockSearchCriteria(this.getRepository(), workspaceHandles, componentHandles, contributorHandle, versionableHandles, maxResults);
        return criteria;
    }

    public static class Input {
        private ITeamRepository repo;
        private Collection<IComponentHandle> components;
        private Collection<IWorkspaceHandle> streams;
        private ItemId<? extends IAuditable> ownedBy;
        private Collection<SiloedItemId<IVersionable>> versionables;

        public Input(ITeamRepository repo) {
            this.repo = repo;
        }

        public ITeamRepository getRepository() {
            return this.repo;
        }

        public Collection<IComponentHandle> getComponents() {
            return this.components;
        }

        public Input setComponents(Collection<IComponentHandle> components) {
            this.components = components;
            return this;
        }

        public Collection<IWorkspaceHandle> getStreams() {
            return this.streams;
        }

        public Input setStreams(Collection<IWorkspaceHandle> workspaces) {
            this.streams = workspaces;
            return this;
        }

        public ItemId<? extends IAuditable> getContributor() {
            return this.ownedBy;
        }

        public Input setContributor(ItemId<? extends IAuditable> owner) {
            this.ownedBy = owner;
            return this;
        }

        public Collection<SiloedItemId<IVersionable>> getVersionables() {
            return this.versionables;
        }

        public Input setVersionables(Collection<SiloedItemId<IVersionable>> versionables) {
            this.versionables = versionables;
            return this;
        }
    }
}

