/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public final class LockSearchCriteria
extends AbstractSearchInput<LockEntry> {
    private ITeamRepository repository;
    private Collection<IWorkspaceHandle> workspaceHandles;
    private Collection<IComponentHandle> componentHandles;
    private IContributorHandle contributorHandle;
    private Collection<SiloedItemId<IVersionable>> versionableHandles;

    public LockSearchCriteria(ITeamRepository repository, Collection<IWorkspaceHandle> workspaceHandles, Collection<IComponentHandle> componentHandles, IContributorHandle contributorHandle, Collection<SiloedItemId<IVersionable>> versionableHandles, int maxResults) {
        this.repository = repository;
        this.workspaceHandles = workspaceHandles;
        this.componentHandles = componentHandles;
        this.contributorHandle = contributorHandle;
        this.versionableHandles = versionableHandles;
        this.setMaxResults(maxResults);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    public Collection<IComponentHandle> getComponents() {
        return this.componentHandles == null ? Collections.emptyList() : this.componentHandles;
    }

    public IContributorHandle getContributor() {
        return this.contributorHandle;
    }

    public Collection<IWorkspaceHandle> getStreams() {
        return this.workspaceHandles == null ? Collections.emptyList() : this.workspaceHandles;
    }

    public Collection<SiloedItemId<IVersionable>> getVersionables() {
        return this.versionableHandles == null ? Collections.emptyList() : this.versionableHandles;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        String searchName = Messages.LockSearchCriteria_0;
        if (this.getContributor() != null) {
            IContributor contributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)this.repository, (ItemId)new ItemId((IItemHandle)this.getContributor()), (IProgressMonitor)progress.newChild(1));
            searchName = NLS.bind((String)Messages.ComponentSearchCriteria_componentWithParticularOwnerPhrase, (Object)searchName, (Object)contributor.getName());
        }
        if (!this.getComponents().isEmpty()) {
            IComponent cmp = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)this.repository, (ItemId)new ItemId((IItemHandle)this.getComponents().iterator().next()), (IProgressMonitor)progress.newChild(1));
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_inComponentPhrase, (Object)searchName, (Object)cmp.getName());
        }
        if (!this.getStreams().isEmpty()) {
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_inLocationPhrase, (Object)searchName, (Object)ChangeSetSearchCriteria.getDescription(this.repository, (IContextHandle)this.getStreams().iterator().next(), progress.newChild(1)));
        }
        if (!this.getVersionables().isEmpty()) {
            SiloedItemId<IVersionable> item = this.getVersionables().iterator().next();
            String name = null;
            if (this.getStreams().size() == 1) {
                IWorkspaceHandle workspaceHandle = this.getStreams().iterator().next();
                IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection(workspaceHandle, (IProgressMonitor)progress.newChild(1));
                IVersionable versionable = workspaceConnection.configuration(item.getComponentHandle()).fetchCompleteItem(item.toHandle(), (IProgressMonitor)progress.newChild(1));
                name = versionable.getName();
            } else {
                Map paths = CopyFileAreaPathResolver.create().resolve(Collections.singleton(item), (IProgressMonitor)progress.newChild(1));
                VersionablePath path = (VersionablePath)paths.values().iterator().next();
                if (path.segmentCount() > 0) {
                    name = path.segment(path.segmentCount() - 1).getName();
                }
            }
            if (name != null) {
                String message = this.getVersionables().size() == 1 ? Messages.LockSearchCriteria_1 : Messages.LockSearchCriteria_2;
                searchName = NLS.bind((String)message, (Object)searchName, (Object)name);
            }
        }
        searchName = NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)searchName, (Object)RepositoryUtils.getLabel(this.repository));
        return searchName;
    }

    @Override
    public ISetWithListeners<LockEntry> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        LockSearchQuery result = new LockSearchQuery(this.repository, this, runner);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    public ILockSearchCriteria getLockSearchCriteria() {
        ILockSearchCriteria criteria = ILockSearchCriteria.FACTORY.newInstance();
        criteria.getComponents().addAll(this.getComponents());
        criteria.getStreams().addAll(this.getStreams());
        if (this.contributorHandle != null) {
            criteria.setContributor(this.contributorHandle);
        }
        for (SiloedItemId<IVersionable> versionable : this.getVersionables()) {
            criteria.getVersionables().add(versionable.toHandle());
        }
        return criteria;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria criteria) {
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput criteria) {
        return false;
    }

    public static ILockSearchCriteria getEquivalentSearchCriteria(LockSearchCriteria uiSearchCriteria) {
        ILockSearchCriteria lockSearchCriteria = ILockSearchCriteria.FACTORY.newInstance();
        if (uiSearchCriteria.getComponents() != null) {
            lockSearchCriteria.getComponents().addAll(uiSearchCriteria.getComponents());
        }
        if (uiSearchCriteria.getStreams() != null) {
            lockSearchCriteria.getStreams().addAll(uiSearchCriteria.getStreams());
        }
        if (uiSearchCriteria.getContributor() != null) {
            lockSearchCriteria.setContributor(uiSearchCriteria.getContributor());
        }
        if (uiSearchCriteria.getVersionables() != null) {
            for (SiloedItemId<IVersionable> versionable : uiSearchCriteria.getVersionables()) {
                lockSearchCriteria.getVersionables().add(versionable.toHandle());
            }
        }
        return lockSearchCriteria;
    }
}

