/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public class LockEntryToWorkspaceComponentWrapper
extends SlowFunction<LockEntry, WorkspaceComponentWrapper> {
    public LockEntryToWorkspaceComponentWrapper(ISetWithListeners<LockEntry> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    protected Map<LockEntry, WorkspaceComponentWrapper> doFetch(Collection<LockEntry> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        try {
            return LockEntryToWorkspaceComponentWrapper.doFetch2(toFetch, reporter);
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    public static Map<LockEntry, WorkspaceComponentWrapper> doFetch2(Collection<LockEntry> toFetch, IProgressMonitor reporter) throws TeamRepositoryException {
        HashMap<ITeamRepository, List[]> repoBatch = new HashMap<ITeamRepository, List[]>();
        for (LockEntry lockRecord : toFetch) {
            List[] pair = (List[])repoBatch.get(lockRecord.getRepository());
            if (pair == null) {
                pair = new List[]{new ArrayList(), new ArrayList()};
                repoBatch.put(lockRecord.getRepository(), pair);
            }
            pair[0].add(lockRecord);
            pair[1].add(lockRecord.getStream());
            pair[1].add(lockRecord.getComponent());
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)reporter, (int)(repoBatch.size() * 2));
        HashMap<LockEntry, WorkspaceComponentWrapper> map = new HashMap<LockEntry, WorkspaceComponentWrapper>();
        for (Map.Entry entry : repoBatch.entrySet()) {
            List items = ((ITeamRepository)entry.getKey()).itemManager().fetchCompleteItems(((List[])entry.getValue())[1], 0, (IProgressMonitor)sub.newChild(1));
            int i = 0;
            while (i < items.size() / 2) {
                int i2 = i * 2;
                IWorkspace stream = (IWorkspace)items.get(i2);
                IComponent component = (IComponent)items.get(i2 + 1);
                WorkspaceNamespace namespace = (WorkspaceNamespace)WorkspaceNamespace.create((IWorkspaceHandle)stream, (IComponentHandle)component);
                WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.constructFrom(namespace, (IProgressMonitor)sub.newChild(1));
                map.put((LockEntry)((Object)((List[])entry.getValue())[0].get(i)), wrapper);
                ++i;
            }
        }
        return map;
    }

    protected WorkspaceComponentWrapper getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return Messages.LockSearchView_1;
    }
}

