/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public class LockEntryToVersionableWrapper
extends SlowFunction<LockEntry, AbstractFileSystemItemWrapper> {
    private IStaleListener listener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            if (staleEvent.getObservable().isStale()) {
                LockEntryToVersionableWrapper.this.markDirty(staleEvent.getObservable());
            }
        }
    };

    public LockEntryToVersionableWrapper(ISetWithListeners<LockEntry> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    protected Map<LockEntry, AbstractFileSystemItemWrapper> doFetch(Collection<LockEntry> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        try {
            return LockEntryToVersionableWrapper.doFetch2(toFetch, reporter);
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    public static Map<LockEntry, AbstractFileSystemItemWrapper> doFetch2(Collection<LockEntry> toFetch, IProgressMonitor reporter) throws TeamRepositoryException {
        HashMap repoBatch = new HashMap();
        for (LockEntry lockRecord : toFetch) {
            UUID componentId;
            Map componentBatch;
            List[] lists;
            UUID streamId;
            Object[] handleAndComponents;
            HashMap<UUID, Object[]> streamBatch = (HashMap<UUID, Object[]>)repoBatch.get(lockRecord.getRepository());
            if (streamBatch == null) {
                streamBatch = new HashMap<UUID, Object[]>();
                repoBatch.put(lockRecord.getRepository(), streamBatch);
            }
            if ((handleAndComponents = (Object[])streamBatch.get(streamId = lockRecord.getStream().getItemId())) == null) {
                handleAndComponents = new Object[]{lockRecord.getStream(), new HashMap()};
                streamBatch.put(streamId, handleAndComponents);
            }
            if ((lists = (List[])(componentBatch = (Map)handleAndComponents[1]).get(componentId = lockRecord.getComponent().getItemId())) == null) {
                lists = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
                componentBatch.put(componentId, lists);
            }
            lists[0].add(lockRecord);
            lists[1].add(lockRecord.getVersionable());
            if (!lockRecord.isStale()) continue;
            lists[2].add(lockRecord.getVersionable());
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)reporter, (int)repoBatch.size());
        HashMap<LockEntry, AbstractFileSystemItemWrapper> map = new HashMap<LockEntry, AbstractFileSystemItemWrapper>();
        for (Map.Entry entry : repoBatch.entrySet()) {
            ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>();
            ArrayList allHandlesAndComponents = new ArrayList(((Map)entry.getValue()).values());
            int i = 0;
            while (i < allHandlesAndComponents.size()) {
                Object[] handleAndComponents = (Object[])allHandlesAndComponents.get(i);
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)handleAndComponents[0];
                workspaceHandles.add(workspaceHandle);
                ++i;
            }
            List workspaceConnections = SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)entry.getKey())).getWorkspaceConnections(workspaceHandles, (IProgressMonitor)sub.newChild(1));
            int i2 = 0;
            while (i2 < allHandlesAndComponents.size()) {
                Object[] handleAndComponents = (Object[])allHandlesAndComponents.get(i2);
                Map componentBatch = (Map)handleAndComponents[1];
                Collection lists = componentBatch.values();
                IWorkspaceConnection connection = (IWorkspaceConnection)workspaceConnections.get(i2);
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
                ArrayList<List> versionableItemsByComponent = new ArrayList<List>();
                for (List[] list : lists) {
                    LockEntry lockRecord = (LockEntry)((Object)list[0].get(0));
                    componentHandles.add(lockRecord.getComponent());
                    versionableItemsByComponent.add(list[1]);
                }
                Map versionables = connection.configuration().fetchCompleteItems(componentHandles, versionableItemsByComponent, (IProgressMonitor)sub.newChild(1));
                HashMap versionablesWithAncestor = new HashMap();
                for (List[] list : lists) {
                    LockEntry lockRecord = (LockEntry)((Object)list[0].get(0));
                    IComponentHandle componentHandle = lockRecord.getComponent();
                    List ancestorsToFetch = list[2];
                    List ancestorReports = Collections.EMPTY_LIST;
                    if (!ancestorsToFetch.isEmpty()) {
                        ancestorReports = connection.configuration(componentHandle).locateAncestors(ancestorsToFetch, (IProgressMonitor)sub.newChild(1));
                    }
                    HashMap<UUID, IAncestorReport> ancestorMap = new HashMap<UUID, IAncestorReport>();
                    versionablesWithAncestor.put(componentHandle.getItemId(), ancestorMap);
                    int j = 0;
                    while (j < ancestorsToFetch.size()) {
                        ancestorMap.put(((IVersionableHandle)ancestorsToFetch.get(j)).getItemId(), (IAncestorReport)ancestorReports.get(j));
                        ++j;
                    }
                }
                for (List[] list : lists) {
                    for (final LockEntry lockEntry : list[0]) {
                        IAncestorReport ancestorReport;
                        List nameItemPairs;
                        WorkspaceNamespace workspaceNamespace = WorkspaceNamespace.create((IWorkspaceConnection)connection, (IComponentHandle)lockEntry.getComponent());
                        IVersionableHandle handle = lockEntry.getVersionable();
                        UUID itemId = handle.getItemId();
                        UUID componentUUID = lockEntry.getComponent().getItemId();
                        IVersionable versionable = null;
                        StateId stateId = null;
                        String name = null;
                        if (lockEntry.isStale() && !(nameItemPairs = (ancestorReport = (IAncestorReport)((Map)versionablesWithAncestor.get(componentUUID)).get(itemId)).getNameItemPairs()).isEmpty()) {
                            name = LockEntryToVersionableWrapper.toString(ancestorReport);
                        }
                        if ((versionable = (IVersionable)((Map)versionables.get(componentUUID)).get(itemId)) == null) {
                            stateId = StateId.getDeletedState((IItemType)handle.getItemType(), (UUID)itemId);
                            if (name == null) {
                                name = Messages.LockSearchView_6;
                            }
                        } else {
                            stateId = StateId.forItem((IItem)versionable);
                            if (name == null) {
                                name = lockEntry.getFileSystemItemWrapper() != null ? lockEntry.getFileSystemItemWrapper().getFQName() : versionable.getName();
                            }
                        }
                        Object wrapper = AbstractFileSystemItemWrapper.newWrapper(stateId, name, (ItemNamespace)workspaceNamespace);
                        lockEntry.getRealm().asyncExec(new Runnable((AbstractFileSystemItemWrapper)((Object)wrapper)){
                            private final /* synthetic */ AbstractFileSystemItemWrapper val$wrapper;
                            {
                                this.val$wrapper = abstractFileSystemItemWrapper;
                            }

                            @Override
                            public void run() {
                                lockEntry.setFileSystemItemWrapper(this.val$wrapper);
                            }
                        });
                        map.put(lockEntry, (AbstractFileSystemItemWrapper)((Object)wrapper));
                    }
                }
                ++i2;
            }
        }
        return map;
    }

    protected AbstractFileSystemItemWrapper getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return Messages.LockSearchView_2;
    }

    protected void elementAdded(LockEntry element) {
        super.elementAdded((Object)element);
        element.addStaleListener(this.listener);
    }

    protected void elementRemoved(LockEntry element) {
        element.removeStaleListener(this.listener);
        super.elementRemoved((Object)element);
    }

    protected void deallocate() {
        for (LockEntry lockEntry : this.getDomain()) {
            lockEntry.removeStaleListener(this.listener);
        }
        super.deallocate();
    }

    public static String toString(IAncestorReport report) {
        StringBuilder builder = new StringBuilder();
        List pairs = report.getNameItemPairs();
        int i = 1;
        while (i < pairs.size()) {
            INameItemPair pair = (INameItemPair)pairs.get(i);
            String name = pair.getName();
            if (i > 1) {
                builder.append('/');
            }
            builder.append(name);
            ++i;
        }
        String path = builder.toString();
        return path;
    }
}

