/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.lock;

import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;

public class LockEntry
extends AbstractObservable {
    private ITeamRepository repo;
    private IWorkspaceHandle workspaceHandle;
    private IWorkspaceConnection workspaceConnection;
    private IComponentHandle componentHandle;
    private IVersionableHandle versionableHandle;
    private IContributorHandle contributorHandle;
    private LockSearchCriteria criteria;
    private boolean stale = false;
    private AbstractFileSystemItemWrapper wrapper;

    public LockEntry(Realm realm, LockSearchCriteria criteria, ITeamRepository repo, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        super(realm);
        this.criteria = criteria;
        this.repo = repo;
        this.workspaceHandle = workspaceHandle;
        this.componentHandle = componentHandle;
        this.versionableHandle = versionableHandle;
        this.contributorHandle = contributorHandle;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public IWorkspaceHandle getStream() {
        return this.workspaceHandle;
    }

    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    public IVersionableHandle getVersionable() {
        return this.versionableHandle;
    }

    public IContributorHandle getContributor() {
        return this.contributorHandle;
    }

    public AbstractFileSystemItemWrapper getFileSystemItemWrapper() {
        return this.wrapper;
    }

    public void setFileSystemItemWrapper(AbstractFileSystemItemWrapper newWrapper) {
        AbstractFileSystemItemWrapper oldWrapper = this.wrapper;
        this.wrapper = newWrapper;
        if (this.isStale() && !newWrapper.equals((Object)oldWrapper)) {
            this.setStale(false);
            this.fireChange();
        }
    }

    public LockSearchCriteria getLockSearchCriteria() {
        return this.criteria;
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.workspaceConnection == null) {
            this.workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo).getWorkspaceConnection(this.workspaceHandle, monitor);
        }
        return this.workspaceConnection;
    }

    public static List<LockEntry> createEntries(Realm realm, LockSearchCriteria criteria, ITeamRepository repo, IStreamLockReport streamLockReport) {
        ArrayList<LockEntry> list = new ArrayList<LockEntry>();
        IWorkspaceHandle stream = streamLockReport.getStream();
        for (IComponentLockReport componentLockReport : streamLockReport.getComponentLocks()) {
            IComponentHandle componentHandle = componentLockReport.getComponent();
            for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                list.add(new LockEntry(realm, criteria, repo, stream, componentHandle, versionableLock.getVersionable(), versionableLock.getContributor()));
            }
        }
        return list;
    }

    public static Map<ITeamRepository, List<LockEntry>> getLockEntriesBatchedByRepo(Collection<LockEntry> locks) {
        HashMap<ITeamRepository, List<LockEntry>> repoBatch = new HashMap<ITeamRepository, List<LockEntry>>();
        for (LockEntry lockEntry : locks) {
            ArrayList<LockEntry> lockEntries = (ArrayList<LockEntry>)repoBatch.get(lockEntry.getRepository());
            if (lockEntries == null) {
                lockEntries = new ArrayList<LockEntry>();
                repoBatch.put(lockEntry.getRepository(), lockEntries);
            }
            lockEntries.add(lockEntry);
        }
        return repoBatch;
    }

    public void setStale(boolean newStale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = newStale;
        if (!wasStale && this.stale) {
            this.fireStale();
        }
    }

    public boolean isStale() {
        return this.stale;
    }
}

