/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.files;

import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.FileSearchLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Comparator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IViewerLabelProvider;

public class FileSearchView
extends AbstractSearchPage<AbstractFileSystemItemWrapper> {
    public FileSearchView(IControlSite site, AbstractSearchInput<AbstractFileSystemItemWrapper> input) {
        super(site, input);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.files";
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<AbstractFileSystemItemWrapper> viewer) {
        ISetWithListeners files = viewer.getKnownElements();
        String fileNameColumnTitle = Messages.FileSearchView_fileNameColumn;
        FileSearchLabelProvider labelProvider = new FileSearchLabelProvider("{0}", (ISetWithListeners<AbstractFileSystemItemWrapper>)files);
        LabelColumn nameColumn = new LabelColumn(viewer, fileNameColumnTitle, 350, (IViewerLabelProvider)labelProvider);
        nameColumn.setComparator((Comparator)new AbstractSearchPage.FileSearchComparator("name"));
        String filePathColumnTitle = Messages.FileSearchView_filePathColumn;
        labelProvider = new FileSearchLabelProvider("{1}", (ISetWithListeners<AbstractFileSystemItemWrapper>)files);
        LabelColumn pathColumn = new LabelColumn(viewer, filePathColumnTitle, 350, (IViewerLabelProvider)labelProvider);
        pathColumn.setComparator((Comparator)new AbstractSearchPage.FileSearchComparator("path"));
        String componentColumnTitle = Messages.FileSearchView_fileComponentColumn;
        labelProvider = new FileSearchLabelProvider("{2}", (ISetWithListeners<AbstractFileSystemItemWrapper>)files);
        LabelColumn componentColumn = new LabelColumn(viewer, componentColumnTitle, 300, (IViewerLabelProvider)labelProvider);
        componentColumn.setComparator((Comparator)new AbstractSearchPage.FileSearchComparator("component"));
        String versionIdCoumnTitle = Messages.FileSearchView_fileVersionColumn;
        labelProvider = new FileSearchLabelProvider("{3}", (ISetWithListeners<AbstractFileSystemItemWrapper>)files);
        LabelColumn versionColumn = new LabelColumn(viewer, versionIdCoumnTitle, 120, (IViewerLabelProvider)labelProvider);
        versionColumn.setComparator((Comparator)new AbstractSearchPage.FileSearchComparator("version"));
        this.supressLockActionsFromContextMenu(viewer);
    }

    private void supressLockActionsFromContextMenu(final SimpleTableViewer<AbstractFileSystemItemWrapper> viewer) {
        viewer.getContextMenu().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager arg0) {
                viewer.getContextMenu().remove("com.ibm.team.filesystem.ui.wrapper.FileItemWrapper.actions.LockAction");
                viewer.getContextMenu().remove("com.ibm.team.filesystem.ui.wrapper.FileItemWrapper.actions.UnlockAction");
                viewer.getContextMenu().remove("com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper.actions.LockAction");
                viewer.getContextMenu().remove("com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper.actions.UnlockAction");
            }
        });
    }
}

