/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.files;

import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.files.FileSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class FileSearchCriteriaPart
extends AbstractSearchCriteriaPart {
    private WritableValue fileSearchCriteriaValidation = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    public static final int DEFAULT_MAX_RESULTS = 50;
    public static final int HIGHEST_MAX_VALUE = 2048;
    public static final String ALL_STAR_PATTERN = "^\\*+$";
    public static final String ALL_FILE_PATTERN = "^\\*+\\.*[\\*\\?]*$";
    public static final String STAR_QUESTIONMARK_ONLY = "^((\\?+)(\\*+)([\\?\\*]*))+$";
    private Text fullOrPartialFileName;
    private Text maxSearchResultText;
    private Button caseSensitiveCheckBox;
    private boolean caseSensitive = false;
    private String fileNamePattern = "";

    public FileSearchCriteriaPart(IControlSite site, FileSearchCriteria input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        Composite parent = site.getParent();
        MnemonicGenerator mnemonics = context.getMnemonics();
        GridDataFactory dynamicData = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1);
        IEclipsePreferences prefs = this.getConfigPrefs();
        WidgetToolkit toolkit = context.getToolkit();
        Group whereToSearch = new Group(parent, 0);
        whereToSearch.setText(Messages.ChangeSetSearchCriteriaPart_contextGroup);
        this.createRepoLabel((Composite)whereToSearch, context);
        this.createRepositoryCombo((Composite)whereToSearch, prefs.node("repository"), context);
        dynamicData.copy().span(2, 1).applyTo(this.getRepositoryCombo().getControl());
        this.createLocationLabel((Composite)whereToSearch, context);
        this.createLocationCombo((Composite)whereToSearch, context, 36);
        dynamicData.copy().span(2, 1).applyTo(this.getLocationCombo().getControl());
        this.createComponentLabel((Composite)whereToSearch, context);
        this.createComponentCombo((Composite)whereToSearch, context, 1);
        dynamicData.copy().span(2, 1).applyTo(this.getComponentCombo().getControl());
        Dialog.applyDialogFont((Control)whereToSearch);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)whereToSearch);
        Group searchFilter = new Group(parent, 0);
        searchFilter.setText(Messages.FileSearchCriteria_searchFilterGrp);
        toolkit.createLabel((Composite)searchFilter, mnemonics.generate(Messages.BaslineSearchCriteriaPart_nameOrPatternFieldLabel));
        this.fullOrPartialFileName = toolkit.createText((Composite)searchFilter, "");
        dynamicData.copy().span(2, 1).applyTo((Control)this.fullOrPartialFileName);
        this.caseSensitiveCheckBox = toolkit.createButton((Composite)searchFilter, mnemonics.generate(Messages.FileSearchCriteriaPart_fileCaseSensitive), 32);
        this.caseSensitiveCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                FileSearchCriteriaPart.this.updateCaseSensitiveCheckBox();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)this.caseSensitiveCheckBox);
        GridDataFactory.generate((Control)this.caseSensitiveCheckBox, (int)3, (int)1);
        toolkit.createLabel((Composite)searchFilter, mnemonics.generate(Messages.AbstractSearchCriteriaPart_1));
        this.maxSearchResultText = this.createMaxResultText((Composite)searchFilter, (Preferences)prefs, context);
        dynamicData.copy().span(2, 1).applyTo((Control)this.maxSearchResultText);
        Dialog.applyDialogFont((Control)searchFilter);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)searchFilter);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.initialize(input.getRepo(), input.getComponentHandle(), (IContextHandle)input.getWorkspaceHandle(), null, null);
        this.getValidationStatus().addStatus((IObservableValue)this.fileSearchCriteriaValidation);
        this.fullOrPartialFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSearchCriteriaPart.this.fileNamePattern = FileSearchCriteriaPart.this.fullOrPartialFileName.getText();
                FileSearchCriteriaPart.this.validateSearchDialog(true);
            }
        });
        this.maxSearchResultText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSearchCriteriaPart.this.validateSearchDialog(true);
            }
        });
        this.validateSearchDialog(false);
        this.updateCaseSensitiveCheckBox();
    }

    @Override
    public Label createLocationLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.FileSearchCriteriaPart_fileLocationFieldLabel));
    }

    @Override
    public Text createMaxResultText(Composite parent, Preferences maxResultsPrefs, WidgetFactoryContext context) {
        String maxResults = maxResultsPrefs.get("maxResults", "100");
        return context.getToolkit().createText(parent, maxResults);
    }

    protected void updateCaseSensitiveCheckBox() {
        this.caseSensitive = this.caseSensitiveCheckBox.getSelection();
    }

    @Override
    public void componentComboSelectionChanged() {
        super.componentComboSelectionChanged();
        this.validateSearchDialog(true);
    }

    @Override
    public void locationComboSelectionChanged() {
        super.locationComboSelectionChanged();
        if (this.getLocationCombo() != null && this.getLocationCombo().getSelectedLocation() != null && this.getLocationCombo().isOneNodePresent()) {
            this.getLocationCombo().removeSpecialNode(this.getLocationCombo().getSpecialNodeText());
        }
        this.validateSearchDialog(true);
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        super.updateRepository(repository);
        if (this.getLocationCombo() != null) {
            this.getLocationCombo().addTheOneNode();
            this.getLocationCombo().selectTheOneNode();
        }
        if (this.getComponentCombo() != null) {
            this.getComponentCombo().addTheAnyNode();
            this.getComponentCombo().selectTheAnyNode();
        }
    }

    @Override
    public Text getMaxResultsText() {
        return this.maxSearchResultText;
    }

    public FileSearchCriteria getResult() {
        return new FileSearchCriteria(this.getRepository(), this.getWorkspaceHandleFromLocationComboSelection(), this.getComponentHndlFromComponentComboSelection(), this.getFileNamePattern(), this.isCaseSensitiveCheckBoxEnabled(), this.getMaxResults(this.getMaxResultsText(), 50));
    }

    private IWorkspaceHandle getWorkspaceHandleFromLocationComboSelection() {
        ContextWrapper ctxWrapper = this.getLocationCombo().getSelectedLocation();
        return ctxWrapper != null ? (IWorkspaceHandle)ctxWrapper.getContextHandle() : null;
    }

    private IComponentHandle getComponentHndlFromComponentComboSelection() {
        ComponentWrapper componentWrapper = this.getComponentCombo().getComponent();
        return componentWrapper != null ? (IComponentHandle)componentWrapper.getLocator().toHandle() : null;
    }

    private String getFileNamePattern() {
        return StringUtils.isEmpty((String)this.fileNamePattern) ? null : this.fileNamePattern.trim();
    }

    private boolean isCaseSensitiveCheckBoxEnabled() {
        return this.caseSensitive;
    }

    private int getMaxResults(Text maxResultTxt, int defaultMax) {
        int maxResults = defaultMax;
        String maxResltTxt = maxResultTxt.getText();
        try {
            maxResults = Integer.parseInt(maxResltTxt);
        }
        catch (NumberFormatException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        return maxResults;
    }

    public void validateSearchDialog(boolean showErrorIcon) {
        IStatus status = Status.OK_STATUS;
        if (showErrorIcon) {
            boolean repoSelected = this.getRepositoryCombo() != null && this.getRepositoryCombo().getRepository() != null;
            boolean locationSelected = this.getLocationCombo() != null && this.getLocationCombo().getSelectedLocation() != null;
            boolean isFileNamePatternEmpty = StringUtils.isEmpty((String)this.fileNamePattern);
            String maxResultText = this.maxSearchResultText.getText().trim();
            if (!repoSelected) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.RepositoryCombo_5);
            }
            if (!locationSelected) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.AddComponentFromWorkspacePage1_description);
            }
            if (isFileNamePatternEmpty) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.FileSearchCriteriaPart_fileNamePatternMissing);
            } else if (FileSearchCriteriaPart.isInvalidPattern(this.fileNamePattern)) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.FileSearchCriteriaPart_fileNamePatternInvalid);
            }
            if (FileSearchCriteriaPart.isInvalidMaxResult(maxResultText)) {
                String error = NLS.bind((String)Messages.AbstractSearchCriteriaPart_0, (Object)Messages.AbstractSearchCriteriaPart_2, (Object)2048);
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)error);
            }
        }
        if (!showErrorIcon) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)4, (int)-1163014131, (String)Messages.ChangeSetSearchCriteriaWizardPage_pageDescription);
        }
        this.fileSearchCriteriaValidation.setValue((Object)status);
    }

    private static boolean isInvalidPattern(String fileNamePattern) {
        String name = fileNamePattern.trim();
        return name.matches(ALL_STAR_PATTERN) || name.matches(ALL_FILE_PATTERN) || name.matches(STAR_QUESTIONMARK_ONLY);
    }

    private static boolean isInvalidMaxResult(String mxResult) {
        if (StringUtils.isEmpty((String)mxResult)) {
            return true;
        }
        try {
            int i = Integer.parseInt(mxResult);
            return i < 1 || i > 2048;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.fullOrPartialFileName != null && !this.fullOrPartialFileName.isDisposed()) {
            this.fullOrPartialFileName.setEnabled(isEnabled);
        }
        if (this.caseSensitiveCheckBox != null && !this.caseSensitiveCheckBox.isDisposed()) {
            this.caseSensitiveCheckBox.setEnabled(isEnabled);
        }
    }
}

