/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.files;

import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.files.FileSearchQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class FileSearchCriteria
extends AbstractSearchInput<AbstractFileSystemItemWrapper> {
    private ITeamRepository repo;
    private IWorkspaceHandle workspaceHandle;
    private IComponentHandle componentHandle;
    private ItemId<IWorkspace> workspaceItemId = ItemId.getNullItem((IItemType)IWorkspace.ITEM_TYPE);
    private ItemId<IComponent> componentItemId = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    private String fileNamePattern = "";
    private boolean caseSensitive = false;

    public FileSearchCriteria(ITeamRepository repo) {
        this.repo = repo;
    }

    public FileSearchCriteria(ITeamRepository repo, IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, String fileNamePattern, boolean caseSensitive, int maxResults) {
        if (repo == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        this.repo = repo;
        if (workspaceHandle == null || workspaceHandle.getItemId() == null || workspaceHandle.getItemType() == null) {
            throw new IllegalArgumentException("workspace handle or workspacehandle's itemId or itemType cannot be null");
        }
        if (StringUtils.isEmpty((String)fileNamePattern)) {
            throw new IllegalArgumentException("fileNamePattern cannot be null or empty");
        }
        this.workspaceHandle = workspaceHandle;
        this.componentHandle = componentHandle;
        this.fileNamePattern = fileNamePattern;
        this.caseSensitive = caseSensitive;
        this.setMaxResults(maxResults);
        this.workspaceItemId = new ItemId((IItemHandle)workspaceHandle);
        this.componentItemId = componentHandle != null && componentHandle.getItemId() != null && componentHandle.getItemType() != null ? new ItemId((IItemHandle)componentHandle) : null;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        String searchName = "";
        Object[] bindValues = new String[4];
        Map fetched = null;
        IWorkspace workspace = null;
        IComponent component = null;
        boolean isStream = false;
        boolean componentPresent = false;
        if (this.repo == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        if (this.workspaceItemId != null) {
            if (this.componentItemId != null) {
                fetched = RepoFetcher.fetchCurrents((ITeamRepository)this.repo, (IProgressMonitor)monitor, (ItemId[])new ItemId[]{this.workspaceItemId, this.componentItemId});
                component = (IComponent)fetched.get(this.componentItemId);
                componentPresent = component != null;
            } else {
                fetched = RepoFetcher.fetchCurrents((ITeamRepository)this.repo, (IProgressMonitor)monitor, (ItemId[])new ItemId[]{this.workspaceItemId});
            }
            workspace = (IWorkspace)fetched.get(this.workspaceItemId);
            boolean bl = isStream = workspace != null && workspace.isStream();
        }
        if (!StringUtils.isEmpty((String)this.fileNamePattern)) {
            bindValues[0] = this.fileNamePattern;
            String repoName = RepositoryUtils.getLabel(this.repo);
            if (componentPresent) {
                bindValues[1] = component.getName();
                bindValues[2] = workspace.getName();
                bindValues[3] = repoName;
                searchName = !isStream ? (this.caseSensitive ? Messages.FileSearchCriteria_searchNameText1 : Messages.FileSearchCriteria_searchNameText5) : (this.caseSensitive ? Messages.FileSearchCriteria_searchNameText3 : Messages.FileSearchCriteria_searchNameText7);
            } else {
                bindValues[1] = workspace.getName();
                bindValues[2] = repoName;
                searchName = !isStream ? (this.caseSensitive ? Messages.FileSearchCriteria_searchNameText2 : Messages.FileSearchCriteria_searchNameText6) : (this.caseSensitive ? Messages.FileSearchCriteria_searchNameText4 : Messages.FileSearchCriteria_searchNameText8);
            }
            searchName = NLS.bind((String)searchName, (Object[])bindValues);
        }
        return searchName;
    }

    @Override
    public ISetWithListeners<AbstractFileSystemItemWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        FileSearchQuery result = new FileSearchQuery(runner, this);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    public ITeamRepository getRepo() {
        return this.repo;
    }

    public FileSearchCriteria setRepo(ITeamRepository repo) {
        this.repo = repo;
        if (repo == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        return this;
    }

    public IWorkspaceHandle getWorkspaceHandle() {
        return this.workspaceHandle;
    }

    public FileSearchCriteria setWorkspaceHandle(IWorkspaceHandle workspaceHandle) {
        this.workspaceHandle = workspaceHandle;
        this.workspaceItemId = workspaceHandle != null ? new ItemId((IItemHandle)workspaceHandle) : null;
        return this;
    }

    public IComponentHandle getComponentHandle() {
        return this.componentHandle;
    }

    public FileSearchCriteria setComponentHandle(IComponentHandle componentHandle) {
        this.componentHandle = componentHandle;
        this.componentItemId = componentHandle != null ? new ItemId((IItemHandle)componentHandle) : null;
        return this;
    }

    public ItemId<IWorkspace> getWorkspaceItemId() {
        return this.workspaceItemId;
    }

    public FileSearchCriteria setWorkspaceItemId(ItemId<IWorkspace> workspaceItemId) {
        this.workspaceItemId = workspaceItemId;
        return this;
    }

    public ItemId<IComponent> getComponentItemId() {
        return this.componentItemId;
    }

    public FileSearchCriteria setComponentItemId(ItemId<IComponent> componentItemId) {
        this.componentItemId = componentItemId;
        return this;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public FileSearchCriteria setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public FileSearchCriteria setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput criteria) {
        return false;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria criteria) {
        return false;
    }

    @Override
    public ITeamRepository getRepository() {
        return null;
    }
}

