/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ReadScopeWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentWrapperLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentOwnerFunction;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentReadScopeFunction;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentWrapperComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Comparator;
import org.eclipse.jface.viewers.IViewerLabelProvider;

public class ComponentSearchView
extends AbstractSearchPage<ComponentWrapper> {
    public ComponentSearchView(IControlSite site, ComponentSearchCriteria initialInput) {
        super(site, initialInput);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.component";
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<ComponentWrapper> viewer) {
        ISetWithListeners components = viewer.getKnownElements();
        IOperationRunner opRunner = this.getControlSite().getOperationRunner();
        ComponentWrapperLabelProvider lp = new ComponentWrapperLabelProvider(components, opRunner);
        lp.setShowOwnerHint(false);
        String nameColumnTitle = Messages.ComponentSearchView_nameColumn;
        LabelColumn nameColumn = new LabelColumn(viewer, nameColumnTitle, 200, (IViewerLabelProvider)lp);
        nameColumn.setComparator((Comparator)new ComponentWrapperComparator());
        String ownerColumnTitle = Messages.ComponentSearchView_ownerColumn;
        ComponentOwnerFunction ownerFunction = new ComponentOwnerFunction(components, opRunner);
        ConvertColumn ownerColumn = new ConvertColumn(viewer, ownerColumnTitle, 200, (IDynamicFunction)ownerFunction);
        ownerColumn.setCellComparator(ownerComparator);
        String visibilityColumnTitle = Messages.ComponentSearchView_visibilityColumn;
        ComponentReadScopeFunction visibilityFunction = new ComponentReadScopeFunction((ISetWithListeners<ComponentWrapper>)components, opRunner);
        ConvertColumn column = new ConvertColumn(viewer, visibilityColumnTitle, 200, (IDynamicFunction)visibilityFunction);
        column.setShowItemInContextMenu(false);
        column.setCellLabelProvider(ReadScopeWrapper.getLabelProvider());
    }
}

