/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.OwnerSearchQuery;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ComponentSearchQuery
extends OwnerSearchQuery {
    private ComponentSearchCriteria criteria;
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> listener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        public void changed(FilteredFetcher source, List<ItemChangeEvent> property) {
            boolean refresh = false;
            for (ItemChangeEvent event : property) {
                if (event.getAfterState() != null && event.getBeforeState() != null) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                ComponentSearchQuery.this.update();
            }
        }
    };
    private IListener genericListener = new IListener(){

        public void handleEvents(List events) {
            boolean refresh = false;
            for (IPropertyChangeEvent event : events) {
                if (event.getNewValue() != null && event.getOldValue() != null) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                ComponentSearchQuery.this.update();
            }
        }
    };
    private FilteredFetcher componentFetcher;

    public ComponentSearchQuery(ITeamRepository repository, IOperationRunner runner, ComponentSearchCriteria searchCriteria, IConnectedProjectAreaRegistry registry) {
        super(Realm.getDefault(), repository, runner, searchCriteria.getOwnedBy(), registry);
        this.criteria = searchCriteria;
        this.componentFetcher = new FilteredFetcher(repository);
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = this.getRepository();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        Set<ItemId<IAuditable>> owners = this.computeOwners(needsRefresh, (IProgressMonitor)progress.newChild(30));
        ArrayList componentHandles = null;
        try {
            componentHandles = new ArrayList();
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(10);
            IComponentSearchCriteria crit = IComponentSearchCriteria.FACTORY.newInstance();
            crit.setPartialName(this.criteria.getStartsWith());
            for (ItemId<IAuditable> owner : owners) {
                if (owner == null || owner.isNull()) continue;
                IAuditableHandle ownerHandle = (IAuditableHandle)owner.toHandle();
                crit.getFilterByOwnerOptional().add(ownerHandle);
            }
            componentHandles.addAll(workspaceManager.findComponents(crit, this.criteria.getMaxResults(), (IProgressMonitor)loopProgress.newChild(10)));
        }
        catch (TeamRepositoryException e) {
            LoggingHelper.log((String)"com.ibm.team.filesystem.ide.ui", (TeamRepositoryException)e);
            return Collections.EMPTY_LIST;
        }
        List componentItemIds = ItemLists.handlesToIds(componentHandles);
        Collection fetchedComponents = this.componentFetcher.fetchCurrents((Collection)componentItemIds, needsRefresh, (IProgressMonitor)progress.newChild(20)).values();
        ArrayList<ComponentWrapper> componentWrappers = new ArrayList<ComponentWrapper>();
        for (IComponent next : fetchedComponents) {
            componentWrappers.add(new ComponentWrapper(repo, next));
        }
        return componentWrappers;
    }

    @Override
    protected void attachListeners() {
        this.componentFetcher.addListener(IComponent.ITEM_TYPE, this.listener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"components", this.genericListener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"component_owner", this.genericListener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"component_visibility", this.genericListener);
        super.attachListeners();
    }

    @Override
    protected void detachListeners() {
        super.detachListeners();
        this.componentFetcher.removeListener(IComponent.ITEM_TYPE, this.listener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"components", this.genericListener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"component_owner", this.genericListener);
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"component_visibility", this.genericListener);
    }

    public String getName() {
        return Messages.ComponentSearchQuery_queryName;
    }
}

