/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class ComponentSearchCriteriaPart
extends AbstractSearchCriteriaPart<ComponentSearchCriteria> {
    private Text name;

    public ComponentSearchCriteriaPart(IControlSite site, Input input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        MnemonicGenerator mnemonics = new MnemonicGenerator((IMnemonicGenerationAlgorithm)site.getMnemonicGenerator());
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        this.createRepoLabel(parent, context);
        this.createRepositoryCombo(parent, (Preferences)this.getConfigPrefs(), context);
        this.getRepositoryCombo().setEnabled(!input.getLockRepository());
        this.getRepositoryCombo().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ComponentSearchCriteriaPart.this.getOwnerCombo().selectTheAnyNode();
            }
        });
        if (input.getStartsWith() != null) {
            toolkit.createLabel(parent, mnemonics.generate(Messages.ComponentSearchCriteriaPart_nameStartsWithFieldLabel));
            this.name = toolkit.createText(parent, "");
            this.name.setText(input.getStartsWith());
            this.name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ComponentSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                }
            });
        }
        this.createOwnerLabel(parent, context, Messages.PlaceSearchCriteriaPart_ownedByComboLabel);
        this.createOwnerCombo(parent, context, 15);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
        this.initialize(input.getRepository(), null, null, input.getOwnedBy(), null);
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    public Text getNameBeginsWithText() {
        return this.name;
    }

    @Override
    public ComponentSearchCriteria getResult() {
        String nameContains = this.getNameBeginsWithText() == null ? "" : this.getNameBeginsWithText().getText();
        ItemId selectedOwner = this.getOwnerCombo().getSelection();
        if (selectedOwner == null) {
            selectedOwner = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        ComponentSearchCriteria criteria = new ComponentSearchCriteria(this.getRepository(), null, nameContains, (ItemId<? extends IAuditable>)selectedOwner);
        return criteria;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.getNameBeginsWithText() != null && !this.getNameBeginsWithText().isDisposed()) {
            this.getNameBeginsWithText().setEnabled(isEnabled);
        }
    }

    public static class Input {
        private boolean lockRepository;
        private ITeamRepository repo;
        private String startsWith;
        private ItemId<? extends IAuditable> ownedBy;

        public Input(ITeamRepository repo, boolean lockRepository, String startsWith, ItemId<? extends IAuditable> ownedBy) {
            this.repo = repo;
            this.lockRepository = lockRepository;
            this.startsWith = startsWith;
            this.ownedBy = ownedBy;
        }

        public boolean getLockRepository() {
            return this.lockRepository;
        }

        public ITeamRepository getRepository() {
            return this.repo;
        }

        public String getStartsWith() {
            return this.startsWith;
        }

        public ItemId<? extends IAuditable> getOwnedBy() {
            return this.ownedBy;
        }
    }
}

