/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchQuery;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public final class ComponentSearchCriteria
extends AbstractSearchInput<ComponentWrapper> {
    public static final Object TYPE_STREAM = new String("Stream");
    public static final Object TYPE_WORKSPACE = new String("Repository Workspace");
    public static final Object TYPE_ANY = new String("Any");
    private String nameContains;
    private ItemId<? extends IAuditable> ownedBy;
    private ITeamRepository repository;
    private IConnectedProjectAreaRegistry registry;

    public static ComponentSearchCriteria createFromSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry, IComponentSearchCriteria searchCriteria) {
        String startsWith = "";
        ItemId owner = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        if (searchCriteria != null) {
            List owners;
            if (searchCriteria.getPartialName() != null) {
                startsWith = searchCriteria.getPartialName();
            }
            if ((owners = searchCriteria.getFilterByOwnerOptional()) != null && owners.size() > 0 && owners.get(0) != null) {
                owner = ItemId.create((IItemHandle)((IItemHandle)owners.get(0)));
            }
        }
        ComponentSearchCriteria componentSearchCriteria = new ComponentSearchCriteria(repository, registry, startsWith, (ItemId<? extends IAuditable>)owner);
        return componentSearchCriteria;
    }

    public ComponentSearchCriteria(ITeamRepository repository) {
        this(repository, null);
    }

    public ComponentSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry) {
        this(repository, registry, "", (ItemId<? extends IAuditable>)ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE));
    }

    public ComponentSearchCriteria(ITeamRepository repository, IConnectedProjectAreaRegistry registry, String nameContains, ItemId<? extends IAuditable> ownedBy) {
        this.nameContains = nameContains;
        this.ownedBy = ownedBy;
        this.repository = repository;
        this.registry = registry;
    }

    public ComponentSearchCriteria withOwnedBy(ItemId<? extends IAuditable> ownedBy) {
        ComponentSearchCriteria result = this.copy();
        result.ownedBy = ownedBy;
        return result;
    }

    public ComponentSearchCriteria startsWith(String name) {
        ComponentSearchCriteria result = this.copy();
        result.nameContains = name;
        return result;
    }

    public ComponentSearchCriteria withRepository(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository should not be null");
        }
        ComponentSearchCriteria result = this.copy();
        result.repository = repository;
        return result;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    public ComponentSearchCriteria copy() {
        ComponentSearchCriteria criteria = new ComponentSearchCriteria(this.repository, this.registry, this.nameContains, this.ownedBy);
        criteria.setMaxResults(this.getMaxResults());
        return criteria;
    }

    public String getStartsWith() {
        return this.nameContains;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isAllComponents()) {
            return NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)Messages.ComponentSearchCriteria_componentsNoun, (Object)RepositoryUtils.getLabel(this.repository));
        }
        String workspaceName = Messages.ComponentSearchCriteria_componentsNoun;
        if (!this.getStartsWith().equals("")) {
            workspaceName = NLS.bind((String)Messages.ComponentSearchCriteria_nameStartsWithPhrase, (Object)workspaceName, (Object)this.getStartsWith());
        }
        workspaceName = this.getOwnedBy().isNull() ? NLS.bind((String)Messages.ComponentSearchCriteria_componentWithAnyOwnerPhrase, (Object)workspaceName) : NLS.bind((String)Messages.ComponentSearchCriteria_componentWithParticularOwnerPhrase, (Object)workspaceName, (Object)this.computeOwnerName(monitor));
        return NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)workspaceName, (Object)RepositoryUtils.getLabel(this.repository));
    }

    private String computeOwnerName(IProgressMonitor monitor) throws TeamRepositoryException {
        IItem item = RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), this.ownedBy, (IProgressMonitor)monitor);
        if (item instanceof IProcessArea) {
            IProcessArea processArea = (IProcessArea)item;
            return processArea.getName();
        }
        if (item instanceof IContributor) {
            IContributor contributor = (IContributor)item;
            return contributor.getName();
        }
        return Messages.ComponentSearchCriteria_unknownOwner;
    }

    public ISetWithListeners<ComponentWrapper> getQuery(IOperationRunner runner) {
        return this.getQuery(runner, false);
    }

    @Override
    public ISetWithListeners<ComponentWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        ComponentSearchQuery result = new ComponentSearchQuery(this.repository, runner, this, this.registry);
        result.setAutoUpdate(!lazyUpdates);
        return result;
    }

    public ItemId<? extends IAuditable> getOwnedBy() {
        return this.ownedBy;
    }

    public boolean isAllComponents() {
        return this.nameContains.equals("") && this.ownedBy.isNull();
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria criteria) {
        if (!(criteria instanceof IComponentSearchCriteria)) {
            return false;
        }
        IComponentSearchCriteria other = (IComponentSearchCriteria)criteria;
        ITeamRepository thisRepo = this.getRepository();
        ITeamRepository otherRepo = this.getRepository();
        if (thisRepo == null && otherRepo != null || thisRepo != null && otherRepo == null || thisRepo != null && otherRepo != null && !thisRepo.equals(otherRepo)) {
            return false;
        }
        String thisStartsWith = this.getStartsWith();
        String otherStartsWith = other.getPartialName();
        return !(thisStartsWith == null && otherStartsWith != null || thisStartsWith != null && otherStartsWith == null) && (thisStartsWith == null || otherStartsWith == null || thisStartsWith.equals(otherStartsWith));
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput criteria) {
        if (!(criteria instanceof ComponentSearchCriteria)) {
            return false;
        }
        ComponentSearchCriteria other = (ComponentSearchCriteria)criteria;
        ITeamRepository thisRepo = this.getRepository();
        ITeamRepository otherRepo = other.getRepository();
        if (thisRepo == null && otherRepo != null || thisRepo != null && otherRepo == null || thisRepo != null && otherRepo != null && !thisRepo.equals(otherRepo)) {
            return false;
        }
        ItemId<? extends IAuditable> thisOwner = this.getOwnedBy();
        ItemId<? extends IAuditable> otherOwner = other.getOwnedBy();
        if (thisOwner == null && otherOwner != null || thisOwner != null && otherOwner == null || thisOwner != null && otherOwner != null && !thisOwner.equals(otherOwner)) {
            return false;
        }
        String thisStartsWith = this.getStartsWith();
        String otherStartsWith = other.getStartsWith();
        return !(thisStartsWith == null && otherStartsWith != null || thisStartsWith != null && otherStartsWith == null) && (thisStartsWith == null || otherStartsWith == null || thisStartsWith.equals(otherStartsWith));
    }

    public static IComponentSearchCriteria getEquivalentSearchCriteria(ComponentSearchCriteria uiSearchCriteria) {
        ItemId<? extends IAuditable> searchCriteriaOwner;
        IComponentSearchCriteria componentSearchCriteria = IComponentSearchCriteria.FACTORY.newInstance();
        if (uiSearchCriteria.getStartsWith() != null) {
            componentSearchCriteria.setPartialName(uiSearchCriteria.getStartsWith());
        }
        if ((searchCriteriaOwner = uiSearchCriteria.getOwnedBy()) != null && !searchCriteriaOwner.isNull()) {
            componentSearchCriteria.getFilterByOwnerOptional().add((IAuditableHandle)searchCriteriaOwner.toHandle());
        }
        return componentSearchCriteria;
    }
}

