/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.ReadScopeFunction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComponentReadScopeFunction
extends ReadScopeFunction<ComponentWrapper> {
    private IListener fListener = new IListener(){

        public void handleEvents(List events) {
            for (Object event : events) {
                PropertyChangeEvent propertyChange;
                if (!(event instanceof PropertyChangeEvent) || !"component_owner".equals((propertyChange = (PropertyChangeEvent)event).getProperty()) && !"component_visibility".equals(propertyChange.getProperty())) continue;
                IComponent component = (IComponent)propertyChange.getObject();
                ComponentWrapper changed = new ComponentWrapper((ITeamRepository)propertyChange.getData(), component);
                ComponentReadScopeFunction.this.markDirty((Object)changed);
            }
        }
    };

    public ComponentReadScopeFunction(ISetWithListeners<ComponentWrapper> domain, IOperationRunner runner) {
        super(domain, runner);
    }

    protected void elementAdded(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.addGenericListener((Object)"component_owner", this.fListener);
        mgr.addGenericListener((Object)"component_visibility", this.fListener);
        super.elementAdded((Object)wrapper);
    }

    protected void elementRemoved(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.removeGenericListener((Object)"component_owner", this.fListener);
        mgr.removeGenericListener((Object)"component_visibility", this.fListener);
        super.elementRemoved((Object)wrapper);
    }

    @Override
    protected Map<ComponentWrapper, IReadScope> getReadScopes(Collection<ComponentWrapper> toFetch, IProgressMonitor monitor) throws TeamRepositoryException {
        if (toFetch.isEmpty()) {
            return Collections.emptyMap();
        }
        ITeamRepository repository = toFetch.iterator().next().getRepository();
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        ArrayList<IComponent> components = new ArrayList<IComponent>(toFetch.size());
        for (ComponentWrapper componentWrapper : toFetch) {
            components.add(componentWrapper.getComponent());
        }
        List scopes = mgr.findReadScopeForComponents(components, monitor);
        HashMap results = NewCollection.hashMap();
        Iterator<ComponentWrapper> componentIterator = toFetch.iterator();
        Iterator scopeIterator = scopes.iterator();
        while (componentIterator.hasNext() && scopeIterator.hasNext()) {
            results.put(componentIterator.next(), (IReadScope)scopeIterator.next());
        }
        return results;
    }
}

