/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.ContributorFunction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ComponentOwnerFunction
extends ContributorFunction<ComponentWrapper> {
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            for (Object event : events) {
                PropertyChangeEvent propertyChange;
                if (!(event instanceof PropertyChangeEvent) || !(propertyChange = (PropertyChangeEvent)event).getProperty().equals("component_owner")) continue;
                IComponent component = (IComponent)propertyChange.getObject();
                ComponentWrapper changed = new ComponentWrapper((ITeamRepository)propertyChange.getData(), component);
                ComponentOwnerFunction.this.markDirty((Object)changed);
            }
        }
    };

    public ComponentOwnerFunction(ISetWithListeners domain, IOperationRunner runner) {
        super(domain, runner);
    }

    protected void elementAdded(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.addGenericListener((Object)"component_owner", this.listener);
        super.elementAdded((Object)wrapper);
    }

    protected void elementRemoved(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.removeGenericListener((Object)"component_owner", this.listener);
        super.elementRemoved((Object)wrapper);
    }

    @Override
    protected boolean shouldBatch() {
        return true;
    }

    @Override
    protected ItemLocator getContributor(ComponentWrapper wrapper) throws TeamRepositoryException {
        throw new IllegalArgumentException();
    }

    @Override
    protected Map<ComponentWrapper, ItemLocator<IAuditable>> getContributors(Collection<ComponentWrapper> element, IProgressMonitor monitor) throws TeamRepositoryException {
        if (element.size() == 0) {
            return new HashMap<ComponentWrapper, ItemLocator<IAuditable>>();
        }
        ITeamRepository repository = element.iterator().next().getRepository();
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        ArrayList<IComponent> components = new ArrayList<IComponent>(element.size());
        ArrayList<ComponentWrapper> componentWrappers = new ArrayList<ComponentWrapper>();
        for (ComponentWrapper componentWrapper : element) {
            components.add(componentWrapper.getComponent());
            componentWrappers.add(componentWrapper);
        }
        List findOwnersForComponents = mgr.findOwnersForComponents(components, monitor);
        HashMap<ComponentWrapper, ItemLocator<IAuditable>> locators = new HashMap<ComponentWrapper, ItemLocator<IAuditable>>();
        int i = 0;
        for (IAuditableHandle owner : findOwnersForComponents) {
            locators.put((ComponentWrapper)((Object)componentWrappers.get(i++)), (ItemLocator<IAuditable>)new ItemLocator(repository, owner));
        }
        return locators;
    }
}

