/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.component;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.ContributorFunction;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public final class ComponentDetailsFunction
extends SlowFunction<ComponentWrapper, ComponentDetails> {
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            for (Object event : events) {
                PropertyChangeEvent propertyChange;
                if (!(event instanceof PropertyChangeEvent) || !(propertyChange = (PropertyChangeEvent)event).getProperty().equals("component_owner") && !propertyChange.getProperty().equals("component_visibility")) continue;
                IComponent component = (IComponent)propertyChange.getObject();
                ComponentWrapper changed = new ComponentWrapper((ITeamRepository)propertyChange.getData(), component);
                ComponentDetailsFunction.this.markDirty((Object)changed);
            }
        }
    };

    public ComponentDetailsFunction(ISetWithListeners domain, IOperationRunner runner) {
        super(domain, runner, Display.getCurrent(), true);
    }

    protected void elementAdded(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.addGenericListener((Object)"component_owner", this.listener);
        mgr.addGenericListener((Object)"component_visibility", this.listener);
        super.elementAdded((Object)wrapper);
    }

    protected void elementRemoved(ComponentWrapper wrapper) {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
        mgr.removeGenericListener((Object)"component_owner", this.listener);
        mgr.removeGenericListener((Object)"component_visibility", this.listener);
        super.elementRemoved((Object)wrapper);
    }

    private static Map<ITeamRepository, List<ComponentWrapper>> findRepo(Collection<ComponentWrapper> toFetch) {
        HashMap<ITeamRepository, List<ComponentWrapper>> sorted = new HashMap<ITeamRepository, List<ComponentWrapper>>();
        for (ComponentWrapper componentWrapper : toFetch) {
            if (componentWrapper == null) continue;
            ArrayList<ComponentWrapper> cwList = (ArrayList<ComponentWrapper>)sorted.get(componentWrapper.getRepository());
            if (cwList == null) {
                cwList = new ArrayList<ComponentWrapper>();
                sorted.put(componentWrapper.getRepository(), cwList);
            }
            cwList.add(componentWrapper);
        }
        return sorted;
    }

    public static Map<ComponentWrapper, ComponentDetails> fetchComponentDetails(Collection<ComponentWrapper> toFetch, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap result = NewCollection.hashMap();
        if (toFetch.isEmpty()) {
            return result;
        }
        Map<ITeamRepository, List<ComponentWrapper>> repos = ComponentDetailsFunction.findRepo(toFetch);
        for (ITeamRepository repo : repos.keySet()) {
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            List components = new ArrayList<IComponent>();
            HashMap<UUID, ComponentWrapper> componentWrappers = new HashMap<UUID, ComponentWrapper>();
            for (ComponentWrapper next : repos.get(repo)) {
                IComponent component = next.getComponent();
                components.add(component);
                componentWrappers.put(component.getItemId(), next);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            components = repo.itemManager().fetchCompleteItemsPermissionAware(components, 1, (IProgressMonitor)progress.newChild(25)).getRetrievedItems();
            if (components.isEmpty()) continue;
            List findOwnersForComponents = mgr.findOwnersForComponents(components, (IProgressMonitor)progress.newChild(25));
            List owners = repo.itemManager().fetchCompleteItems(findOwnersForComponents, 0, (IProgressMonitor)progress.newChild(25));
            List findVisibilityForComponents = mgr.findReadScopeForComponents(components, (IProgressMonitor)progress.newChild(25));
            int j = 0;
            while (j < components.size()) {
                IReadScope viz = (IReadScope)findVisibilityForComponents.get(j);
                AbstractWrapper wrapper = ContributorFunction.fromOwner((IAuditable)owners.get(j), repo);
                ComponentDetails details = new ComponentDetails(viz, wrapper);
                result.put((ComponentWrapper)((Object)componentWrappers.get(((IComponent)components.get(j)).getItemId())), details);
                ++j;
            }
        }
        return result;
    }

    protected Map<ComponentWrapper, ComponentDetails> doFetch(Collection<ComponentWrapper> toFetch, IProgressMonitor monitor) throws OperationFailedException {
        try {
            return ComponentDetailsFunction.fetchComponentDetails(toFetch, monitor);
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus(ComponentDetailsFunction.class, (Throwable)e));
        }
    }

    protected ComponentDetails getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return Messages.ComponentOwnerFunction_0;
    }
}

