/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset.actions;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenChangeSetAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        UIContext context = this.getContext();
        List result = selection.toList();
        OpenChangeSetAction.openChangeSets(context, result, true);
    }

    public static ItemId<IWorkspace> pickBestWorkspace(List<IChangeSet> changeSets) {
        Set<ItemId<IComponent>> referencedComponents = OpenChangeSetAction.computeReferencedComponents(changeSets);
        ItemId<IWorkspace> bestWorkspace = OpenChangeSetAction.pickBestWorkspaceFor(referencedComponents);
        return bestWorkspace;
    }

    public static SnapshotId getSnapshot(UIContext context, List<ChangeSetWrapper> result) {
        if (result.isEmpty()) {
            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.OpenChangeSetAction_noResultsDialogTitle, (IStatus)StatusUtil.newStatus(OpenChangeSetAction.class, (int)1, (String)Messages.OpenChangeSetAction_noResultsDialogText));
            return null;
        }
        HashSet repos = NewCollection.hashSet();
        SnapshotId snapshot = null;
        for (ChangeSetWrapper next : result) {
            repos.add(next.getRepository());
            if (!(next instanceof ChangeSetInContextWrapper)) continue;
            ChangeSetInContextWrapper changeSetInContext = (ChangeSetInContextWrapper)next;
            snapshot = changeSetInContext.getSnapshot();
        }
        if (repos.size() > 1) {
            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.OpenChangeSetAction_unableToOpenSelectionDialogTitle, (IStatus)StatusUtil.newStatus(OpenChangeSetAction.class, (int)1, (String)Messages.OpenChangeSetAction_unableToOpenSelectionDialogText));
            return null;
        }
        ITeamRepository repo = (ITeamRepository)repos.iterator().next();
        if (snapshot == null) {
            snapshot = SnapshotId.createEmptyId((ITeamRepository)repo);
        }
        return snapshot;
    }

    public static void openChangeSets(UIContext context, List<ChangeSetWrapper> result, boolean inChangeExplorer) {
        SnapshotId snapshot = OpenChangeSetAction.getSnapshot(context, result);
        if (snapshot != null) {
            List changeSets = CollectionUtil.filterDupes(ChangeSetWrapper.getChangeSets(result));
            ChangesViewConverter.openChangeExplorer(context.getPage(), new ChangeSetInput(snapshot, changeSets));
        }
    }

    public static void openChangeSetsInChangeSummary(UIContext context, List<ChangeSetWrapper> result) {
        SnapshotId snapshot = OpenChangeSetAction.getSnapshot(context, result);
        if (snapshot != null) {
            List changeSets = CollectionUtil.filterDupes(ChangeSetWrapper.getChangeSets(result));
            ChangeSummaryView.open(snapshot, changeSets);
        }
    }

    public static ItemId<IWorkspace> pickBestWorkspaceFor(Set<ItemId<IComponent>> referencedComponents) {
        ComponentSyncModel model = (ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext[] contexts = model.getWorkspaceSyncContexts();
        ItemId bestSoFar = ItemId.getNullItem((IItemType)IWorkspace.ITEM_TYPE);
        int bestMatchedComponents = 0;
        int bestMatchedLoadedComponents = 0;
        int idx = 0;
        while (idx < contexts.length) {
            boolean isNewBest;
            IWorkspaceSyncContext next = contexts[idx];
            IComponentSyncContext[] components = next.getComponentSyncContexts();
            ItemId nextWorkspace = ItemId.forItem((IItem)next.getLocal().getResolvedWorkspace());
            int matchedComponents = 0;
            int matchedLoadedComponents = 0;
            int contextIdx = 0;
            while (contextIdx < components.length) {
                IComponentSyncContext nextContext = components[contextIdx];
                ItemId<IComponent> nextComponent = PendingChangesUtil.getComponent(nextContext);
                if (referencedComponents.contains(nextComponent)) {
                    ++matchedComponents;
                    if (PendingChangesUtil.isLoaded(nextContext)) {
                        ++matchedLoadedComponents;
                    }
                }
                ++contextIdx;
            }
            boolean bl = isNewBest = matchedComponents > bestMatchedComponents;
            if (matchedComponents == bestMatchedComponents) {
                boolean bl2 = isNewBest = matchedLoadedComponents > bestMatchedLoadedComponents;
            }
            if (isNewBest) {
                bestSoFar = nextWorkspace;
                bestMatchedLoadedComponents = matchedLoadedComponents;
                bestMatchedComponents = matchedComponents;
            }
            ++idx;
        }
        return bestSoFar;
    }

    protected static Set<ItemId<IComponent>> computeReferencedComponents(List<IChangeSet> changeSets) {
        HashSet result = NewCollection.hashSet();
        for (IChangeSet next : changeSets) {
            result.add(ChangeSetUtil.getComponent((IChangeSet)next));
        }
        return result;
    }
}

