/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.changes.actions.AcceptChangeSetFromWildAction;
import com.ibm.team.filesystem.ui.changes.actions.StandardAcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AcceptChangeSetAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        final List<ItemLocator<IChangeSet>> changeSets = this.extractChangeSets(selection.toList());
        UIContext context = this.getContext();
        final WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(context, Messages.AcceptChangeSetAction_acceptingChangesJobName);
        final StandardAcceptDilemmaHandler dilemmaHandler = new StandardAcceptDilemmaHandler(context);
        this.getOperationRunner().enqueue(Messages.AcceptChangeSetAction_acceptingChangesJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                AcceptChangeSetFromWildAction.acceptChanges(warnWorkspaceUpdate, dilemmaHandler, changeSets, monitor);
            }
        });
    }

    private List<ItemLocator<IChangeSet>> extractChangeSets(List<ChangeSetWrapper> list) {
        ArrayList result = NewCollection.arrayList();
        for (ChangeSetWrapper next : list) {
            result.add(new ItemLocator(next.getRepository(), (IAuditableHandle)next.getChangeSet()));
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean containsSourceChangeSet = false;
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ChangeSetWrapper && ((ChangeSetWrapper)((Object)o)).isSourceChangeSet()) {
                containsSourceChangeSet = true;
                break;
            }
            ++n2;
        }
        action.setEnabled(!containsSourceChangeSet);
    }
}

