/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SuspendedChangeSetsQuery
extends RepositoryQuery<ContributorPlaceChangeSetWrapper> {
    private IComponent component;
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            for (Object object : events) {
                PropertyChangeEvent event;
                if (!(object instanceof PropertyChangeEvent) || !(event = (PropertyChangeEvent)object).getProperty().equals("suspended")) continue;
                HashSet<IChangeSet> added = new HashSet<IChangeSet>();
                Collection newValues = (Collection)event.getNewValue();
                for (Object obj : newValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    added.add(changeSet);
                }
                HashSet<IChangeSet> removed = new HashSet<IChangeSet>();
                Collection oldValues = (Collection)event.getOldValue();
                for (Object obj : oldValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    removed.add(changeSet);
                }
                Iterator iterator = removed.iterator();
                while (iterator.hasNext()) {
                    IChangeSet changeSet = (IChangeSet)iterator.next();
                    boolean wasRemoved = added.remove(changeSet);
                    if (!wasRemoved) continue;
                    iterator.remove();
                }
                boolean needsUpdate = false;
                for (IChangeSet changeSet : added) {
                    if (!SuspendedChangeSetsQuery.this.component.sameItemId((IItemHandle)changeSet.getComponent())) continue;
                    needsUpdate = true;
                }
                for (IChangeSet changeSet : removed) {
                    if (!SuspendedChangeSetsQuery.this.component.sameItemId((IItemHandle)changeSet.getComponent())) continue;
                    needsUpdate = true;
                }
                if (!needsUpdate) continue;
                SuspendedChangeSetsQuery.this.update();
            }
        }
    };

    public SuspendedChangeSetsQuery(ITeamRepository repository, IComponent component, IOperationRunner operationRunner) {
        super(repository, operationRunner);
        this.component = component;
    }

    protected void attachListeners() {
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"suspended", this.listener);
    }

    protected void detachListeners() {
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"suspended", this.listener);
    }

    protected List<ContributorPlaceChangeSetWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        List suspendedChangeSets = manager.suspendedChangeSets((IComponentHandle)this.component);
        IFetchResult fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(suspendedChangeSets, 0, (IProgressMonitor)progress.newChild(100));
        List retrievedItems = fetchResult.getRetrievedItems();
        ArrayList<ContributorPlaceChangeSetWrapper> result = new ArrayList<ContributorPlaceChangeSetWrapper>(retrievedItems.size());
        for (Object object : retrievedItems) {
            if (!(object instanceof IChangeSet)) continue;
            ContributorPlaceChangeSetWrapper wrapper = new ContributorPlaceChangeSetWrapper(this.getRepository(), (IChangeSet)object, true);
            wrapper.setHideComponent(true);
            result.add(wrapper);
        }
        return result;
    }

    public String getName() {
        return Messages.ComponentsWithSuspendedChangeSetsQuery_queryName;
    }
}

