/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ComponentsWithSuspendedChangeSetsQuery
extends RepositoryQuery<ComponentWrapper> {
    boolean workspaceManagerNeedsRefresh = false;
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            for (Object object : events) {
                PropertyChangeEvent event;
                if (!(object instanceof PropertyChangeEvent) || !(event = (PropertyChangeEvent)object).getProperty().equals("suspended")) continue;
                HashSet<UUID> added = new HashSet<UUID>();
                Collection newValues = (Collection)event.getNewValue();
                for (Object obj : newValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    added.add(changeSet.getComponent().getItemId());
                }
                HashSet<UUID> removed = new HashSet<UUID>();
                Collection oldValues = (Collection)event.getOldValue();
                for (Object obj : oldValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    removed.add(changeSet.getComponent().getItemId());
                }
                Iterator iterator = removed.iterator();
                while (iterator.hasNext()) {
                    UUID uuid = (UUID)iterator.next();
                    boolean wasRemoved = added.remove(uuid);
                    if (!wasRemoved) continue;
                    iterator.remove();
                }
                if (added.isEmpty() && removed.isEmpty()) continue;
                ComponentsWithSuspendedChangeSetsQuery.this.update();
            }
        }
    };

    public void refresh() {
        this.workspaceManagerNeedsRefresh = true;
        super.refresh();
    }

    public ComponentsWithSuspendedChangeSetsQuery(ITeamRepository repository, IOperationRunner operationRunner) {
        super(repository, operationRunner);
    }

    protected void attachListeners() {
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"suspended", this.listener);
    }

    protected void detachListeners() {
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"suspended", this.listener);
    }

    protected List<ComponentWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        if (this.workspaceManagerNeedsRefresh) {
            manager.refresh((IProgressMonitor)progress.newChild(25));
            this.workspaceManagerNeedsRefresh = false;
        }
        progress.setWorkRemaining(75);
        List suspendedChangeSets = manager.suspendedChangeSets();
        if (suspendedChangeSets.isEmpty()) {
            manager.refresh((IProgressMonitor)progress.newChild(25));
            suspendedChangeSets = manager.suspendedChangeSets();
        }
        progress.setWorkRemaining(50);
        IFetchResult fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(suspendedChangeSets, 0, (IProgressMonitor)progress.newChild(25));
        List retrievedItems = fetchResult.getRetrievedItems();
        HashMap<UUID, IComponentHandle> componentMap = new HashMap<UUID, IComponentHandle>();
        for (Object object : retrievedItems) {
            if (!(object instanceof IChangeSet)) continue;
            IChangeSet changeSet = (IChangeSet)object;
            componentMap.put(changeSet.getComponent().getItemId(), changeSet.getComponent());
        }
        fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(componentMap.values()), 0, (IProgressMonitor)progress.newChild(25));
        retrievedItems = fetchResult.getRetrievedItems();
        ArrayList<ComponentWrapper> result = new ArrayList<ComponentWrapper>(retrievedItems.size());
        for (Object object : retrievedItems) {
            if (!(object instanceof IComponent)) continue;
            ComponentWrapper componentWrapper = new ComponentWrapper(this.getRepository(), (IComponent)object);
            componentWrapper.setAllowSuspendedChangeSetChildren(true);
            result.add(componentWrapper);
        }
        return result;
    }

    public String getName() {
        return Messages.ComponentsWithSuspendedChangeSetsQuery_queryName;
    }
}

