/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetDateFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetPlannedForFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratedChangeSetLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.PlannedForLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetAuthorFunction;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetComponentFunction;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SimpleLocalSelectionTargetAdapter;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class ChangeSetSearchView
extends AbstractSearchPage<ChangeSetWrapper> {
    public ChangeSetSearchView(IControlSite site, AbstractSearchInput<ChangeSetWrapper> initialInput) {
        super(site, initialInput);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.changeset";
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode(String.valueOf(RepositoryUiPlugin.PLUGIN_ID) + '/' + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<ChangeSetWrapper> viewer) {
        IOperationRunner operationRunner = this.getControlSite().getOperationRunner();
        String commentColumnTitle = Messages.ChangeSetSearchView_commentColumn;
        DecoratedChangeSetLabelProvider commentLabelProvider = new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_workItemComment, Messages.DecoratedChangeSetLabelProvider_workItem, Messages.DecoratedChangeSetLabelProvider_comment, Messages.DecoratedChangeSetLabelProvider_none, false, (ISetWithListeners<ChangeSetWrapper>)viewer.getKnownElements(), operationRunner);
        LabelColumn commentColumn = new LabelColumn(viewer, commentColumnTitle, 400, (IViewerLabelProvider)commentLabelProvider);
        commentColumn.setHoverProvider((IConversion)new IConversion<ChangeSetWrapper, Object>(){

            public ChangeSetWrapper createAdapter(ChangeSetWrapper source) {
                return source;
            }
        });
        String creatorColumnTitle = Messages.ChangeSetSearchView_creatorColumn;
        ChangeSetAuthorFunction changeSetToCreatorFunction = new ChangeSetAuthorFunction((ISetWithListeners<? extends ChangeSetWrapper>)viewer.getKnownElements(), operationRunner);
        ConvertColumn creatorColumn = new ConvertColumn(viewer, creatorColumnTitle, 150, (IDynamicFunction)changeSetToCreatorFunction);
        creatorColumn.setCellComparator(ownerComparator);
        String dateModifiedColumnTitle = Messages.ChangeSetSearchView_dateCreatedColumn;
        ChangeSetDateFunction changeSetToDateFunction = new ChangeSetDateFunction(viewer.getKnownElements(), true);
        ConvertColumn dateModifiedColumn = new ConvertColumn(viewer, dateModifiedColumnTitle, 200, (IDynamicFunction)changeSetToDateFunction, true);
        dateModifiedColumn.setShowItemInContextMenu(false);
        dateModifiedColumn.setCellComparator(dateComparator);
        String componentColumnTitle = Messages.ChangeSetSearchView_componentColumn;
        ChangeSetComponentFunction changeSetToComponentFunction = new ChangeSetComponentFunction((ISetWithListeners<ChangeSetWrapper>)viewer.getKnownElements(), operationRunner, Display.getCurrent(), true);
        ConvertColumn componentColumn = new ConvertColumn(viewer, componentColumnTitle, 150, (IDynamicFunction)changeSetToComponentFunction);
        componentColumn.setCellComparator(componentWrapperComparator);
        new ChangeSetPlannedForColumn(viewer, Messages.HistoryView_plannedForColumn, 150, operationRunner);
        viewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SimpleLocalSelectionTargetAdapter(viewer));
    }

    @Override
    protected String getDefaultActionId() {
        return "com.ibm.team.filesystem.actions.history.compareHistory";
    }

    private class ChangeSetPlannedForColumn
    extends ConvertColumn<ChangeSetWrapper, String> {
        public ChangeSetPlannedForColumn(SimpleTableViewer<ChangeSetWrapper> viewer, String title, int size, IOperationRunner runner) {
            super(viewer, title, size, (IDynamicFunction)new ChangeSetPlannedForFunction((ISetWithListeners<ChangeSetWrapper>)viewer.getKnownElements(), runner, Display.getCurrent(), true));
            this.setCellLabelProvider((IViewerLabelProvider)new PlannedForLabelProvider());
        }
    }
}

