/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForChangeSetQueryEditor;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ComponentCombo;
import com.ibm.team.internal.filesystem.ui.picker.DatePickerControl;
import com.ibm.team.internal.filesystem.ui.picker.LocationCombo;
import com.ibm.team.internal.filesystem.ui.picker.OwnerSelectionField;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.picker.VersionablePicker;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class ChangeSetSearchCriteriaPart
extends AbstractSearchCriteriaPart<ChangeSetSearchCriteria> {
    private DatePickerControl afterDate;
    private DatePickerControl beforeDate;
    private OwnerSelectionField suspendedByCombo;
    private Text filename;
    private Button searchByTypeButton;
    private List<Button> typeButtons = new ArrayList<Button>();
    private CustomAttributeSectionForChangeSetQueryEditor customAttributeSection;
    private IChangeListener listener;

    public ChangeSetSearchCriteriaPart(IControlSite site, Input input) {
        super(site, input);
        ItemId suspendedByItemId;
        WidgetFactoryContext context = site.getContext();
        Composite parent = site.getParent();
        MnemonicGenerator mnemonics = context.getMnemonics();
        GridDataFactory dynamicData = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1);
        IEclipsePreferences prefs = ChangeSetSearchCriteriaPart.getConfigPrefs();
        WidgetToolkit toolkit = context.getToolkit();
        Group whereToSearch = new Group(parent, 0);
        whereToSearch.setText(Messages.ChangeSetSearchCriteriaPart_contextGroup);
        this.createRepoLabel((Composite)whereToSearch, context);
        RepositoryCombo repo = this.createRepositoryCombo((Composite)whereToSearch, prefs.node("repository"), context);
        input.setRepository(repo.getRepository());
        dynamicData.copy().span(2, 1).applyTo(repo.getControl());
        this.createComponentLabel((Composite)whereToSearch, context);
        ComponentCombo component = this.createComponentCombo((Composite)whereToSearch, context);
        dynamicData.copy().span(2, 1).applyTo(component.getControl());
        this.createLocationLabel((Composite)whereToSearch, context);
        LocationCombo locationCombo = this.createLocationCombo((Composite)whereToSearch, context, 7);
        dynamicData.copy().span(2, 1).applyTo(locationCombo.getControl());
        toolkit.createLabel((Composite)whereToSearch, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_suspendedComboLabel));
        this.suspendedByCombo = new OwnerSelectionField((Composite)whereToSearch, context, null, 5);
        this.suspendedByCombo.selectTheAnyNode();
        dynamicData.copy().span(2, 1).applyTo(this.suspendedByCombo.getControl());
        repo = input.getRepository();
        IContributorHandle suspendedByHandle = input.getSearchCriteria().getSuspendedBy();
        ItemId itemId = suspendedByItemId = suspendedByHandle == null ? null : ItemId.create((IItemHandle)suspendedByHandle);
        if (repo != null && suspendedByItemId != null && !suspendedByItemId.isNull()) {
            this.suspendedByCombo.setRepository((ITeamRepository)repo);
            this.suspendedByCombo.setSelection((ItemId<? extends IAuditable>)suspendedByItemId);
        } else {
            this.suspendedByCombo.selectTheAnyNode();
        }
        this.suspendedByCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        this.createMaxResultLabel((Composite)whereToSearch, context);
        Text maxResultText = this.createMaxResultText((Composite)whereToSearch, (Preferences)prefs, context);
        dynamicData.copy().span(2, 1).applyTo((Control)maxResultText);
        Dialog.applyDialogFont((Control)whereToSearch);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)whereToSearch);
        Group propertyGroup = new Group(parent, 0);
        propertyGroup.setText(Messages.ChangeSetSearchCriteriaPart_propertyGroup);
        this.createOwnerLabel((Composite)propertyGroup, context, Messages.ChangeSetSearchCriteriaPart_creatorComboLabel);
        OwnerSelectionField ownerCombo = this.createOwnerCombo((Composite)propertyGroup, context, 5);
        dynamicData.copy().span(2, 1).applyTo(ownerCombo.getControl());
        toolkit.createLabel((Composite)propertyGroup, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_afterDateLabel));
        this.afterDate = new DatePickerControl((Composite)propertyGroup, context, DateFormat.getDateInstance(2));
        Timestamp afterTimeStamp = input.getSearchCriteria().getModifiedAfter();
        if (afterTimeStamp != null) {
            this.afterDate.setSelection((ISelection)new StructuredSelection((Object)afterTimeStamp));
        }
        this.afterDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        dynamicData.copy().span(2, 1).applyTo(this.afterDate.getControl());
        toolkit.createLabel((Composite)propertyGroup, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_beforeDateLabel));
        this.beforeDate = new DatePickerControl((Composite)propertyGroup, context, DateFormat.getDateInstance(2));
        Timestamp beforeTimeStamp = input.getSearchCriteria().getModifiedBefore();
        if (beforeTimeStamp != null) {
            this.beforeDate.setSelection((ISelection)new StructuredSelection((Object)beforeTimeStamp));
        }
        this.beforeDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        dynamicData.copy().span(2, 1).applyTo(this.beforeDate.getControl());
        Dialog.applyDialogFont((Control)propertyGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)propertyGroup);
        Group changeGroup = new Group(parent, 0);
        changeGroup.setText(Messages.ChangeSetSearchCriteriaPart_changeGroup);
        this.createVersionableLabel((Composite)changeGroup, context);
        VersionablePicker versionable = this.createVersionablePicker((Composite)changeGroup, context);
        if (versionable.getTextControl() != null) {
            ((Text)versionable.getTextControl()).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                }
            });
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(170, -1).applyTo(versionable.getTextControl());
        toolkit.createLabel((Composite)changeGroup, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_filenameFieldLabel));
        this.filename = toolkit.createText((Composite)changeGroup, NullUtil.safeString((String)input.getSearchCriteria().getName()));
        this.filename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        GridDataFactory.generate((Control)this.filename, (int)2, (int)1);
        Composite searchByTypeWrapper = toolkit.createComposite((Composite)changeGroup);
        this.searchByTypeButton = toolkit.createButton(searchByTypeWrapper, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_searchByTypeCheckbox), 32);
        this.searchByTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ChangeSetSearchCriteriaPart.this.updateSearchByType();
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)this.searchByTypeButton);
        Dialog.applyDialogFont((Control)searchByTypeWrapper);
        GridLayoutFactory.fillDefaults().generateLayout(searchByTypeWrapper);
        Point preferredSize = this.searchByTypeButton.computeSize(-1, -1);
        Point previousRowSize = this.filename.computeSize(-1, -1);
        Point buttonSize = this.getVersionablePicker().getButtonControl().computeSize(-1, -1);
        preferredSize = Geometry.max((Point)Geometry.max((Point)buttonSize, (Point)previousRowSize), (Point)preferredSize);
        GridDataFactory.fillDefaults().hint(-1, preferredSize.y).align(4, 0x1000000).applyTo((Control)searchByTypeWrapper);
        Composite typesWrapper = toolkit.createComposite((Composite)changeGroup);
        Composite types = toolkit.createComposite(typesWrapper);
        this.createTypeButton(types, context, Messages.ChangeSetSearchCriteriaPart_addKindCheckbox, 1);
        this.createTypeButton(types, context, Messages.ChangeSetSearchCriteriaPart_deleteKindCheckbox, 16);
        this.createTypeButton(types, context, Messages.ChangeSetSearchCriteriaPart_modifyKindCheckbox, 2);
        this.createTypeButton(types, context, Messages.ChangeSetSearchCriteriaPart_renameKindCheckbox, 4);
        this.createTypeButton(types, context, Messages.ChangeSetSearchCriteriaPart_moveKindCheckbox, 8);
        this.setTypeFlags(input.getSearchCriteria().getChangeType());
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.fill = true;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.pack = true;
        types.setLayout((Layout)buttonLayout);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)types);
        GridLayoutFactory.fillDefaults().applyTo(typesWrapper);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)typesWrapper);
        Dialog.applyDialogFont((Control)changeGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)changeGroup);
        this.createCustomAttributeFilter(parent, toolkit, input);
        IContributorHandle authorHandle = input.getSearchCriteria().getAuthor();
        ItemId authorId = authorHandle == null ? null : new ItemId((IItemHandle)authorHandle);
        this.initialize(input.getRepository(), input.getSearchCriteria().getComponent(), input.getSearchCriteria().getContext(), (ItemId<IAuditable>)authorId, input.getSearchCriteria().getItem());
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.componentComboSelectionChanged();
        this.updateSearchByType();
    }

    private void createCustomAttributeFilter(Composite parent, WidgetToolkit toolkit, Input input) {
        this.customAttributeSection = new CustomAttributeSectionForChangeSetQueryEditor(this.getControlSite().getOperationRunner(), parent, toolkit, input);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.customAttributeSection.getControl());
        this.customAttributeSection.setInput(input);
        this.listener = new IChangeListener(){

            public void changed(Object source, Object property) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        };
        this.customAttributeSection.addListener(this.listener);
    }

    private void setTypeFlags(int changeType) {
        if (changeType == -1) {
            this.searchByTypeButton.setSelection(false);
            changeType = 16;
        } else {
            this.searchByTypeButton.setSelection(true);
        }
        Iterator<Button> iterator = this.typeButtons.iterator();
        while (iterator.hasNext()) {
            Button next;
            int nextData = (Integer)(next = iterator.next()).getData();
            next.setSelection((nextData & changeType) != 0);
        }
    }

    private int getSelectedTypeFlags() {
        if (!this.searchByTypeButton.getSelection()) {
            return -1;
        }
        int flags = 0;
        for (Button next : this.typeButtons) {
            int nextData = (Integer)next.getData();
            if (!next.getSelection()) continue;
            flags |= nextData;
        }
        return flags;
    }

    protected void updateSearchByType() {
        boolean enabled = this.searchByTypeButton.getSelection();
        for (Button typeButton : this.typeButtons) {
            typeButton.setEnabled(enabled);
        }
    }

    private Button createTypeButton(Composite row, WidgetFactoryContext context, String label, int flag) {
        Button result = context.getToolkit().createButton(row, context.getMnemonics().generate(label), 32);
        result.setData((Object)flag);
        this.typeButtons.add(result);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeSetSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        return result;
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        OwnerSelectionField creator;
        LocationCombo location;
        super.updateRepository(repository);
        this.suspendedByCombo.setRepository(repository);
        this.suspendedByCombo.selectTheAnyNode();
        ComponentCombo component = this.getComponentCombo();
        if (component != null) {
            component.selectTheAnyNode();
        }
        if ((location = this.getLocationCombo()) != null) {
            location.selectTheAnyNode();
        }
        if ((creator = this.getOwnerCombo()) != null) {
            creator.selectTheAnyNode();
        }
    }

    public static IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ChangeSetSearchCriteria.class.getName());
    }

    public static int getChangeSetSearchMaxResults() {
        String string = ChangeSetSearchCriteriaPart.getConfigPrefs().get("maxResults", "100");
        int maxResults = 100;
        try {
            maxResults = Integer.parseInt(string);
            if (maxResults < 1) {
                maxResults = 100;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxResults;
    }

    @Override
    public ChangeSetSearchCriteria getResult() {
        Object[] customAttributesArray;
        String nameText;
        SiloedItemId<IVersionable> item;
        IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
        ComponentWrapper componentWrapper = this.getComponentCombo().getComponent();
        if (componentWrapper != null) {
            criteria.setComponent((IComponentHandle)componentWrapper.getLocator().toHandle());
        }
        IContributorHandle owner = this.getOwner();
        IContributorHandle suspendedBy = this.getSuspendedBy();
        ContextWrapper location = this.getLocationCombo().getSelectedLocation();
        if (suspendedBy != null) {
            criteria.setSuspendedBy(suspendedBy);
        }
        if (location != null && suspendedBy == null) {
            criteria.setContext(location.getContextHandle());
        }
        if (owner != null) {
            criteria.setAuthor(owner);
        }
        if (!(item = this.getVersionablePicker().getSelection()).isNull()) {
            criteria.setItem(item.toHandle());
        }
        if ((nameText = this.filename.getText()).equals("")) {
            criteria.setName(null);
        } else {
            criteria.setName(nameText);
        }
        criteria.setChangeType(this.getSelectedTypeFlags());
        criteria.setModifiedBefore(this.getBeforeDate());
        criteria.setModifiedAfter(this.getAfterDate());
        int maxResults = ChangeSetSearchCriteriaPart.getChangeSetSearchMaxResults();
        String text = this.getMaxResultsText().getText();
        try {
            maxResults = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Object[] objectArray = customAttributesArray = this.customAttributeSection.getCustomAttributes();
        int n = customAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CustomAttributeEntry) {
                CustomAttributeEntry entry = (CustomAttributeEntry)object;
                criteria.getFilterByCustomAttributeOptional().add(entry.asCustomAttributeSearchFilter());
            }
            ++n2;
        }
        return new ChangeSetSearchCriteria(this.getRepository(), criteria, maxResults);
    }

    public OwnerSelectionField getSuspendedByCombo() {
        return this.suspendedByCombo;
    }

    private IContributorHandle getSuspendedBy() {
        return ChangeSetSearchCriteriaPart.getContributorFrom(this.suspendedByCombo);
    }

    public DatePickerControl getBeforeDateControl() {
        return this.beforeDate;
    }

    private Timestamp getBeforeDate() {
        Object sel = this.getSelection(this.beforeDate.getSelection());
        if (sel instanceof Timestamp) {
            return (Timestamp)sel;
        }
        return null;
    }

    public DatePickerControl getAfterDateControl() {
        return this.afterDate;
    }

    private Timestamp getAfterDate() {
        Object sel = this.getSelection(this.afterDate.getSelection());
        if (sel instanceof Timestamp) {
            return (Timestamp)sel;
        }
        return null;
    }

    public Text getFilenameText() {
        return this.filename;
    }

    private Object getSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ss.getFirstElement();
        }
        return null;
    }

    private IContributorHandle getOwner() {
        return ChangeSetSearchCriteriaPart.getContributorFrom(this.getOwnerCombo());
    }

    private static IContributorHandle getContributorFrom(OwnerSelectionField field) {
        ItemId<? extends IAuditable> selectedOwner = field.getSelection();
        if (selectedOwner == null) {
            return null;
        }
        IAuditableHandle result = (IAuditableHandle)selectedOwner.toHandle();
        if (result instanceof IContributorHandle) {
            return (IContributorHandle)result;
        }
        return null;
    }

    public Button getSearchByTypeButton() {
        return this.searchByTypeButton;
    }

    public List<Button> getTypeButtons() {
        return this.typeButtons;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.suspendedByCombo != null && !this.suspendedByCombo.getControl().isDisposed()) {
            this.suspendedByCombo.getControl().setEnabled(isEnabled);
        }
        if (this.filename != null && !this.filename.isDisposed()) {
            this.filename.setEnabled(isEnabled);
        }
        if (this.afterDate != null && !this.afterDate.getControl().isDisposed()) {
            this.afterDate.getControl().setEnabled(isEnabled);
        }
        if (this.beforeDate != null && !this.beforeDate.getControl().isDisposed()) {
            this.beforeDate.getControl().setEnabled(isEnabled);
        }
        if (this.searchByTypeButton != null && !this.searchByTypeButton.isDisposed()) {
            this.searchByTypeButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void componentComboSelectionChanged() {
        ComponentWrapper selectedComponent = this.getComponentCombo().getComponent();
        if (this.getLocationCombo() != null) {
            this.getLocationCombo().setComponent((ItemId<IComponent>)(selectedComponent != null ? selectedComponent.getLocator().getItemId() : ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE)));
        }
        if (this.customAttributeSection != null) {
            if (selectedComponent != null) {
                this.customAttributeSection.getSearchCriteria().component = selectedComponent.getLocator().getItemId();
            } else {
                this.customAttributeSection.getSearchCriteria().component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
            }
            this.customAttributeSection.setSearchCriteria(this.customAttributeSection.getSearchCriteria());
        }
        this.updateComponentValidation();
        this.notifySearchCriteriaUpdated();
    }

    @Override
    public void locationComboSelectionChanged() {
        super.locationComboSelectionChanged();
        ContextWrapper locationComboSelection = this.getLocationCombo().getSelectedLocation();
        IWorkspaceHandle wsStream = null;
        IBaselineHandle baseline = null;
        if (locationComboSelection != null) {
            IContextHandle contextHandle = locationComboSelection.getContextHandle();
            if (contextHandle instanceof IWorkspaceHandle) {
                wsStream = (IWorkspaceHandle)contextHandle;
            } else if (contextHandle instanceof IBaselineHandle) {
                baseline = (IBaselineHandle)contextHandle;
            }
        }
        if (this.customAttributeSection != null) {
            if (wsStream != null) {
                this.customAttributeSection.getSearchCriteria().wsStream = wsStream;
                this.customAttributeSection.setSearchCriteria(this.customAttributeSection.getSearchCriteria());
            } else if (baseline != null) {
                this.customAttributeSection.getSearchCriteria().baseline = baseline;
                this.customAttributeSection.setSearchCriteria(this.customAttributeSection.getSearchCriteria());
            } else {
                this.customAttributeSection.getSearchCriteria().wsStream = null;
                this.customAttributeSection.getSearchCriteria().baseline = null;
            }
        }
    }

    public static class Input {
        private ITeamRepository repo = null;
        private IChangeSetSearchCriteria searchCriteria = IChangeSetSearchCriteria.FACTORY.newInstance();
        private boolean changePropertiesEnabled;
        private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
        private ItemId<IComponent> component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        private IWorkspaceHandle wsStream = null;
        private IBaselineHandle baseline = null;

        public Input setChangePropertiesEnabled(boolean enabled) {
            this.changePropertiesEnabled = enabled;
            return this;
        }

        public Input setRepository(ITeamRepository repo) {
            this.repo = repo;
            return this;
        }

        public Input setSearchCriteria(IChangeSetSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public ITeamRepository getRepository() {
            return this.repo;
        }

        public IChangeSetSearchCriteria getSearchCriteria() {
            return this.searchCriteria;
        }

        public boolean changePropertiesEnabled() {
            return this.changePropertiesEnabled;
        }

        public IComponentHandle getComponentHandle() {
            if (this.component != null && !this.component.isNull()) {
                return (IComponentHandle)this.component.toHandle();
            }
            return null;
        }

        public IWorkspaceHandle getWsStreamHandle() {
            return this.wsStream;
        }

        public IBaselineHandle getBaselineHandle() {
            return this.baseline;
        }

        public void setCustomAttribute(String name, String newValue) {
            CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(name, newValue);
            this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
        }

        public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
            for (CustomAttributeEntry customAttributeEntry : toRemove) {
                this.customAttributes.remove(customAttributeEntry.getName());
            }
        }

        public void addCustomAttribute(CustomAttributeEntry entry) {
            CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(entry.getName(), entry.getValue());
            this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
        }

        public Object[] getCustomAttributesArray() {
            return this.customAttributes.values().toArray(new CustomAttributeEntry[this.customAttributes.size()]);
        }

        public Map<String, CustomAttributeEntry> getCustomAttributes() {
            return this.customAttributes;
        }
    }
}

