/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ChangeSetSearchCriteria
extends AbstractSearchInput {
    private ITeamRepository repo;
    private IChangeSetSearchCriteria criteria;
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();

    public ChangeSetSearchCriteria(ITeamRepository repo, IChangeSetSearchCriteria criteria, int maxResults) {
        this.repo = repo;
        this.criteria = criteria;
        this.setMaxResults(maxResults);
    }

    public ISetWithListeners getQuery(IOperationRunner runner, boolean lazyUpdates) {
        ChangeSetQuery query = new ChangeSetQuery(this.repo, this.criteria, this.getMaxResults(), runner);
        query.setAutoUpdate(!lazyUpdates);
        return query;
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle suspendedBy;
        IComponentHandle component;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        String searchName = Messages.ChangeSetSearchCriteriaPart_changeSetsNoun;
        IContributorHandle author = this.criteria.getAuthor();
        if (author != null) {
            IContributor contributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)this.repo, (ItemId)new ItemId((IItemHandle)author), (IProgressMonitor)progress.newChild(1));
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_createdByPhrase, (Object)searchName, (Object)contributor.getName());
        }
        if ((component = this.criteria.getComponent()) != null) {
            IComponent cmp = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)this.repo, (ItemId)new ItemId((IItemHandle)component), (IProgressMonitor)progress.newChild(1));
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_inComponentPhrase, (Object)searchName, (Object)cmp.getName());
        }
        searchName = NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)searchName, (Object)RepositoryUtils.getLabel(this.repo));
        IContextHandle context = this.criteria.getContext();
        if (context != null) {
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_inLocationPhrase, (Object)searchName, (Object)ChangeSetSearchCriteria.getDescription(this.repo, context, progress.newChild(1)));
        }
        if ((suspendedBy = this.criteria.getSuspendedBy()) != null) {
            IContributor contributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)this.repo, (ItemId)new ItemId((IItemHandle)suspendedBy), (IProgressMonitor)progress.newChild(1));
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_suspendedByPhrase, (Object)searchName, (Object)contributor.getName());
        }
        DateFormat format = DateFormat.getDateInstance();
        Timestamp modifiedAfter = this.criteria.getModifiedAfter();
        Timestamp modifiedBefore = this.criteria.getModifiedBefore();
        if (modifiedBefore != null && modifiedAfter != null) {
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_createdBetweenPhrase, (Object[])new String[]{searchName, format.format(modifiedAfter), format.format(modifiedBefore)});
        } else if (modifiedBefore != null) {
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_createdBeforePhrase, (Object)searchName, (Object)format.format(modifiedBefore));
        } else if (modifiedAfter != null) {
            searchName = NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_createdAfterPhrase, (Object)searchName, (Object)format.format(modifiedAfter));
        }
        return searchName;
    }

    public static String getDescription(ITeamRepository repo, IContextHandle context, SubMonitor progress) throws TeamRepositoryException {
        IItem cmp = RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)new ItemId((IItemHandle)context), (IProgressMonitor)progress);
        if (cmp instanceof IWorkspace) {
            IWorkspace workspace = (IWorkspace)cmp;
            if (workspace.isStream()) {
                return NLS.bind((String)Messages.ChangeSetSearchCriteria_decorateStreamName, (Object)workspace.getName());
            }
            return NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_decoratedWorkspaceName, (Object)workspace.getName());
        }
        if (cmp instanceof IBaseline) {
            IBaseline workspace = (IBaseline)cmp;
            return NLS.bind((String)Messages.ChangeSetSearchCriteriaPart_decoratedBaselineName, (Object)workspace.getName());
        }
        return Messages.ChangeSetSearchCriteriaPart_unknownContext;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repo;
    }

    public IChangeSetSearchCriteria getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria criteria) {
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput criteria) {
        return false;
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(name, newValue);
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public static IItemSearchCriteria getEquivalentSearchCriteria(ChangeSetSearchCriteria uiSearchCriteria) {
        return uiSearchCriteria.getCriteria();
    }
}

