/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.rcp.core.internal.FilteredFetcher;
import com.ibm.team.filesystem.rcp.core.internal.ItemChangeEvent;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChangeSetQuery
extends RepositoryQuery<ChangeSetWrapper> {
    private IChangeSetSearchCriteria searchCriteria;
    private int maxResults = 100;
    private boolean autoRefresh = true;
    private long counter = 0L;
    private FilteredFetcher fetcher;
    private IChangeListener<FilteredFetcher, List<ItemChangeEvent>> listener = new IChangeListener<FilteredFetcher, List<ItemChangeEvent>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(FilteredFetcher source, List<ItemChangeEvent> events) {
            long timestamp;
            ChangeSetQuery changeSetQuery = ChangeSetQuery.this;
            synchronized (changeSetQuery) {
                timestamp = ChangeSetQuery.this.counter;
            }
            final HashSet possibleRemovals = NewCollection.hashSet();
            final HashSet possibleAdditions = NewCollection.hashSet();
            final HashSet unknownChanges = NewCollection.hashSet();
            for (ItemChangeEvent event : events) {
                IChangeSet toAdd;
                boolean beforeWasIncluded = ChangeSetQuery.this.mayPassFilter(event.getBeforeState());
                boolean afterWasIncluded = ChangeSetQuery.this.mayPassFilter(event.getAfterState());
                if (beforeWasIncluded && !afterWasIncluded) {
                    IChangeSet toRemove = (IChangeSet)event.getSharedItem();
                    possibleRemovals.add(toRemove);
                    possibleAdditions.remove(toRemove);
                    unknownChanges.remove(toRemove);
                }
                if (afterWasIncluded && !beforeWasIncluded) {
                    toAdd = (IChangeSet)event.getSharedItem();
                    possibleAdditions.add(toAdd);
                    possibleRemovals.remove(toAdd);
                    unknownChanges.remove(toAdd);
                }
                if (!beforeWasIncluded || !afterWasIncluded) continue;
                toAdd = (IChangeSet)event.getSharedItem();
                unknownChanges.add(toAdd);
                possibleRemovals.remove(toAdd);
                possibleAdditions.remove(toAdd);
            }
            if (possibleAdditions.isEmpty() && possibleRemovals.isEmpty() && unknownChanges.isEmpty()) {
                return;
            }
            SWTUtil.greedyExec((Realm)ChangeSetQuery.this.getRealm(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ChangeSetQuery changeSetQuery = ChangeSetQuery.this;
                    synchronized (changeSetQuery) {
                        if (ChangeSetQuery.this.counter != timestamp) {
                            return;
                        }
                    }
                    if (!unknownChanges.isEmpty()) {
                        ChangeSetQuery.this.update();
                        return;
                    }
                    Collection currentValue = ChangeSetQuery.this.computeElements();
                    if (!possibleAdditions.isEmpty() && currentValue.size() < ChangeSetQuery.this.maxResults) {
                        ChangeSetQuery.this.update();
                        return;
                    }
                    if (!possibleRemovals.isEmpty()) {
                        HashMap currentChangeSets = NewCollection.hashMap();
                        for (ChangeSetWrapper next : currentValue) {
                            currentChangeSets.put(ItemId.forItem((IItem)next.getChangeSet()), next);
                        }
                        ArrayList realRemovals = NewCollection.arrayList();
                        for (IChangeSet removal : possibleRemovals) {
                            ItemId nextId = ItemId.forItem((IItem)removal);
                            ChangeSetWrapper wrapper = (ChangeSetWrapper)((Object)currentChangeSets.get(nextId));
                            if (wrapper == null) continue;
                            realRemovals.add(wrapper);
                        }
                        if (realRemovals.isEmpty()) {
                            return;
                        }
                        if (currentValue.size() >= ChangeSetQuery.this.maxResults) {
                            ChangeSetQuery.this.update();
                            return;
                        }
                        ChangeSetQuery.this.removeElements(realRemovals);
                    }
                }
            });
        }
    };

    public ChangeSetQuery(ITeamRepository repository, IChangeSetSearchCriteria searchCriteria, int maxResults, IOperationRunner operationRunner) {
        super(repository, operationRunner);
        this.fetcher = new FilteredFetcher(repository);
        this.searchCriteria = searchCriteria;
        this.maxResults = maxResults;
    }

    private boolean mayPassFilter(IItem item) {
        if (item == null) {
            return false;
        }
        if (!(item instanceof IChangeSet)) {
            return false;
        }
        IChangeSet changeSet = (IChangeSet)item;
        return this.searchCriteria.matches(changeSet);
    }

    public void enableAutoRefresh(boolean enabled) {
        if (enabled == this.autoRefresh) {
            return;
        }
        this.autoRefresh = enabled;
        if (this.isAllocated()) {
            if (this.autoRefresh) {
                this.attachListeners();
                this.update();
            } else {
                this.detachListeners();
            }
        }
    }

    public void setMaxResults(int newMaxResults) {
        int oldMaxResults = this.maxResults;
        this.maxResults = newMaxResults;
        int oldSize = this.computeElements().size();
        if (oldSize >= oldMaxResults || oldSize > newMaxResults) {
            this.update();
        }
    }

    protected void attachListeners() {
        this.fetcher.addListener(IChangeSet.ITEM_TYPE, this.listener);
    }

    protected void detachListeners() {
        this.fetcher.removeListener(IChangeSet.ITEM_TYPE, this.listener);
    }

    protected List<ChangeSetWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        int toFetch = this.maxResults;
        int batches = toFetch / 512 + 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * batches));
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        IChangeSetSearchCriteria pagingCriteria = (IChangeSetSearchCriteria)EcoreUtil.copy((EObject)((EObject)this.searchCriteria));
        ArrayList<IChangeSet> result = new ArrayList<IChangeSet>(toFetch);
        List findResult = mgr.findChangeSets(pagingCriteria, toFetch, (IProgressMonitor)progress.newChild(1));
        List<IChangeSet> changeSets = this.fetchCurrentsInOrder(findResult, progress.newChild(1));
        result.addAll(changeSets);
        while (toFetch > 512 && findResult.size() == 512) {
            toFetch -= findResult.size();
            IChangeSet lastChangeSet = changeSets.get(changeSets.size() - 1);
            if (pagingCriteria.isOldestFirst()) {
                pagingCriteria.setModifiedAfter(new Timestamp(lastChangeSet.getLastChangeDate().getTime()));
            } else {
                pagingCriteria.setModifiedBefore(new Timestamp(lastChangeSet.getLastChangeDate().getTime()));
            }
            findResult = mgr.findChangeSets(pagingCriteria, toFetch, (IProgressMonitor)progress.newChild(1));
            changeSets = this.fetchCurrentsInOrder(findResult, progress.newChild(1));
            result.addAll(changeSets);
        }
        if (pagingCriteria.getContext() != null) {
            return ChangeSetInContextWrapper.getWrappersWithContext(this.getRepository(), result, pagingCriteria.getContext());
        }
        return ChangeSetWrapper.getWrappers(this.getRepository(), result);
    }

    private List<IChangeSet> fetchCurrentsInOrder(List<IChangeSetHandle> handles, SubMonitor progress) throws TeamRepositoryException {
        List changeSetIds = ItemLists.handlesToIds(handles);
        Map currents = this.fetcher.fetchCurrents((Collection)changeSetIds, false, (IProgressMonitor)progress);
        ArrayList<IChangeSet> results = new ArrayList<IChangeSet>(currents.size());
        for (ItemId id : changeSetIds) {
            results.add((IChangeSet)currents.get(id));
        }
        return results;
    }

    public String getName() {
        return Messages.ChangeSetQuery_queryName;
    }
}

