/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.changeset;

import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractComponentFunction<T>
extends SlowFunction<T, ComponentWrapper> {
    public AbstractComponentFunction(ISetWithListeners<T> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    protected Map<T, ComponentWrapper> doFetch(Collection<T> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        HashSet components = NewCollection.hashSet();
        for (T next : toFetch) {
            components.add(this.getComponent(next));
        }
        try {
            Map fetched = ItemFetcher.fetchCurrents((Collection)components, (boolean)false, (IProgressMonitor)reporter);
            HashMap wrappers = NewCollection.hashMap();
            HashMap result = NewCollection.hashMap();
            for (ItemLocator nextComponent : fetched.keySet()) {
                wrappers.put(nextComponent, new ComponentWrapper(nextComponent.getRepository(), (IComponent)fetched.get(nextComponent)));
            }
            for (Object next : toFetch) {
                ItemLocator<IComponent> cmp = this.getComponent(next);
                result.put(next, (ComponentWrapper)((Object)wrappers.get(cmp)));
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    protected abstract ItemLocator<IComponent> getComponent(T var1);

    protected String getOperationName() {
        return Messages.AbstractComponentFunction_0;
    }

    protected ComponentWrapper getDefaultValue() {
        return null;
    }
}

