/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.baseline;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IBooleanInputArg;
import com.ibm.team.repository.common.query.ast.IDateTimeInputArg;
import com.ibm.team.repository.common.query.ast.IEnumInputArg;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.INumericInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class QueryFactory {
    private IItemQuery query;
    private List<IPredicate> predicates = new ArrayList<IPredicate>();
    private List<Object> arguments = new ArrayList<Object>();
    private boolean invariant;

    private QueryFactory(IItemQuery query) {
        this.query = query;
    }

    public static QueryFactory create(IItemQueryModel qm) {
        return new QueryFactory((IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)qm));
    }

    public IItemQuery createQuery() {
        if (this.invariant) {
            return this.query;
        }
        this.invariant = true;
        QueryFactory.attachFilters(this.query, this.predicates);
        return this.query;
    }

    public IDateTimeInputArg newDateTimeArg(Date value) {
        this.checkState();
        IDateTimeInputArg result = this.query.newDateTimeArg();
        this.arguments.add(value);
        return result;
    }

    public INumericInputArg newBigDecimalArg(BigDecimal value) {
        this.checkState();
        INumericInputArg result = this.query.newBigDecimalArg();
        this.arguments.add(value);
        return result;
    }

    public IEnumInputArg newEnumArg(int value) {
        this.checkState();
        IEnumInputArg result = this.query.newEnumArg();
        this.arguments.add(value);
        return result;
    }

    public INumericInputArg newIntegerArg(int value) {
        this.checkState();
        INumericInputArg result = this.query.newIntegerArg();
        this.arguments.add(value);
        return result;
    }

    public INumericInputArg newLongArg(long value) {
        this.checkState();
        INumericInputArg result = this.query.newLongArg();
        this.arguments.add(value);
        return result;
    }

    public IBooleanInputArg newBooleanArg(boolean value) {
        this.checkState();
        IBooleanInputArg result = this.query.newBooleanArg();
        this.arguments.add(value);
        return result;
    }

    public IItemHandleInputArg newItemIdArg(ItemId value) {
        this.checkState();
        IItemHandleInputArg result = this.query.newItemHandleArg();
        this.arguments.add(value.toHandle());
        return result;
    }

    public IItemHandleInputArg newItemHandleArg(IItemHandle value) {
        this.checkState();
        IItemHandleInputArg result = this.query.newItemHandleArg();
        this.arguments.add(value);
        return result;
    }

    public IStringInputArg newStringArg(String value) {
        this.checkState();
        IStringInputArg result = this.query.newStringArg();
        this.arguments.add(value);
        return result;
    }

    public IUUIDInputArg newUUIDArg(UUID value) {
        this.checkState();
        IUUIDInputArg result = this.query.newUUIDArg();
        this.arguments.add(value);
        return result;
    }

    public void addPredicate(IPredicate toAdd) {
        this.checkState();
        this.predicates.add(toAdd);
    }

    private void checkState() {
        if (this.invariant) {
            throw new IllegalStateException("QueryFactory cannot be modified once it has been used");
        }
    }

    public void orderBy(IField field, boolean ascending) {
        this.checkState();
        if (ascending) {
            this.query.orderByAsc(field);
        } else {
            this.query.orderByDsc(field);
        }
    }

    public void orderByUsingLocale(IStringField field, boolean ascending) {
        this.checkState();
        if (ascending) {
            this.query.orderByAscUsingLocale(field);
        } else {
            this.query.orderByDscUsingLocale(field);
        }
    }

    public Object[] getParameters() {
        return this.arguments.toArray();
    }

    public static void attachFilters(IItemQuery query, List<IPredicate> predicates) {
        if (predicates.size() > 0) {
            IPredicate currentPredicate = predicates.get(0);
            boolean isFirst = true;
            for (IPredicate predicate : predicates) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                currentPredicate = currentPredicate._and(predicate);
            }
            query.filter(currentPredicate);
        }
    }
}

