/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.baseline;

import com.ibm.icu.text.Collator;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineContributorFunction;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;

public class BaselineSearchView
extends AbstractSearchPage<BaselineWrapper> {
    private IAction copyTextAction;
    private IPartSiteServices partServices;

    public BaselineSearchView(IControlSite site, AbstractSearchInput<BaselineWrapper> input) {
        super(site, input);
        this.partServices = (IPartSiteServices)Adapters.getAdapter((Object)site, IPartSiteServices.class);
    }

    @Override
    protected void addColumns(WidgetFactoryContext context, SimpleTableViewer<BaselineWrapper> viewer) {
        ISetWithListeners baselines = viewer.getKnownElements();
        IOperationRunner opRunner = this.getControlSite().getOperationRunner();
        String baselieNameColumnTitle = Messages.BaselineSearchView_baselineNameColumn;
        BaselineLabelProvider labelProvider = new BaselineLabelProvider("{4}", (ISetWithListeners<BaselineWrapper>)baselines, opRunner);
        labelProvider.setShouldShowIcon(true);
        LabelColumn nameColumn = new LabelColumn(viewer, baselieNameColumnTitle, 350, (IViewerLabelProvider)labelProvider);
        nameColumn.setHoverProvider((IConversion)new IConversion<BaselineWrapper, Object>(){

            public Object createAdapter(BaselineWrapper source) {
                return source;
            }
        });
        nameColumn.setComparator((Comparator)new BaselineComparator(baselieNameColumnTitle));
        String baselineIdColumnTitle = Messages.BaselineSearchView_baselineIdColumn;
        labelProvider = new BaselineLabelProvider("{3}", (ISetWithListeners<BaselineWrapper>)baselines, opRunner);
        labelProvider.setShouldShowIcon(false);
        LabelColumn idColumn = new LabelColumn(viewer, baselineIdColumnTitle, 75, (IViewerLabelProvider)labelProvider);
        idColumn.setComparator((Comparator)new BaselineComparator(baselineIdColumnTitle));
        String baselineDescriptionColumnTitle = Messages.BaselineSearchView_baselineDescriptionColumn;
        labelProvider = new BaselineLabelProvider("{5}", (ISetWithListeners<BaselineWrapper>)baselines, opRunner);
        labelProvider.setShouldShowIcon(false);
        LabelColumn descriptionColumn = new LabelColumn(viewer, baselineDescriptionColumnTitle, 350, (IViewerLabelProvider)labelProvider);
        descriptionColumn.setShowItemInContextMenu(false);
        descriptionColumn.setComparator((Comparator)new BaselineComparator(baselineDescriptionColumnTitle));
        String baselineContributorColumnTitle = Messages.BaselineSearchView_baslineCreatedByColumn;
        BaselineContributorFunction baselineContributorFunction = new BaselineContributorFunction(baselines, opRunner);
        ConvertColumn baselineContributor = new ConvertColumn(viewer, baselineContributorColumnTitle, 200, (IDynamicFunction)baselineContributorFunction);
        baselineContributor.setCellComparator(ownerComparator);
        String createdDateColumnTitle = Messages.BaselineSearchView_baselineDateCreatedColumn;
        IConversion<BaselineWrapper, Date> baselineCreatedDatetoDate = new IConversion<BaselineWrapper, Date>(){

            public Date createAdapter(BaselineWrapper baselineWrapper) {
                return baselineWrapper.getBaseline().getCreationDate();
            }
        };
        ConvertColumn createdDateColumn = new ConvertColumn(viewer, createdDateColumnTitle, 150, (IConversion)baselineCreatedDatetoDate);
        createdDateColumn.setShowItemInContextMenu(false);
        createdDateColumn.setCellComparator(dateComparator);
        String modifiedDateColumnTitle = Messages.BaselineSearchView_baselineDateModified;
        IConversion<BaselineWrapper, Date> baselineModifiedDatetoDate = new IConversion<BaselineWrapper, Date>(){

            public Date createAdapter(BaselineWrapper baselineWrapper) {
                return baselineWrapper.getBaseline().modified();
            }
        };
        ConvertColumn modifiedDateColumn = new ConvertColumn(viewer, modifiedDateColumnTitle, 150, (IConversion)baselineModifiedDatetoDate);
        modifiedDateColumn.setShowItemInContextMenu(false);
        modifiedDateColumn.setCellComparator(dateComparator);
        this.copyTextAction = new BaselineResultCustomAction(Messages.HistoryView_copyTextAction, viewer, this.partServices);
        viewer.getContextMenu().appendToGroup("jazz.refactoring.group", this.copyTextAction);
    }

    @Override
    protected String getMenuID() {
        return "com.ibm.team.filesystem.views.search.baseline";
    }

    private class BaselineComparator
    implements Comparator<BaselineWrapper> {
        private Collator fCollator = CollatorCache.getInstance();
        private String propertyName;

        private BaselineComparator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public int compare(BaselineWrapper o1, BaselineWrapper o2) {
            int result = 0;
            if (this.propertyName.equalsIgnoreCase(Messages.BaselineSearchView_baselineIdColumn)) {
                Integer baselineId1 = o1.getBaseline().getId();
                Integer baselineId2 = o2.getBaseline().getId();
                result = baselineId1.compareTo(baselineId2);
            } else if (this.propertyName.equalsIgnoreCase(Messages.BaselineSearchView_baselineNameColumn)) {
                result = this.fCollator.compare(o1.getBaseline().getName(), o2.getBaseline().getName());
            } else if (this.propertyName.equalsIgnoreCase(Messages.BaselineSearchView_baselineDescriptionColumn)) {
                result = this.fCollator.compare(o1.getBaseline().getComment(), o2.getBaseline().getComment());
            }
            return result;
        }
    }

    private class BaselineResultCustomAction
    extends Action {
        private String actionLabel;
        private SimpleTableViewer<BaselineWrapper> viewer;
        private UIContext uiCtx;

        public BaselineResultCustomAction(String actionLabel, SimpleTableViewer<BaselineWrapper> viewer, IPartSiteServices partServices) {
            super(actionLabel);
            this.actionLabel = actionLabel;
            this.viewer = viewer;
            this.uiCtx = partServices != null ? UIContext.createPartContext((IWorkbenchPart)partServices.getPart()) : UIContext.createShellContext((Shell)BaselineSearchView.this.getControlSite().getShell());
        }

        public void run() {
            if (Messages.HistoryView_copyWebUrlAction.equalsIgnoreCase(this.actionLabel)) {
                List<BaselineWrapper> baselineWrappers = AdapterUtil.adaptList(this.viewer.getSelection().toList(), BaselineWrapper.class);
                if (baselineWrappers != null && baselineWrappers.size() > 0) {
                    this.copyUrlToClipboard(baselineWrappers);
                }
            } else if (Messages.HistoryView_copyTextAction.equalsIgnoreCase(this.actionLabel)) {
                this.copyTextToClipboard(this.viewer);
            }
        }

        private void copyUrlToClipboard(List<BaselineWrapper> baselineWrappers) {
            StringBuilder url = new StringBuilder();
            String sep = System.getProperty("line.separator");
            for (BaselineWrapper baselineWrapper : baselineWrappers) {
                String repoURI;
                if (url.length() > 0) {
                    url.append(sep);
                }
                if ((repoURI = baselineWrapper.getRepository().publicUriRoot()) == null) {
                    repoURI = baselineWrapper.getRepository().getRepositoryURI();
                }
                Location loc = Location.itemLocation((IItemHandle)baselineWrapper.getBaseline(), (String)repoURI);
                url.append(loc.toAbsoluteUri().toString());
            }
            this.copyStringToClipboard(url.toString());
        }

        private void copyTextToClipboard(SimpleTableViewer<BaselineWrapper> viewer) {
            Table table = viewer.getTable();
            int columnCount = table.getColumnCount();
            TableItem[] items = table.getSelection();
            int itemCount = items.length;
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            int columnVisibleCount = 0;
            int i = 0;
            while (i < columnCount) {
                if (table.getColumn(i).getWidth() > 0) {
                    ++columnVisibleCount;
                }
                ++i;
            }
            boolean columnTitleEntered = false;
            int i2 = 0;
            while (i2 < columnCount) {
                String columnText = table.getColumn(i2).getText();
                if (table.getColumn(i2).getWidth() > 0) {
                    this.append(sb, columnText);
                    columnTitleEntered = true;
                }
                if (columnTitleEntered && i2 < columnCount - 1 && i2 < columnVisibleCount && table.getColumn(i2).getWidth() > 0 && columnVisibleCount != 2) {
                    sb.append(", ");
                }
                ++i2;
            }
            if (sb.length() > 1) {
                sb.insert(1, '<');
                sb.insert(sb.length() - 1, '>');
                sb.append(lineSeparator);
            }
            i2 = 0;
            while (i2 < itemCount) {
                boolean itemColumnEntered = false;
                int j = 0;
                while (j < columnCount) {
                    if (table.getColumn(j).getWidth() > 0) {
                        this.append(sb, items[i2].getText(j));
                        itemColumnEntered = true;
                    }
                    if (itemColumnEntered && j < columnCount - 1 && j < columnVisibleCount && table.getColumn(j).getWidth() > 0 && columnVisibleCount != 2) {
                        sb.append(", ");
                    }
                    ++j;
                }
                if (i2 < itemCount - 1) {
                    sb.append(lineSeparator);
                }
                ++i2;
            }
            if (sb.length() > 0) {
                this.copyStringToClipboard(sb.toString());
            }
        }

        private void append(StringBuffer sb, String string) {
            int QUOTE = 34;
            sb.append('\"');
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == '\"') {
                    sb.append('\"');
                }
                sb.append(c);
                ++n2;
            }
            sb.append('\"');
        }

        private void copyStringToClipboard(String toCopy) {
            Clipboard clipBoard = new Clipboard(this.uiCtx.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipBoard.setContents(new Object[]{toCopy}, new Transfer[]{textTransfer});
            clipBoard.dispose();
        }
    }
}

