/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.baseline;

import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class BaselineSearchQuery
extends RepositoryQuery<BaselineWrapper> {
    private static final int DEFAULT_MAX_TO_SHOW = 1024;
    private int maxToShow = 1024;
    private BaselineSearchCriteria uiCriteria;
    private boolean allowFolderActions = false;
    private boolean calculateBaselineHierarchy = false;

    private void initMaxToShow() {
        String userDefinedMaxToShow = null;
        if (this.uiCriteria.isMaxResultsSet()) {
            this.maxToShow = this.uiCriteria.getMaxResults();
        } else {
            userDefinedMaxToShow = System.getProperty("SCM_MAX_BASELINE_QUERY_RESULTS");
            if (userDefinedMaxToShow != null) {
                try {
                    this.maxToShow = Integer.parseInt(userDefinedMaxToShow);
                    if (this.maxToShow <= 0) {
                        this.maxToShow = 1024;
                        StatusUtil.log((Object)((Object)this), (String)NLS.bind((String)Messages.BaselineSearchQuery_badProperty, (Object)userDefinedMaxToShow, (Object)"SCM_MAX_BASELINE_QUERY_RESULTS"));
                    }
                }
                catch (NumberFormatException e) {
                    StatusUtil.log((Object)((Object)this), (String)NLS.bind((String)Messages.BaselineSearchQuery_badProperty, (Object)userDefinedMaxToShow, (Object)"SCM_MAX_BASELINE_QUERY_RESULTS"));
                }
            }
        }
    }

    BaselineSearchQuery(IOperationRunner operationRunner, BaselineSearchCriteria searchCriteria) {
        super(searchCriteria.getRepo(), operationRunner);
        this.uiCriteria = searchCriteria;
        this.initMaxToShow();
    }

    public void setAllowFolderActions(boolean allowFolderActions) {
        this.allowFolderActions = allowFolderActions;
    }

    public void setCalculateBaselineHierarchy(boolean calculateBaselineHierarchy) {
        this.calculateBaselineHierarchy = calculateBaselineHierarchy;
    }

    protected List<BaselineWrapper> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineSearchCriteria criteria = BaselineSearchCriteria.asSearchCriteriaDTO(this.uiCriteria);
        List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).findBaselines(criteria, this.maxToShow, (IProgressMonitor)progress.newChild(75));
        List baselineIds = ItemLists.handlesToIds((Collection)handles);
        List<BaselineWrapper> nextResult = this.createWrappers(this.getRepository(), baselineIds, (IProgressMonitor)progress.newChild(20));
        return nextResult;
    }

    private List<BaselineWrapper> createWrappers(ITeamRepository repo, List<ItemId<IBaseline>> baselineIds, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + (this.calculateBaselineHierarchy ? 100 : 0)));
        ArrayList<BaselineWrapper> nextResult = new ArrayList<BaselineWrapper>();
        Map fetchedBaselines = RepoFetcher.fetchCurrents((ITeamRepository)repo, baselineIds, (IProgressMonitor)progress.newChild(70));
        HashMap<UUID, IBaselineConnection> baselineConnections = new HashMap<UUID, IBaselineConnection>(fetchedBaselines.size());
        if (this.calculateBaselineHierarchy) {
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            List bcs = wm.getBaselineConnections(new ArrayList(fetchedBaselines.values()), (IProgressMonitor)progress.newChild(50));
            for (IBaselineConnection connection : bcs) {
                baselineConnections.put(connection.getBaseline().getItemId(), connection);
            }
        }
        HashSet<ItemId> componentIds = new HashSet<ItemId>();
        for (IBaseline next : fetchedBaselines.values()) {
            componentIds.add(new ItemId((IItemHandle)next.getComponent()));
        }
        Map fetchedComponents = RepoFetcher.fetchCurrents((ITeamRepository)repo, componentIds, (boolean)false, (IProgressMonitor)progress.newChild(30));
        SubMonitor loopProgress = this.calculateBaselineHierarchy ? progress.newChild(50).setWorkRemaining(baselineIds.size() * 2) : progress;
        for (ItemId<IBaseline> next : baselineIds) {
            ItemId componentId;
            IComponent fetchedComponent;
            IBaseline fetchedBaseline = (IBaseline)fetchedBaselines.get(next);
            if (fetchedBaseline == null || (fetchedComponent = (IComponent)fetchedComponents.get(componentId = new ItemId((IItemHandle)fetchedBaseline.getComponent()))) == null) continue;
            IBaselineConnection bc = (IBaselineConnection)baselineConnections.get(fetchedBaseline.getItemId());
            BaselineWrapper wrapper = bc != null ? new BaselineWrapper(bc, fetchedComponent) : new BaselineWrapper(repo, fetchedBaseline, fetchedComponent);
            if (this.calculateBaselineHierarchy) {
                IBaselineConnection baselineConnection = wrapper.getBaselineConnection((IProgressMonitor)loopProgress.newChild(1));
                IBaselineHierarchyResult baselineHierarchy = baselineConnection.getBaselineHierarchy((IProgressMonitor)loopProgress.newChild(1));
                IBaselineHierarchyNode baselineHierarchyNode = baselineHierarchy.getRoot();
                wrapper.createHierarchyData(baselineHierarchyNode, null);
            }
            wrapper.setAllowFolderActions(this.allowFolderActions);
            nextResult.add(wrapper);
            progress.done();
        }
        return nextResult;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    public String getName() {
        return Messages.BaselineSearchQuery_0;
    }
}

