/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.baseline;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForBaselineQueryEditor;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ComponentCombo;
import com.ibm.team.internal.filesystem.ui.picker.DatePickerControl;
import com.ibm.team.internal.filesystem.ui.picker.OwnerSelectionField;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class BaselineSearchCriteriaPart
extends AbstractSearchCriteriaPart<BaselineSearchCriteria> {
    private WritableValue baselineSearchCriteriaValidation = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    public static final int DEFAULT_MAX_RESULTS = 100;
    private RepositoryCombo repo;
    private ComponentCombo component;
    private Text nameOrPatternText;
    private Button ignoreCaseButton;
    private OwnerSelectionField creator;
    private DatePickerControl createdAfterDate;
    private DatePickerControl createdBeforeDate;
    private CustomAttributeSectionForBaselineQueryEditor customAttributeSection;
    private IChangeListener listener;

    public BaselineSearchCriteriaPart(IControlSite site, BaselineSearchCriteria input) {
        this(site, input, true);
    }

    public BaselineSearchCriteriaPart(IControlSite site, BaselineSearchCriteria input, boolean showMaxResultsWidget) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        Composite parent = site.getParent();
        MnemonicGenerator mnemonics = context.getMnemonics();
        GridDataFactory dynamicData = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1);
        IEclipsePreferences prefs = this.getConfigPrefs();
        WidgetToolkit toolkit = context.getToolkit();
        Group contextGroup = new Group(parent, 0);
        contextGroup.setText(Messages.ChangeSetSearchCriteriaPart_contextGroup);
        this.createRepoLabel((Composite)contextGroup, context);
        this.repo = this.createRepositoryCombo((Composite)contextGroup, prefs.node("repository"), context);
        dynamicData.copy().span(2, 1).applyTo(this.repo.getControl());
        this.createComponentLabel((Composite)contextGroup, context);
        this.component = this.createComponentCombo((Composite)contextGroup, context, 2);
        dynamicData.copy().span(2, 1).applyTo(this.component.getControl());
        this.component.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        if (showMaxResultsWidget) {
            this.createMaxResultLabel((Composite)contextGroup, context);
            Text maxResultText = this.createMaxResultText((Composite)contextGroup, (Preferences)prefs, context);
            dynamicData.copy().span(2, 1).applyTo((Control)maxResultText);
        }
        toolkit.createLabel((Composite)contextGroup, mnemonics.generate(Messages.BaslineSearchCriteriaPart_nameOrPatternFieldLabel));
        this.nameOrPatternText = toolkit.createText((Composite)contextGroup, "");
        String inputNameOrPattern = input.getNameOrPattern();
        if (inputNameOrPattern != null) {
            this.nameOrPatternText.setText(inputNameOrPattern);
        }
        GridDataFactory.generate((Control)this.nameOrPatternText, (int)2, (int)1);
        this.nameOrPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        new Label((Composite)contextGroup, 0);
        this.ignoreCaseButton = toolkit.createButton((Composite)contextGroup, Messages.BaselineSearchCriteriaPart_IgnoreCaseButton, 32);
        this.ignoreCaseButton.setSelection(input.isIgnoreCase());
        this.ignoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        Dialog.applyDialogFont((Control)contextGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)contextGroup);
        Group propertyGroup = new Group(parent, 0);
        propertyGroup.setText(Messages.ChangeSetSearchCriteriaPart_propertyGroup);
        this.createOwnerLabel((Composite)propertyGroup, context, Messages.ChangeSetSearchCriteriaPart_creatorComboLabel);
        this.creator = this.createOwnerCombo((Composite)propertyGroup, context, 5);
        dynamicData.copy().span(2, 1).applyTo(this.creator.getControl());
        this.creator.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        toolkit.createLabel((Composite)propertyGroup, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_afterDateLabel));
        this.createdAfterDate = new DatePickerControl((Composite)propertyGroup, context, DateFormat.getDateInstance(2));
        Date createdAfterDateValue = input.getModifiedAfter();
        if (createdAfterDateValue != null) {
            this.createdAfterDate.setSelection((ISelection)new StructuredSelection((Object)createdAfterDateValue));
        }
        this.createdAfterDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        dynamicData.copy().span(2, 1).applyTo(this.createdAfterDate.getControl());
        toolkit.createLabel((Composite)propertyGroup, mnemonics.generate(Messages.ChangeSetSearchCriteriaPart_beforeDateLabel));
        this.createdBeforeDate = new DatePickerControl((Composite)propertyGroup, context, DateFormat.getDateInstance(2));
        Date createdBeforeDateValue = input.getModifiedBefore();
        if (createdBeforeDateValue != null) {
            this.createdBeforeDate.setSelection((ISelection)new StructuredSelection((Object)createdBeforeDateValue));
        }
        this.createdBeforeDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        });
        dynamicData.copy().span(2, 1).applyTo(this.createdBeforeDate.getControl());
        Dialog.applyDialogFont((Control)propertyGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout((Composite)propertyGroup);
        this.createCustomAttributeFilter(parent, toolkit, input);
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.initialize(input.getRepo(), input.getComponentHandle(), null, input.getCreatedBy(), null);
        this.getValidationStatus().addStatus((IObservableValue)this.baselineSearchCriteriaValidation);
        this.nameOrPatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaselineSearchCriteriaPart.this.validateSearchDialog(true);
            }
        });
        this.createdBeforeDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selChgEvt) {
                BaselineSearchCriteriaPart.this.validateSearchDialog(true);
            }
        });
        this.createdAfterDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selChgEvt) {
                BaselineSearchCriteriaPart.this.validateSearchDialog(true);
            }
        });
        this.validateSearchDialog(false);
    }

    private void createCustomAttributeFilter(Composite parent, WidgetToolkit toolkit, BaselineSearchCriteria input) {
        this.customAttributeSection = new CustomAttributeSectionForBaselineQueryEditor(this.getControlSite().getOperationRunner(), parent, toolkit, input);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.customAttributeSection.getControl());
        this.customAttributeSection.setInput(input);
        this.listener = new IChangeListener(){

            public void changed(Object source, Object property) {
                BaselineSearchCriteriaPart.this.notifySearchCriteriaUpdated();
            }
        };
        this.customAttributeSection.addListener(this.listener);
    }

    @Override
    public Label createComponentLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.BaslineSearchCriteriaPart_componentComboLabel));
    }

    @Override
    public BaselineSearchCriteria getResult() {
        Object[] customAttributesArray;
        BaselineSearchCriteria criteria = BaselineSearchCriteria.create(this.getRepository(), this.getComponentHndlFromComponentComboSelection(), this.getFullOrPartialBaselineName(), this.getContributorHandleFromCreatorComboSelection(), this.getCreatedBeforeOrAfterDate(this.createdBeforeDate), this.getCreatedBeforeOrAfterDate(this.createdAfterDate), this.getMaxResults(this.getMaxResultsText()));
        criteria.setIgnoreCase(this.ignoreCaseButton.getSelection());
        Object[] objectArray = customAttributesArray = this.customAttributeSection.getCustomAttributes();
        int n = customAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CustomAttributeEntry) {
                CustomAttributeEntry entry = (CustomAttributeEntry)object;
                criteria.setCustomAttribute(entry.getName(), entry.getValue());
            }
            ++n2;
        }
        return criteria;
    }

    private IComponentHandle getComponentHndlFromComponentComboSelection() {
        ComponentWrapper componentWrapper = this.getComponentCombo().getComponent();
        return componentWrapper != null ? componentWrapper.getComponent() : null;
    }

    private String getFullOrPartialBaselineName() {
        String baselineNameText = this.nameOrPatternText.getText();
        return baselineNameText == "" ? null : baselineNameText;
    }

    public Button getIgnoreCaseButton() {
        return this.ignoreCaseButton;
    }

    private int getMaxResults(Text maxResultText) {
        if (maxResultText == null) {
            return 1024;
        }
        int maxResults = 100;
        String maxResltTxt = maxResultText.getText();
        try {
            maxResults = Integer.parseInt(maxResltTxt);
        }
        catch (NumberFormatException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        return maxResults;
    }

    private IContributorHandle getContributorHandleFromCreatorComboSelection() {
        ItemId<? extends IAuditable> selectedOwner = this.getOwnerCombo().getSelection();
        if (selectedOwner == null) {
            return null;
        }
        IAuditableHandle result = (IAuditableHandle)selectedOwner.toHandle();
        if (result instanceof IContributorHandle) {
            return (IContributorHandle)result;
        }
        return null;
    }

    private Date getCreatedBeforeOrAfterDate(DatePickerControl beforeOrAfter) {
        Date beforeOrAfterDate = null;
        ISelection selection = beforeOrAfter.getSelection();
        IStructuredSelection structuredSel = null;
        Object timeStmpObj = null;
        if (selection == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            structuredSel = (IStructuredSelection)selection;
            timeStmpObj = structuredSel.getFirstElement();
            if (timeStmpObj == null) {
                return beforeOrAfterDate;
            }
            if (timeStmpObj instanceof Timestamp) {
                beforeOrAfterDate = new Date(((Timestamp)timeStmpObj).getTime());
            } else {
                return beforeOrAfterDate;
            }
        }
        return beforeOrAfterDate;
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    public void updateRepository(ITeamRepository repository) {
        super.updateRepository(repository);
        if (this.component != null) {
            this.component.addTheOneNode();
            this.component.selectTheOneNode();
        }
        if (this.creator != null) {
            this.creator.selectTheAnyNode();
        }
        this.validateSearchDialog(true);
    }

    @Override
    public void repositoryComboSelectionChanged(SelectionChangedEvent event) {
        super.repositoryComboSelectionChanged(event);
        if (this.customAttributeSection != null) {
            this.customAttributeSection.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void componentComboSelectionChanged() {
        this.notifySearchCriteriaUpdated();
        this.validateSearchDialog(true);
        if (this.customAttributeSection != null) {
            this.customAttributeSection.setSearchCriteria(this.getResult());
        }
    }

    @Override
    public void ownerComboSelectionChanged() {
        super.ownerComboSelectionChanged();
        this.validateSearchDialog(true);
    }

    public void validateSearchDialog(boolean showErrorIcon) {
        boolean repoSelected = this.repo != null && this.repo.getRepository() != null;
        boolean componentSelected = this.component != null && this.component.getComponent() != null;
        IStatus status = Status.OK_STATUS;
        if (showErrorIcon) {
            if (!repoSelected) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.RepositoryCombo_5);
            }
            if (!componentSelected) {
                status = StatusUtil.newStatus((Object)((Object)this), (int)4, (int)-1163014131, (String)Messages.BaslineSearchCriteriaPart_baselineComponentMissing);
            }
        }
        if (!showErrorIcon) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)4, (int)-1163014131, (String)Messages.ChangeSetSearchCriteriaWizardPage_pageDescription);
        }
        this.baselineSearchCriteriaValidation.setValue((Object)status);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.nameOrPatternText != null && !this.nameOrPatternText.isDisposed()) {
            this.nameOrPatternText.setEnabled(isEnabled);
        }
        if (this.ignoreCaseButton != null && !this.ignoreCaseButton.isDisposed()) {
            this.ignoreCaseButton.setEnabled(isEnabled);
        }
        if (this.createdAfterDate != null && !this.createdAfterDate.getControl().isDisposed()) {
            this.createdAfterDate.getControl().setEnabled(isEnabled);
        }
        if (this.createdBeforeDate != null && !this.createdBeforeDate.getControl().isDisposed()) {
            this.createdBeforeDate.getControl().setEnabled(isEnabled);
        }
    }

    @Override
    protected void dispose() {
        if (this.customAttributeSection != null) {
            this.customAttributeSection.removeListener(this.listener);
        }
        super.dispose();
    }
}

