/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search.baseline;

import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.ICustomAttributeSearchFilter;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BaselineSearchCriteria
extends AbstractSearchInput<BaselineWrapper> {
    private ITeamRepository repo;
    private ItemId<IContributor> createdBy = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
    private ItemId<IComponent> component = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    private String nameOrPattern = "";
    private boolean ignoreCase = false;
    private Date modifiedBefore = null;
    private Date modifiedAfter = null;
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();

    private BaselineSearchCriteria(ITeamRepository repo) {
        this.repo = repo;
    }

    private BaselineSearchCriteria(ITeamRepository repo, IComponentHandle componentHandle, String nameOrPattern, IContributorHandle creatorHandle, Date modifiedBefore, Date modifiedAfter, int maxResults) {
        this.repo = repo;
        if (componentHandle != null) {
            this.component = new ItemId((IItemHandle)componentHandle);
        }
        if (creatorHandle != null) {
            this.createdBy = new ItemId((IItemHandle)creatorHandle);
        }
        this.nameOrPattern = nameOrPattern;
        this.modifiedBefore = modifiedBefore;
        this.modifiedAfter = modifiedAfter;
        this.setMaxResults(maxResults);
    }

    public static BaselineSearchCriteria create(ITeamRepository repo) {
        return new BaselineSearchCriteria(repo);
    }

    public static BaselineSearchCriteria create(ITeamRepository repo, IComponentHandle componentHandle, String nameOrPattern, IContributorHandle creatorHandle, Date createdBefore, Date createdAfter, int maxResults) {
        return new BaselineSearchCriteria(repo, componentHandle, nameOrPattern, creatorHandle, createdBefore, createdAfter, maxResults);
    }

    @Override
    public ISetWithListeners<BaselineWrapper> getQuery(IOperationRunner runner, boolean lazyUpdates) {
        return new BaselineSearchQuery(runner, this);
    }

    @Override
    public String getSearchName(IProgressMonitor monitor) throws TeamRepositoryException {
        Map fetched = null;
        IContributor contributor = null;
        IComponent fetchedComponent = null;
        String searchName = Messages.BaselineSearchCriteria_baselinesNoun;
        if (this.component != null && !this.component.isNull()) {
            fetched = this.createdBy != null && !this.createdBy.isNull() ? RepoFetcher.fetchCurrents((ITeamRepository)this.repo, (IProgressMonitor)monitor, (ItemId[])new ItemId[]{this.createdBy, this.component}) : RepoFetcher.fetchCurrents((ITeamRepository)this.repo, (IProgressMonitor)monitor, (ItemId[])new ItemId[]{this.component});
            fetchedComponent = (IComponent)fetched.get(this.component);
        }
        if (this.nameOrPattern != null && !this.nameOrPattern.equals("")) {
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounNamePrefixTextPhrase, (Object)searchName, (Object)this.nameOrPattern);
        }
        if (fetched != null && fetchedComponent != null) {
            String componentName = fetchedComponent == null ? Messages.BaselineSearchCriteria_unknownComponentName : fetchedComponent.getName();
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounBelongingToComponentPrase, (Object)searchName, (Object)componentName);
        }
        searchName = NLS.bind((String)Messages.AbstractSearchInput_searchNameOnRepository, (Object)searchName, (Object)RepositoryUtils.getLabel(this.repo));
        if (this.createdBy != null && !this.createdBy.isNull() && fetched != null) {
            contributor = (IContributor)fetched.get(this.createdBy);
            String contributorName = contributor == null ? Messages.BaselineSearchCriteria_unknownContributorName : contributor.getName();
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounCreatedByPhrase, (Object)searchName, (Object)contributorName);
        }
        DateFormat format = DateFormat.getDateInstance();
        if (this.modifiedBefore != null && this.modifiedAfter != null) {
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounCreatedBetweenDatesPhrase, (Object[])new String[]{searchName, format.format(this.modifiedAfter), format.format(this.modifiedBefore)});
        } else if (this.modifiedBefore != null) {
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounCreatedBeforeDatePhrase, (Object)searchName, (Object)format.format(this.modifiedBefore));
        } else if (this.modifiedAfter != null) {
            searchName = NLS.bind((String)Messages.BaselineSearchCriteria_nounCreatedAfterDatePhrase, (Object)searchName, (Object)format.format(this.modifiedAfter));
        }
        if (!this.customAttributes.isEmpty()) {
            searchName = NLS.bind((String)Messages.AbstractSearchInput_filterByCustomAttributes, (Object)searchName);
        }
        return searchName;
    }

    public ITeamRepository getRepo() {
        return this.repo;
    }

    public IContributorHandle getCreatedByHandle() {
        if (this.createdBy != null && !this.createdBy.isNull()) {
            return (IContributorHandle)this.createdBy.toHandle();
        }
        return null;
    }

    public ItemId<IContributor> getCreatedBy() {
        return this.createdBy;
    }

    public ItemId<IComponent> getComponent() {
        return this.component;
    }

    public IComponentHandle getComponentHandle() {
        if (this.component != null && !this.component.isNull()) {
            return (IComponentHandle)this.component.toHandle();
        }
        return null;
    }

    public String getNameOrPattern() {
        return this.nameOrPattern;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Date getModifiedBefore() {
        return this.modifiedBefore;
    }

    public Date getModifiedAfter() {
        return this.modifiedAfter;
    }

    public BaselineSearchCriteria setRepo(ITeamRepository repo) {
        this.repo = repo;
        return this;
    }

    public BaselineSearchCriteria setCreatedBy(ItemId<IContributor> createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public BaselineSearchCriteria setComponent(ItemId<IComponent> component) {
        this.component = component;
        return this;
    }

    public BaselineSearchCriteria setFullText(String fullText) {
        this.nameOrPattern = fullText;
        return this;
    }

    public BaselineSearchCriteria setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public BaselineSearchCriteria setModifiedBefore(Date modifiedBefore) {
        this.modifiedBefore = modifiedBefore;
        return this;
    }

    public BaselineSearchCriteria setModifiedAfter(Date modifiedAfter) {
        this.modifiedAfter = modifiedAfter;
        return this;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repo;
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(name, newValue);
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        for (CustomAttributeEntry customAttributeEntry : toRemove) {
            this.customAttributes.remove(customAttributeEntry.getName());
        }
    }

    public void addCustomAttribute(CustomAttributeEntry entry) {
        CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(entry.getName(), entry.getValue());
        this.customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
    }

    public Object[] getCustomAttributesArray() {
        return this.customAttributes.values().toArray(new CustomAttributeEntry[this.customAttributes.size()]);
    }

    public Map<String, CustomAttributeEntry> getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public boolean isEquivalentTo(ISearchCriteria otherCriteria) {
        if (otherCriteria instanceof IBaselineSearchCriteria) {
            IBaselineSearchCriteria otherBaselineCriteria = (IBaselineSearchCriteria)otherCriteria;
            return otherBaselineCriteria.asQueryCriteria().sameAs(BaselineSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    @Override
    public boolean isEquivalentTo(AbstractSearchInput otherCriteria) {
        if (otherCriteria instanceof BaselineSearchCriteria) {
            BaselineSearchCriteria otherUICriteria = (BaselineSearchCriteria)otherCriteria;
            ITeamRepository thisRepo = this.getRepository();
            ITeamRepository otherRepo = otherCriteria.getRepository();
            if (thisRepo == null ? otherRepo != null : !thisRepo.equals(otherRepo)) {
                return false;
            }
            return BaselineSearchCriteria.asSearchCriteriaDTO(otherUICriteria).asQueryCriteria().sameAs(BaselineSearchCriteria.asSearchCriteriaDTO(this).asQueryCriteria());
        }
        return false;
    }

    public boolean isValid() {
        return this.getComponentHandle() != null;
    }

    public static IBaselineSearchCriteria asSearchCriteriaDTO(BaselineSearchCriteria uiSearchCriteria) {
        IBaselineSearchCriteria searchCriteriaDTO = IBaselineSearchCriteria.FACTORY.newInstance();
        if (uiSearchCriteria != null) {
            String nameOrPattern;
            if (uiSearchCriteria.getComponentHandle() != null) {
                searchCriteriaDTO.setComponentRequired(uiSearchCriteria.getComponentHandle());
            }
            if ((nameOrPattern = uiSearchCriteria.getNameOrPattern()) != null && !nameOrPattern.equals("")) {
                if (uiSearchCriteria.isIgnoreCase()) {
                    searchCriteriaDTO.setPartialNameIgnoreCase(nameOrPattern);
                } else {
                    searchCriteriaDTO.setPartialName(nameOrPattern);
                }
            }
            if (uiSearchCriteria.getCreatedByHandle() != null) {
                searchCriteriaDTO.getFilterByCreatorOptional().add(uiSearchCriteria.getCreatedByHandle());
            }
            if (uiSearchCriteria.getModifiedAfter() != null) {
                searchCriteriaDTO.setModifiedAfterOptional(uiSearchCriteria.getModifiedAfter());
            }
            if (uiSearchCriteria.getModifiedBefore() != null) {
                searchCriteriaDTO.setModifiedBeforeOptional(uiSearchCriteria.getModifiedBefore());
            }
            for (Map.Entry<String, CustomAttributeEntry> entry : uiSearchCriteria.getCustomAttributes().entrySet()) {
                searchCriteriaDTO.getFilterByCustomAttributeOptional().add(entry.getValue().asCustomAttributeSearchFilter());
            }
        }
        return searchCriteriaDTO;
    }

    public static BaselineSearchCriteria createFromSearchCriteriaDTO(ITeamRepository repo, IBaselineSearchCriteria searchCriteriaDTO) {
        BaselineSearchCriteria baselineSearchCriteria = BaselineSearchCriteria.create(repo);
        baselineSearchCriteria.setRepo(repo);
        boolean ignoreCase = false;
        HashMap<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
        if (searchCriteriaDTO != null) {
            List filterByCustomAttributeOptional;
            IComponentHandle componentHandle = searchCriteriaDTO.getRequiredComponent();
            if (componentHandle != null) {
                baselineSearchCriteria.setComponent((ItemId<IComponent>)new ItemId((IItemHandle)componentHandle));
            }
            String nameOrPattern = "";
            String exactName = searchCriteriaDTO.getExactName();
            String partialNameIgnoreCase = searchCriteriaDTO.getPartialNameIgnoreCase();
            NameFilter nameFilter = searchCriteriaDTO.getOptionalNameFilter();
            if (exactName != null) {
                nameOrPattern = exactName;
            } else if (partialNameIgnoreCase != null) {
                nameOrPattern = partialNameIgnoreCase;
                ignoreCase = true;
            } else if (nameFilter != null && nameFilter.getMatchPattern() != null) {
                nameOrPattern = nameFilter.getMatchPattern();
            }
            baselineSearchCriteria.setFullText(nameOrPattern);
            baselineSearchCriteria.setModifiedBefore(searchCriteriaDTO.getModifiedBeforeOptional());
            baselineSearchCriteria.setModifiedAfter(searchCriteriaDTO.getModifiedAfterOptional());
            List creators = searchCriteriaDTO.getFilterByCreatorOptional();
            if (creators != null && creators.size() > 0 && creators.get(0) != null) {
                baselineSearchCriteria.setCreatedBy((ItemId<IContributor>)new ItemId((IItemHandle)creators.get(0)));
            }
            if ((filterByCustomAttributeOptional = searchCriteriaDTO.getFilterByCustomAttributeOptional()) != null && !filterByCustomAttributeOptional.isEmpty()) {
                for (ICustomAttributeSearchFilter customAttributeSearchFilter : filterByCustomAttributeOptional) {
                    CustomAttributeEntry customAttributeEntry = new CustomAttributeEntry(customAttributeSearchFilter.getName(), customAttributeSearchFilter.getStringValue());
                    customAttributes.put(customAttributeEntry.getName(), customAttributeEntry);
                }
            }
        }
        baselineSearchCriteria.setIgnoreCase(ignoreCase);
        baselineSearchCriteria.customAttributes = customAttributes;
        return baselineSearchCriteria;
    }
}

