/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.ValidatorStatus;
import com.ibm.team.repository.rcp.ui.parts.AbstractEditorPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.workingcopy.IPreferencesWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SearchPreferencesPart
extends AbstractEditorPart {
    public static final String COUNT = "count";
    public static final int DEFAULT_COUNT = 1024;
    private Text value;
    private CombinedStatus validationStatus = new CombinedStatus();
    private IEclipsePreferences prefs;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals(SearchPreferencesPart.COUNT)) {
                int intValue;
                int newValue = SearchPreferencesPart.this.prefs.getInt(SearchPreferencesPart.COUNT, 1024);
                try {
                    intValue = Integer.parseInt(SearchPreferencesPart.this.value.getText());
                }
                catch (NumberFormatException nfe) {
                    intValue = 0;
                }
                if (newValue != intValue) {
                    SearchPreferencesPart.this.value.setText("" + newValue);
                }
            }
        }
    };

    public SearchPreferencesPart(IControlSite site, Object input) {
        super(site, input);
        MnemonicGenerator mg = site.getMnemonicGenerator();
        site.getNameable().setName(Messages.SearchPreferencesPart_0);
        site.getNameable().setContentDescription(Messages.SearchPreferencesPart_1);
        IPreferencesWorkingCopy workingCopy = (IPreferencesWorkingCopy)this.getWorkingCopy();
        this.prefs = workingCopy.getPreferences();
        this.prefs.addPreferenceChangeListener(this.preferenceChangeListener);
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        Composite lastEntriesGroup = toolkit.createComposite(parent);
        toolkit.createLabel(lastEntriesGroup, mg.generate(Messages.SearchPreferencesPart_2));
        this.value = toolkit.createText(lastEntriesGroup, "" + this.prefs.getInt(COUNT, 1024), 2048);
        this.value.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                e.doit = Character.isDigit(e.character) || e.character == '\r' || e.character == '\u001b' || e.character == '\n' || e.character == '\b' || e.character < ' ' || e.character == '\u007f';
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.value.setTextLimit(10);
        ValidatorStatus valueValidator = new ValidatorStatus((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.value));
        valueValidator.addValidator(new IValidator(){

            public IStatus validate(Object value) {
                int intValue;
                String text = (String)value;
                if (text.length() == 0) {
                    return DatabindingUtil.createNoIconMessage((int)4, (String)Messages.SearchPreferencesPart_3);
                }
                try {
                    intValue = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.SearchPreferencesPart_4, (Object)text));
                }
                if (intValue == 0) {
                    return StatusUtil.newStatus((Object)this, (String)Messages.SearchPreferencesPart_5);
                }
                if (intValue > 2048) {
                    return StatusUtil.newStatus((Object)this, (int)2, (String)Messages.SearchPreferencesPart_6);
                }
                return Status.OK_STATUS;
            }
        });
        this.validationStatus.addStatus((IObservableValue)valueValidator);
        this.value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int intValue;
                String text = SearchPreferencesPart.this.value.getText();
                try {
                    intValue = Integer.parseInt(text);
                }
                catch (NumberFormatException nfe) {
                    intValue = 0;
                }
                if (SearchPreferencesPart.this.prefs.getInt(SearchPreferencesPart.COUNT, 0) != intValue) {
                    SearchPreferencesPart.this.prefs.putInt(SearchPreferencesPart.COUNT, intValue);
                }
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(lastEntriesGroup);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(parent);
        DatabindingUtil.bindMessage((IControlSite)site, (IObservableValue)this.validationStatus);
    }

    protected void dispose() {
        this.prefs.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
    }

    public IWorkingCopy getWorkingCopy() {
        return super.getWorkingCopy();
    }
}

