/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search;

import com.ibm.icu.text.Collator;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProjectAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.SearchPreferencesPart;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.rcp.ui.internal.menus.EmptyMenu;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SingleEntryMenu;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferencesInputFactory;
import com.ibm.team.repository.rcp.ui.internal.query.DirtyBlinker;
import com.ibm.team.repository.rcp.ui.internal.query.ILazyUpdatable;
import com.ibm.team.repository.rcp.ui.internal.query.PopupLayout;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ContextMenuHandler;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IGlobalActionHandler;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopies;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.swt.IFocusService;

public abstract class AbstractSearchPage<T>
extends AbstractPart
implements IReusablePart,
IRefreshable,
IMenuProvider {
    public static final Comparator<AbstractFileSystemItemWrapper> abstractFileSystemItemWrapperComparator = new Comparator<AbstractFileSystemItemWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(AbstractFileSystemItemWrapper a1, AbstractFileSystemItemWrapper a2) {
            return this.fCollator.compare(a1.getFQName(), a2.getFQName());
        }
    };
    public static final Comparator<AbstractPlaceWrapper> abstractPlaceWrapperComparator = new Comparator<AbstractPlaceWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(AbstractPlaceWrapper a1, AbstractPlaceWrapper a2) {
            String name1 = a1 != null ? a1.getWorkspace().getName() : "";
            String name2 = a2 != null ? a2.getWorkspace().getName() : "";
            return this.fCollator.compare(name1, name2);
        }
    };
    public static final Comparator<AbstractWrapper> ownerComparator = new Comparator<AbstractWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(AbstractWrapper wrapper1, AbstractWrapper wrapper2) {
            String name1 = "";
            String name2 = "";
            if (wrapper1 instanceof ContributorWrapper) {
                ContributorWrapper c1 = (ContributorWrapper)wrapper1;
                name1 = c1.getContributor().getName();
            }
            if (wrapper2 instanceof ContributorWrapper) {
                ContributorWrapper c2 = (ContributorWrapper)wrapper2;
                name2 = c2.getContributor().getName();
            }
            if (wrapper1 instanceof TeamAreaWrapper) {
                TeamAreaWrapper t1 = (TeamAreaWrapper)wrapper1;
                name1 = t1.getTeamArea().getName();
            }
            if (wrapper2 instanceof TeamAreaWrapper) {
                TeamAreaWrapper t2 = (TeamAreaWrapper)wrapper2;
                name2 = t2.getTeamArea().getName();
            }
            if (wrapper1 instanceof ProjectAreaWrapper) {
                ProjectAreaWrapper p1 = (ProjectAreaWrapper)wrapper1;
                name1 = p1.getProjectArea().getName();
            }
            if (wrapper2 instanceof ProjectAreaWrapper) {
                ProjectAreaWrapper p2 = (ProjectAreaWrapper)wrapper2;
                name2 = p2.getProjectArea().getName();
            }
            return this.fCollator.compare(name1, name2);
        }
    };
    public static final Comparator<ComponentWrapper> componentWrapperComparator = new Comparator<ComponentWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(ComponentWrapper component1, ComponentWrapper component2) {
            return this.fCollator.compare(component1.getComponent().getName(), component2.getComponent().getName());
        }
    };
    public static final Comparator<Date> dateComparator = new Comparator<Date>(){

        @Override
        public int compare(Date date1, Date date2) {
            return date1.compareTo(date2);
        }
    };
    public static final Comparator<SnapshotWrapper> snapshotWrapperComparator = new Comparator<SnapshotWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(SnapshotWrapper s1, SnapshotWrapper s2) {
            return this.fCollator.compare(s1.getSnapshot().getName(), s2.getSnapshot().getName());
        }
    };
    public static final Comparator<WorkspaceComponentWrapper> workspaceComponentWrapperComparator = new Comparator<WorkspaceComponentWrapper>(){
        private Collator fCollator = CollatorCache.getInstance();

        @Override
        public int compare(WorkspaceComponentWrapper w1, WorkspaceComponentWrapper w2) {
            String name1 = w1.getComponent() != null ? w1.getComponent().getName() : "";
            String name2 = w2.getComponent() != null ? w2.getComponent().getName() : "";
            return this.fCollator.compare(name1, name2);
        }
    };
    private AbstractSearchInput<T> searchInput;
    private SimpleTableViewer<T> viewer;
    private DirtyBlinker blinker;
    private ILazyUpdatable lazyModel;
    private IFocusService focusService;
    private IChangeListener dirtyListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            AbstractSearchPage.this.updateBlinker();
        }
    };
    private Composite refreshPopup;
    private IMenuExt viewMenuContribution;
    private PushAction preferencesAction;

    protected AbstractSearchPage(IControlSite site, AbstractSearchInput<T> input) {
        super(site, input);
        WidgetToolkit toolkit = site.getToolkit();
        IContextMenuHandler cmh = (IContextMenuHandler)Adapters.getAdapter((Object)site, IContextMenuHandler.class);
        if (cmh == null) {
            throw new IllegalArgumentException("This view can only be hosted in a site that supports context menus");
        }
        INameable nameable = site.getNameable();
        IEclipsePreferences prefs = this.getConfigPrefs();
        PopupLayout layout = new PopupLayout();
        site.getParent().setLayout((Layout)layout);
        this.viewer = new SimpleTableViewer(site.getParent(), 82690, prefs.node("table"), (IContextMenuHandler)new ContextMenuHandler(cmh));
        layout.setMainControl((Control)this.viewer.getTable());
        this.viewer.setProgressService((IBusyHandler)site);
        if (cmh != null) {
            ContextMenuHelper.addNewSubmenu((IMenuManager)this.viewer.getContextMenu(), (boolean)false);
            cmh.registerContextMenu(this.getMenuID(), this.viewer.getContextMenu(), this.viewer.getSelectionProvider());
        }
        MenuUtil.setDefaultAction(this.viewer.getContextMenu(), this.getDefaultActionId());
        this.addColumns(site.getContext(), this.viewer);
        IPartSiteServices pss = (IPartSiteServices)Adapters.getAdapter((Object)site, IPartSiteServices.class);
        if (pss != null) {
            this.viewer.setDoubleClickHandler((IRunnableWithSelection)new OpenAction(pss.getPage()));
            this.focusService = (IFocusService)pss.getPart().getSite().getService(IFocusService.class);
            if (this.focusService != null) {
                this.focusService.addFocusTracker((Control)this.viewer.getTable(), this.viewer.getTable().getClass().getName());
            }
            IGlobalActionHandler gah = (IGlobalActionHandler)Adapters.getAdapter((Object)site, IGlobalActionHandler.class);
            TanActions.addTanActions(gah, (IMenuManager)this.viewer.getContextMenu(), (IWorkbenchSite)pss.getPart().getSite(), this.viewer.getSelectionProvider(), IMenuOperationTarget.ALL_TYPES);
        }
        this.blinker = new DirtyBlinker(nameable, ImagePool.SEARCH_VIEW);
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        this.refreshPopup = toolkit.createComposite(site.getParent());
        toolkit.createLabel(this.refreshPopup, "", 258);
        Link hyperlink = new Link(this.refreshPopup, 0);
        hyperlink.setText(Messages.AbstractSearchPage_0);
        hyperlink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractSearchPage.this.doUpdate();
            }
        });
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)hyperlink);
        hyperlink.setBackground(this.refreshPopup.getBackground());
        int margin = LayoutConstants.getSpacing().y;
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(0, 0, 0, margin).spacing(0, margin).generateLayout(this.refreshPopup);
        this.refreshPopup.setVisible(false);
        this.viewMenuContribution = new SingleEntryMenu(this.getPreferencesAction());
        this.setInput(input);
    }

    private IActionExt getPreferencesAction() {
        if (this.preferencesAction == null) {
            this.preferencesAction = new PushAction(Messages.HistoryView_preferencesAction, new Runnable(){

                @Override
                public void run() {
                    AbstractSearchPage.this.openPreferences();
                }
            });
        }
        return this.preferencesAction;
    }

    private void openPreferences() {
        PartFactory factory = new PartFactory(SearchPreferencesPart.class);
        IWorkingCopyFactory input = PreferencesInputFactory.getPreferencesWorkingCopy((String)"configuration", (String)this.getConfigPrefs().absolutePath(), (String)Messages.AbstractSearchPage_1);
        final IWizardPage wizardPage = Parts.createWizardPage((Object)input, (IPartFactory)factory, (String)"prefs", null);
        final Shell shell = this.getControlSite().getShell();
        WizardUtil.open((Shell)shell, (String)Messages.HistoryView_preferencesDialogTitle, (IWizardPage)wizardPage, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                SearchPreferencesPart part = (SearchPreferencesPart)((Object)Adapters.getAdapter((Object)wizardPage, SearchPreferencesPart.class));
                IWorkingCopy wc = part.getWorkingCopy();
                WorkingCopies.performSave((Shell)shell, (IWorkingCopy)wc, null);
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.preference_page_search_view");
    }

    protected void doUpdate() {
        if (this.lazyModel != null) {
            this.lazyModel.confirmUpdate();
        }
    }

    protected void updateBlinker() {
        boolean dirty;
        boolean bl = dirty = this.lazyModel != null && this.lazyModel.getDirtyFlag().getValue().equals(true);
        if (this.refreshPopup.getVisible() == dirty) {
            return;
        }
        this.blinker.setDirty(dirty);
        this.refreshPopup.setVisible(dirty);
        Composite popupParent = this.getControlSite().getParent();
        popupParent.changed(new Control[]{this.refreshPopup});
        popupParent.layout(false);
    }

    protected String getDefaultActionId() {
        return "jazz.open";
    }

    protected abstract String getMenuID();

    protected abstract void addColumns(WidgetFactoryContext var1, SimpleTableViewer<T> var2);

    private IEclipsePreferences getConfigPrefs() {
        return ConfigurationScope.INSTANCE.getNode("com.ibm.team.filesystem.ide.ui/SharedSearchPreferences");
    }

    public void setInput(Object newInput) {
        if (newInput instanceof AbstractSearchInput) {
            this.searchInput = (AbstractSearchInput)newInput;
            if (!this.searchInput.isMaxResultsSet()) {
                this.searchInput.setMaxResultPreference(this.getConfigPrefs(), "count");
            }
            ISetWithListeners<T> query = this.searchInput.getQuery(this.getControlSite().getOperationRunner(), true);
            this.viewer.setInput(query);
            ILazyUpdatable lazyUpdater = (ILazyUpdatable)Adapters.getAdapter(query, ILazyUpdatable.class);
            this.setLazyModel(lazyUpdater);
            this.getControlSite().getNameable().setContentDescription(Messages.AbstractSearchPage_pendingContentDescription);
            this.updateContentDescription();
        }
    }

    private void updateContentDescription() {
        if (this.searchInput == null || this.viewer == null || this.viewer.getInput() == null) {
            return;
        }
        final ISetWithListeners query = this.viewer.getInput();
        final Display d = Display.getCurrent();
        this.getControlSite().getOperationRunner().enqueue(Messages.AbstractSearchPage_runningSearchJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final String contentDescription = AbstractSearchPage.this.searchInput.getSearchName(monitor);
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int resultSize = query.size();
                        String message = resultSize == 1 ? Messages.AbstractSearchPage_itemsFoundSingular : Messages.AbstractSearchPage_itemsFoundPlural;
                        String extraResults = "";
                        if (AbstractSearchPage.this.searchInput.getMaxResults() <= query.size()) {
                            extraResults = Messages.AbstractSearchPage_hasMoreResultsTitleDecorator;
                        }
                        Object[] bindings = new String[]{String.valueOf(resultSize), contentDescription, extraResults};
                        AbstractSearchPage.this.getControlSite().getNameable().setContentDescription(NLS.bind((String)message, (Object[])bindings));
                    }
                });
            }
        });
    }

    private void setLazyModel(ILazyUpdatable lazyUpdater) {
        if (this.lazyModel != null) {
            this.lazyModel.getDirtyFlag().removeChangeListener(this.dirtyListener);
        }
        this.lazyModel = lazyUpdater;
        if (this.lazyModel != null) {
            this.lazyModel.getDirtyFlag().addChangeListener(this.dirtyListener);
        }
        this.updateBlinker();
    }

    protected void dispose() {
        this.setLazyModel(null);
        this.blinker.dispose();
        if (this.focusService != null) {
            this.focusService.removeFocusTracker((Control)this.viewer.getTable());
        }
        super.dispose();
    }

    public void refresh() {
        IRefreshable refreshable = (IRefreshable)Adapters.getAdapter((Object)this.viewer.getInput(), IRefreshable.class);
        if (refreshable != null) {
            refreshable.refresh();
            this.updateContentDescription();
        }
    }

    public boolean canRefresh() {
        return true;
    }

    public IMenuExt getToolbarContributions() {
        return EmptyMenu.getInstance();
    }

    public IMenuExt getMenuContributions() {
        return this.viewMenuContribution;
    }

    public static final class FileSearchComparator
    implements Comparator<AbstractFileSystemItemWrapper> {
        public static final String FILE_NAME = "name";
        public static final String FILE_PATH = "path";
        public static final String FILE_COMPONENT = "component";
        public static final String FILE_VERSION = "version";
        private Collator fCollator = CollatorCache.getInstance();
        private String fPropertyName;

        public FileSearchComparator(String propertyName) {
            if (StringUtils.isEmpty((String)propertyName)) {
                throw new IllegalArgumentException("'propertyName' cannot be null.");
            }
            this.fPropertyName = propertyName;
        }

        @Override
        public int compare(AbstractFileSystemItemWrapper o1, AbstractFileSystemItemWrapper o2) {
            int result = 0;
            if (this.fPropertyName.equalsIgnoreCase(FILE_NAME)) {
                int fileNameCompare = this.fCollator.compare(o1.getName(), o2.getName());
                if (fileNameCompare == 0) {
                    return this.fCollator.compare(o1.getPath(), o2.getPath());
                }
                return fileNameCompare;
            }
            if (this.fPropertyName.equalsIgnoreCase(FILE_PATH)) {
                return this.fCollator.compare(o1.getPath(), o2.getPath());
            }
            if (this.fPropertyName.equalsIgnoreCase(FILE_COMPONENT)) {
                String component1Name = o1.getComponent() != null ? o1.getComponent().getName() : "";
                String component2Name = o2.getComponent() != null ? o2.getComponent().getName() : "";
                return this.fCollator.compare(component1Name, component2Name);
            }
            if (this.fPropertyName.equalsIgnoreCase(FILE_VERSION)) {
                String val1 = !StringUtils.isEmpty((String)o1.getVersionNumber()) ? o1.getVersionNumber() : "";
                String val2 = !StringUtils.isEmpty((String)o1.getVersionNumber()) ? o2.getVersionNumber() : "";
                return this.fCollator.compare(val1, val2);
            }
            return result;
        }
    }
}

