/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class AbstractSearchInput<T> {
    public static final int MAX_TO_SHOW = 1024;
    private int maxResults;
    protected IEclipsePreferences preferenceStore;
    protected String maxResultKey;

    public abstract String getSearchName(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract ISetWithListeners<T> getQuery(IOperationRunner var1, boolean var2);

    public abstract ITeamRepository getRepository();

    public abstract boolean isEquivalentTo(ISearchCriteria var1);

    public abstract boolean isEquivalentTo(AbstractSearchInput var1);

    public int getMaxResults() {
        if (this.preferenceStore != null) {
            return this.preferenceStore.getInt(this.maxResultKey, 1024);
        }
        if (this.isMaxResultsSet()) {
            return this.maxResults;
        }
        return 1024;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setMaxResultPreference(IEclipsePreferences store, String key) {
        this.preferenceStore = store;
        this.maxResultKey = key;
    }

    public boolean isMaxResultsSet() {
        return this.maxResults > 0;
    }
}

