/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.search;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ComponentCombo;
import com.ibm.team.internal.filesystem.ui.picker.LocationCombo;
import com.ibm.team.internal.filesystem.ui.picker.OwnerSelectionField;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.picker.VersionablePicker;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class AbstractSearchCriteriaPart<T extends AbstractSearchInput>
extends AbstractPart {
    private ListenerList fSearchCriteriaListenerList = new ListenerList();
    private IOperationRunner background;
    private RepositoryCombo repositoryCombo;
    private ComponentCombo componentCombo;
    private LocationCombo locationCombo;
    private OwnerSelectionField ownerCombo;
    private VersionablePicker versionablePicker;
    private Text maxResultsText;
    private Preferences maxResultsPrefs;
    public static final String MAX_RESULTS_PREFS_KEY = "maxResults";
    private CombinedStatus validationStatus = new CombinedStatus();
    private WritableValue componentLocationValidation = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    private WritableValue maxResultsValidation = new WritableValue((Object)Status.OK_STATUS, IStatus.class);
    private boolean isLocationPresent;

    public AbstractSearchCriteriaPart(IControlSite site, Object input) {
        super(site, input);
    }

    public RepositoryCombo getRepositoryCombo() {
        return this.repositoryCombo;
    }

    public ComponentCombo getComponentCombo() {
        return this.componentCombo;
    }

    public LocationCombo getLocationCombo() {
        return this.locationCombo;
    }

    public OwnerSelectionField getOwnerCombo() {
        return this.ownerCombo;
    }

    public VersionablePicker getVersionablePicker() {
        return this.versionablePicker;
    }

    public Text getMaxResultsText() {
        return this.maxResultsText;
    }

    public CombinedStatus getValidationStatus() {
        return this.validationStatus;
    }

    public Label createRepoLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.ChangeSetSearchCriteriaPart_repositoryComboLabel));
    }

    public RepositoryCombo createRepositoryCombo(Composite parent, Preferences prefs, WidgetFactoryContext context) {
        this.repositoryCombo = new RepositoryCombo(parent, prefs.node("repository"), context);
        this.repositoryCombo.setLoginButtonText(Messages.ChangeSetSearchCriteriaPart_loginButtonLabel);
        return this.repositoryCombo;
    }

    public Label createComponentLabel(Composite parent, WidgetFactoryContext context) {
        return this.createComponentLabel(Messages.ChangeSetSearchCriteriaPart_componentComboLabel, parent, context);
    }

    public Label createComponentLabel(String ComponentLabel, Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(ComponentLabel));
    }

    public ComponentCombo createComponentCombo(Composite parent, WidgetFactoryContext context) {
        this.componentCombo = new ComponentCombo(parent, context, 1);
        this.background = context.getBackgroundOperationRunner();
        return this.componentCombo;
    }

    public ComponentCombo createComponentCombo(Composite parent, WidgetFactoryContext context, int specialNodeFlags) {
        this.componentCombo = new ComponentCombo(parent, context, specialNodeFlags);
        this.background = context.getBackgroundOperationRunner();
        return this.componentCombo;
    }

    public Label createLocationLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.ChangeSetSearchCriteriaPart_locationComboLabel));
    }

    public LocationCombo createLocationCombo(Composite parent, WidgetFactoryContext context, int flags) {
        this.locationCombo = new LocationCombo(parent, context, null, flags);
        return this.locationCombo;
    }

    public LocationCombo createLocationCombo(Composite parent, WidgetFactoryContext context, int flags, String anyNodeText) {
        this.locationCombo = new LocationCombo(parent, context, null, flags, anyNodeText);
        return this.locationCombo;
    }

    public Label createOwnerLabel(Composite parent, WidgetFactoryContext context, String string) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(string));
    }

    public OwnerSelectionField createOwnerCombo(Composite parent, WidgetFactoryContext context, int flags) {
        this.ownerCombo = new OwnerSelectionField(parent, context, null, flags);
        return this.ownerCombo;
    }

    public Label createVersionableLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.ChangeSetSearchCriteriaPart_modifiesFileLabel));
    }

    public VersionablePicker createVersionablePicker(Composite parent, WidgetFactoryContext context) {
        this.versionablePicker = new VersionablePicker(parent, context, VersionablePicker.FLAG_NONE);
        return this.versionablePicker;
    }

    public Label createMaxResultLabel(Composite parent, WidgetFactoryContext context) {
        return context.getToolkit().createLabel(parent, context.getMnemonics().generate(Messages.AbstractSearchCriteriaPart_1));
    }

    public Text createMaxResultText(Composite parent, Preferences maxResultsPrefs, WidgetFactoryContext context) {
        this.maxResultsPrefs = maxResultsPrefs;
        String maxResults = maxResultsPrefs.get(MAX_RESULTS_PREFS_KEY, "100");
        this.maxResultsText = context.getToolkit().createText(parent, maxResults);
        return this.maxResultsText;
    }

    public void initialize(ITeamRepository repo, IComponentHandle componentHandle, IContextHandle contextHandle, ItemId<? extends IAuditable> ownerId, IVersionableHandle versionableHandle) {
        if (repo != null) {
            this.repositoryCombo.setSelectedElement(repo);
        }
        this.repositoryCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractSearchCriteriaPart.this.repositoryComboSelectionChanged(event);
            }
        });
        this.validationStatus.addStatus(this.repositoryCombo.getValidationStatus());
        if (this.componentCombo != null) {
            if (componentHandle != null && repo != null) {
                ItemId componentId = new ItemId((IItemHandle)componentHandle);
                this.componentCombo.setSelectedComponent(repo, (ItemId<IComponent>)componentId);
            } else if (this.componentCombo.isAnyNodePresent()) {
                this.componentCombo.selectTheAnyNode();
            } else if (this.componentCombo.isOneNodePresent()) {
                this.componentCombo.selectTheOneNode();
            } else {
                this.componentCombo.setSelectedElement(this.componentCombo.getComponent());
            }
            this.componentCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (AbstractSearchCriteriaPart.this.componentCombo.getComponent() != null) {
                        AbstractSearchCriteriaPart.this.componentCombo.removeSpecialNode(ComponentCombo.ONE_NODE_LABEL);
                    }
                    AbstractSearchCriteriaPart.this.componentComboSelectionChanged();
                }
            });
            this.validationStatus.addStatus((IObservableValue)this.componentLocationValidation);
        }
        if (this.locationCombo != null) {
            WorkspaceId initialSnapshot = null;
            if (contextHandle != null && repo != null) {
                if (contextHandle instanceof IWorkspaceHandle) {
                    IWorkspaceHandle wh = (IWorkspaceHandle)contextHandle;
                    initialSnapshot = WorkspaceId.create((ITeamRepository)repo, (IWorkspaceHandle)wh);
                } else if (contextHandle instanceof IBaselineHandle) {
                    IBaselineHandle bh = (IBaselineHandle)contextHandle;
                    initialSnapshot = BaselineId.create((ITeamRepository)repo, (IBaselineHandle)bh);
                }
            }
            if (initialSnapshot == null) {
                if (this.locationCombo.isAnyNodePresent()) {
                    this.locationCombo.selectTheAnyNode();
                } else if (this.locationCombo.isOneNodePresent()) {
                    this.locationCombo.selectTheOneNode();
                }
            } else {
                this.locationCombo.setSelectedSnapshot((SnapshotId)initialSnapshot);
            }
            this.isLocationPresent = true;
            this.locationCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractSearchCriteriaPart.this.locationComboSelectionChanged();
                }
            });
        } else {
            this.isLocationPresent = false;
        }
        if (this.ownerCombo != null) {
            if (ownerId != null && repo != null && !ownerId.isNull()) {
                this.ownerCombo.setRepository(repo);
                this.ownerCombo.setSelection(ownerId);
            } else {
                this.ownerCombo.selectTheAnyNode();
            }
            this.ownerCombo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractSearchCriteriaPart.this.ownerComboSelectionChanged();
                }
            });
        }
        if (this.versionablePicker != null) {
            if (versionableHandle != null && componentHandle != null) {
                SiloedItemId item = SiloedItemId.create((IVersionableHandle)versionableHandle, (IComponentHandle)componentHandle);
                this.versionablePicker.setItem((SiloedItemId<IVersionable>)item);
            }
            this.validationStatus.addStatus(this.versionablePicker.getValidationStatus());
        }
        if (this.maxResultsText != null) {
            String maxResults = this.maxResultsPrefs.get(MAX_RESULTS_PREFS_KEY, "100");
            this.maxResultsText.setText(maxResults);
            this.maxResultsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AbstractSearchCriteriaPart.this.maxResultsModify(e);
                    AbstractSearchCriteriaPart.this.notifySearchCriteriaUpdated();
                }
            });
            this.validationStatus.addStatus((IObservableValue)this.maxResultsValidation);
        }
        this.updateRepository(this.repositoryCombo.getRepository());
    }

    public void repositoryComboSelectionChanged(SelectionChangedEvent event) {
        ITeamRepository repository = this.repositoryCombo.getRepository();
        this.updateRepository(repository);
        this.notifySearchCriteriaUpdated();
    }

    public void updateRepository(ITeamRepository repository) {
        if (this.componentCombo != null) {
            this.componentCombo.setRepository(repository);
        }
        if (this.locationCombo != null) {
            this.locationCombo.setRepository(repository);
        }
        if (this.ownerCombo != null) {
            this.ownerCombo.setRepository(repository);
        }
    }

    public void locationComboSelectionChanged() {
        this.updateComponentValidation();
        this.notifySearchCriteriaUpdated();
    }

    public void updateComponentValidation() {
        if (this.versionablePicker != null) {
            this.versionablePicker.setWorkspace(this.locationCombo.getSelectedSnapshot());
        }
        final ContextWrapper location = this.isLocationPresent ? this.locationCombo.getSelectedLocation() : null;
        final ComponentWrapper componentWrapper = this.componentCombo != null ? this.componentCombo.getComponent() : null;
        if (location == null || componentWrapper == null) {
            this.componentLocationValidation.setValue((Object)Status.OK_STATUS);
            return;
        }
        this.componentLocationValidation.setValue((Object)StatusUtil.newStatus((Object)((Object)this), (int)4, (int)-1163014131, (String)Messages.ChangeSetSearchCriteriaPart_0));
        final Realm realm = this.componentLocationValidation.getRealm();
        this.background.enqueue(Messages.ChangeSetSearchCriteriaPart_validatingSelectionJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ItemId component = componentWrapper.getLocator().getItemId();
                final boolean containsWrapper = location.getComponents(monitor).contains(component);
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (containsWrapper) {
                            AbstractSearchCriteriaPart.this.componentLocationValidation.setValue((Object)Status.OK_STATUS);
                        } else {
                            AbstractSearchCriteriaPart.this.componentLocationValidation.setValue((Object)StatusUtil.newStatus((Object)this, (String)Messages.ChangeSetSearchCriteriaPart_missingComponentErrorMessage));
                        }
                    }
                });
            }
        });
    }

    public void componentComboSelectionChanged() {
        ComponentWrapper selectedComponent = this.componentCombo.getComponent();
        if (this.locationCombo != null) {
            this.locationCombo.setComponent((ItemId<IComponent>)(selectedComponent != null ? selectedComponent.getLocator().getItemId() : ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE)));
        }
        this.updateComponentValidation();
        this.notifySearchCriteriaUpdated();
    }

    public void ownerComboSelectionChanged() {
        this.notifySearchCriteriaUpdated();
    }

    public void maxResultsModify(ModifyEvent event) {
        String text = this.maxResultsText.getText();
        String error = NLS.bind((String)Messages.AbstractSearchCriteriaPart_0, (Object)Messages.AbstractSearchCriteriaPart_2, (Object)Integer.MAX_VALUE);
        try {
            int i = Integer.parseInt(text);
            if (i > 0) {
                this.maxResultsValidation.setValue((Object)Status.OK_STATUS);
                this.maxResultsPrefs.put(MAX_RESULTS_PREFS_KEY, Integer.toString(i));
            } else {
                this.maxResultsValidation.setValue((Object)StatusUtil.newStatus((Object)((Object)this), (String)error));
            }
        }
        catch (NumberFormatException e) {
            this.maxResultsValidation.setValue((Object)StatusUtil.newStatus((Object)((Object)this), (String)error));
        }
    }

    public ITeamRepository getRepository() {
        return this.repositoryCombo.getRepository();
    }

    public T getResult() {
        return null;
    }

    public void addListener(ISearchCriteriaListener listener) {
        if (this.fSearchCriteriaListenerList != null) {
            this.fSearchCriteriaListenerList.add((Object)listener);
        }
    }

    public void removeListener(ISearchCriteriaListener listener) {
        if (this.fSearchCriteriaListenerList != null) {
            this.fSearchCriteriaListenerList.remove((Object)listener);
        }
    }

    protected void notifySearchCriteriaUpdated() {
        if (this.fSearchCriteriaListenerList != null) {
            Object[] listeners = this.fSearchCriteriaListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof ISearchCriteriaListener) {
                    ISearchCriteriaListener listener = (ISearchCriteriaListener)listeners[i];
                    listener.searchCriteriaUpdated();
                }
                ++i;
            }
        }
    }

    public void setEnabled(boolean isEnabled) {
        Text maxResultsText;
        VersionablePicker versionablePicker;
        OwnerSelectionField ownerCombo;
        ComponentCombo componentCombo;
        LocationCombo locationCombo;
        RepositoryCombo repoCombo = this.getRepositoryCombo();
        if (repoCombo != null && !repoCombo.getControl().isDisposed()) {
            repoCombo.setEnabled(isEnabled);
        }
        if ((locationCombo = this.getLocationCombo()) != null && !locationCombo.getControl().isDisposed()) {
            locationCombo.getControl().setEnabled(isEnabled);
        }
        if ((componentCombo = this.getComponentCombo()) != null && !componentCombo.getControl().isDisposed()) {
            componentCombo.getControl().setEnabled(isEnabled);
        }
        if ((ownerCombo = this.getOwnerCombo()) != null && !ownerCombo.getControl().isDisposed()) {
            ownerCombo.getControl().setEnabled(isEnabled);
        }
        if ((versionablePicker = this.getVersionablePicker()) != null && !versionablePicker.getButtonControl().isDisposed()) {
            versionablePicker.setEnabled(isEnabled);
        }
        if ((maxResultsText = this.getMaxResultsText()) != null && !maxResultsText.isDisposed()) {
            maxResultsText.setEnabled(isEnabled);
        }
    }

    protected void dispose() {
        if (this.fSearchCriteriaListenerList != null) {
            this.fSearchCriteriaListenerList.clear();
            this.fSearchCriteriaListenerList = null;
        }
        super.dispose();
    }

    public static interface ISearchCriteriaListener {
        public void searchCriteriaUpdated();
    }
}

