/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.repositoryfiles;

import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.ui.queries.AbstractFilesystemQuery;
import com.ibm.team.filesystem.ui.queries.FolderChildrenQuery;
import com.ibm.team.filesystem.ui.queries.RootChildrenQuery;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepoFilesSnapshotComponentsQuery;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.OptionalTreeLevel;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;

public final class RepositoryFilesViewTreeProvider
implements ITreeProvider {
    private IOperationRunner runner;
    private boolean foldersOnly;
    private boolean skipSingleComponentRoot;
    private boolean showPermissionScope;
    private final AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode;

    private RepositoryFilesViewTreeProvider(IOperationRunner runner, boolean foldersOnly, boolean skipSingleComponentRoot, boolean showPermissionScope, AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode) {
        this.versionDisplayMode = versionDisplayMode;
        this.runner = runner;
        this.foldersOnly = foldersOnly;
        this.skipSingleComponentRoot = skipSingleComponentRoot;
        this.showPermissionScope = showPermissionScope;
    }

    public RepositoryFilesViewTreeProvider(AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode, IOperationRunner runner) {
        this(runner, false, true, true, versionDisplayMode);
    }

    public RepositoryFilesViewTreeProvider(IOperationRunner runner, boolean foldersOnly, boolean skipSingleComponentRoot, boolean showPermissionScope) {
        this(runner, foldersOnly, skipSingleComponentRoot, showPermissionScope, null);
    }

    public ISetWithListeners getChildren(Object element) {
        if (element instanceof ISnapshot) {
            RepoFilesSnapshotComponentsQuery query = new RepoFilesSnapshotComponentsQuery((ISnapshot)element, this.runner);
            if (this.skipSingleComponentRoot) {
                return new OptionalTreeLevel((ISetWithListeners)query, (ITreeProvider)this);
            }
            return query;
        }
        if (element instanceof RepositoryFilesComponentNode) {
            RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)element;
            RootChildrenQuery rootChildrenQuery = new RootChildrenQuery(node.getNamespace(), this.versionDisplayMode, this.runner);
            rootChildrenQuery.setFoldersOnly(this.foldersOnly);
            rootChildrenQuery.showPermissionScope(this.showPermissionScope);
            return rootChildrenQuery;
        }
        if (element instanceof FolderItemWrapper) {
            FolderItemWrapper folder = (FolderItemWrapper)((Object)element);
            FolderChildrenQuery folderChildrenQuery = new FolderChildrenQuery(folder, this.versionDisplayMode, this.runner);
            folderChildrenQuery.setFoldersOnly(this.foldersOnly);
            folderChildrenQuery.showPermissionScope(this.showPermissionScope);
            return folderChildrenQuery;
        }
        return null;
    }
}

