/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.repositoryfiles;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraContext;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetContext;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCacheManager;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.inputs.RepositoryFilesViewInput;
import com.ibm.team.filesystem.ui.queries.AbstractFilesystemQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomSimpleTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.FileItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.SymbolicLinkItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.WorkspaceComponentLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesViewTreeProvider;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.parts.StackLayoutExt;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreePathRunnable;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.LoggedInRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.AbstractViewWithInput;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.events.ILockEvent;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;

public class RepositoryFilesView
extends AbstractViewWithInput {
    private SimpleTreeViewer viewer;
    private AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode;
    private Composite noInputContents;
    private StackLayoutExt layout;
    private LoggedInRunner loggedInRunner;
    private IListener permissionChangeListener;
    private IListener lockListener;
    private IConnection currentConnection;
    private IWorkspaceConnection fCurrentConnectionStreamFlowTarget;
    private final IPropertyChangeListener versionIdentifiersPropertyChangeListener;
    private PushAction refreshAction;
    public static final String FILESYSTEM_VIEW_ID = "com.ibm.team.filesystem.history.FileSystemView";
    private static final Log log = LoggingHelper.getLog(RepositoryFilesView.class);

    public RepositoryFilesView(IPartSite site, Object initialInput) {
        super(site, RepositoryFilesViewInput.class, initialInput);
        IContextMenuHandler cmh = (IContextMenuHandler)Adapters.getAdapter((Object)site, IContextMenuHandler.class);
        if (cmh == null) {
            throw new IllegalArgumentException("This view can only be hosted in a site that supports context menus");
        }
        this.layout = new StackLayoutExt();
        this.loggedInRunner = new LoggedInRunner(site.getOperationRunner());
        site.getParent().setLayout((Layout)this.layout);
        Tree tree = new Tree(site.getParent(), 770);
        this.versionDisplayMode = new AbstractFilesystemQuery.VersionDisplayMode();
        this.getVersionDisplayMode();
        RepositoryFilesViewTreeProvider treeProvider = new RepositoryFilesViewTreeProvider(this.versionDisplayMode, site.getOperationRunner());
        final CustomTreeViewer customTreeViewer = new CustomTreeViewer(tree);
        this.viewer = new CustomSimpleTreeViewer(customTreeViewer, treeProvider).setProgressService((IBusyHandler)site);
        ContextMenuHelper.addNewSubmenu((IMenuManager)this.viewer.getContextMenu(), (boolean)false);
        this.versionIdentifiersPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("pref_show_version_identifiers_repository_files".equals(property) || "pref_show_version_identifiers_repository_id".equals(property)) {
                    RepositoryFilesView.this.getVersionDisplayMode();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!RepositoryFilesView.this.viewer.getControl().isDisposed()) {
                                RepositoryFilesView.this.viewer.refreshExpandedNodes();
                            }
                        }
                    });
                }
            }
        };
        RcpUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        ISetWithListeners knownElements = this.viewer.getKnownElements();
        IDynamicFunction wrapperConversion = RepositoryFilesView.createWrapperConversion(knownElements);
        SimpleTreeViewer treeViewer = this.viewer;
        RepositoryFilesView.makeAutoExpandable(treeViewer);
        ConvertingSelectionProvider selectionProvider = new ConvertingSelectionProvider(this.viewer.getSelectionProvider(), wrapperConversion);
        cmh.registerContextMenu(this.viewer.getContextMenu(), (ISelectionProvider)selectionProvider);
        MixedTypeLabelProvider wrapperLabelProvider = new MixedTypeLabelProvider().put(BaselineWrapper.class, (IViewerLabelProvider)new BaselineLabelProvider(Messages.RepositoryFilesView_0, (ISetWithListeners<BaselineWrapper>)FilteredSetWithListeners.createTypeFilter((ISetWithListeners)wrapperConversion.getRange(), BaselineWrapper.class), site.getOperationRunner())).put(FileItemWrapper.class, (IViewerLabelProvider)new FileItemLabelProvider(true)).put(SymbolicLinkItemWrapper.class, (IViewerLabelProvider)new SymbolicLinkItemLabelProvider(true)).put(WorkspaceComponentWrapper.class, (IViewerLabelProvider)new WorkspaceComponentLabelProvider()).put(Object.class, LabelProviders.create((ISetWithListeners)wrapperConversion.getRange()));
        ConvertingLabelProvider labelProvider = new ConvertingLabelProvider((IViewerLabelProvider)wrapperLabelProvider, wrapperConversion);
        DecoratingLabelProvider decoratedLabelProvider = new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)new LocalSynchronizeDecorator(true));
        customTreeViewer.init(decoratedLabelProvider);
        customTreeViewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection selection = customTreeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                if (selection.isEmpty()) {
                    event.doit = false;
                    return;
                }
                IStructuredSelection s = (IStructuredSelection)selection;
                Object[] elements = s.toArray();
                if (!this.dragPermitted(elements)) {
                    event.doit = false;
                    return;
                }
                LocalSelectionTransfer.getTransfer().setSelection(selection);
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            boolean dragPermitted(Object[] elements) {
                return true;
            }
        });
        this.viewer.setSorter(RepositoryFilesView.createSorter());
        this.viewer.setDoubleClickHandler((ITreePathRunnable)new OpenAction(site.getPage()){

            public void run(TreePath path, Shell targetShell) {
                Object selection = path.getLastSegment();
                if (selection instanceof FolderItemWrapper || selection instanceof RepositoryFilesComponentNode) {
                    RepositoryFilesView.this.viewer.toggleExpandedState(path);
                } else {
                    super.run(selection, targetShell);
                }
            }
        });
        site.setSelectionProvider((ISelectionProvider)selectionProvider);
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = RepositoryFilesView.this.viewer.getSelection();
                String message = null;
                if (selection != null) {
                    int size = selection.size();
                    if (size == 1) {
                        Object firstElement = selection.getFirstElement();
                        if (firstElement instanceof AbstractFileSystemItemWrapper) {
                            AbstractFileSystemItemWrapper fsItem = (AbstractFileSystemItemWrapper)((Object)firstElement);
                            String name = fsItem.getName();
                            Path fqPath = new Path(fsItem.getFQName());
                            message = fqPath.segmentCount() < 2 ? fqPath.lastSegment() : NLS.bind((String)Messages.RepositoryFilesView_singleSelectionStatusLineMessage, (Object)name, (Object)fqPath.removeLastSegments(1).makeRelative().toOSString());
                        }
                    } else {
                        message = NLS.bind((String)Messages.RepositoryFilesView_multiSelectionStatusLineMessage, (Object)size);
                    }
                }
                ((IViewSite)RepositoryFilesView.this.getSite().getPart().getSite()).getActionBars().getStatusLineManager().setMessage(message);
            }
        });
        WidgetToolkit toolkit = site.getToolkit();
        this.noInputContents = toolkit.createComposite(this.getSite().getParent());
        toolkit.createLabel(this.noInputContents, Messages.RepositoryFilesView_emptyViewInstructions, 64);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(this.noInputContents);
        this.permissionChangeListener = new IListener(){

            public void handleEvents(List events) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!RepositoryFilesView.this.viewer.getControl().isDisposed()) {
                            RepositoryFilesView.this.viewer.refreshExpandedNodes();
                        }
                    }
                });
            }
        };
        this.lockListener = new IListener(){

            public void handleEvents(List events) {
                RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): Got %d events", events.size()));
                boolean shouldRefresh = false;
                block0: for (Object object : events) {
                    if (object instanceof ILockEvent) {
                        ILockEvent event = (ILockEvent)object;
                        if (!event.getEventType().equals("com.ibm.team.scm.LockEvent.StreamsLocked")) continue;
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): Got STREAMS_LOCKED", new Object[0]));
                        if (!event.getEventSource().equals(RepositoryFilesView.this.currentConnection) && !event.getEventSource().equals(RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget)) continue;
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): MATCHED STREAMS_LOCKED event with currentConnection %s", RepositoryFilesView.this.currentConnection.getName()));
                        shouldRefresh = true;
                        break;
                    }
                    if (!(object instanceof IPropertyChangeEvent) || ((IPropertyChangeEvent)object).getProperty() != "user_locks") continue;
                    RepositoryFilesView.trace("RepositoryFilesView.lockListener.handleEvents(): Got USER_LOCKS event");
                    IPropertyChangeEvent pce = (IPropertyChangeEvent)object;
                    ArrayList lockReports = new ArrayList();
                    Object oldValue = pce.getOldValue();
                    Object newValue = pce.getNewValue();
                    if (oldValue != null) {
                        lockReports.addAll((List)oldValue);
                    }
                    if (newValue != null) {
                        lockReports.addAll((List)newValue);
                    }
                    RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): Got %d StreamLockReports", lockReports == null ? "0" : Integer.valueOf(lockReports.size())));
                    for (IStreamLockReport lockReport : lockReports) {
                        if (!(RepositoryFilesView.this.currentConnection instanceof IWorkspaceConnection)) continue;
                        IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)RepositoryFilesView.this.currentConnection;
                        RepositoryFilesView.trace("RepositoryFilesView.lockListener.handleEvents(): compare lock report with currentConnection and fCurrentConnectionStreamFlowTarget");
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): lockReport.stream is %s", lockReport.getStream().getItemId().getUuidValue()));
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): currentConnection=%s(%s)", workspaceConnection.getName(), workspaceConnection.getResolvedWorkspace().getItemId().getUuidValue()));
                        if (RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget != null) {
                            RepositoryFilesView.trace(String.format("RepositoryFilesView.lockListener.handleEvents(): fCurrentConnectionStreamFlowTarget=%s(%s)", RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget.getName(), RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget.getResolvedWorkspace().getItemId().getUuidValue()));
                        }
                        if (lockReport.getStream().getItemId().equals((Object)workspaceConnection.getResolvedWorkspace().getItemId())) {
                            RepositoryFilesView.trace(String.format("MATCHED USER_LOCKS with currentConnection(%s)", RepositoryFilesView.this.currentConnection.getName()));
                            shouldRefresh = true;
                            continue block0;
                        }
                        if (RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget != null && lockReport.getStream().getItemId().equals((Object)RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget.getResolvedWorkspace().getItemId())) {
                            RepositoryFilesView.trace(String.format("MATCHED USER_LOCKS with fCurrentConnectionStreamFlowTarget(%s)", RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget.getName()));
                            shouldRefresh = true;
                            continue block0;
                        }
                        RepositoryFilesView.trace("USER_LOCKS NOT a match");
                    }
                }
                if (shouldRefresh) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!RepositoryFilesView.this.viewer.getControl().isDisposed()) {
                                RepositoryFilesView.trace("RepositoryFilesView LockListener: Calling refreshAction");
                                RepositoryFilesView.this.refreshAction.run();
                            }
                        }
                    });
                }
            }
        };
        this.refreshAction = new PushAction(ImagePool.REFRESH_ICON, Messages.RepositoryFilesView_refreshAction, new Runnable(){

            @Override
            public void run() {
                if (RepositoryFilesView.this.currentConnection == null) {
                    RepositoryFilesView.this.viewer.refreshExpandedNodes();
                } else {
                    RepositoryFilesView.this.loggedInRunner.enqueue(RepositoryFilesView.this.currentConnection.teamRepository(), Messages.RepositoryFilesView_pendingText, new Operation(){

                        public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                            long start;
                            block6: {
                                start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
                                RepositoryFilesView.trace("RepositoryFilesView:refreshAction.loggedInRunner.run() starting");
                                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                try {
                                    try {
                                        RepositoryFilesView.this.updateFlowTargetForLocks((IProgressMonitor)progress.newChild(30));
                                        RepositoryFilesView.this.refreshWorkspaceConnectionForLocks((IProgressMonitor)progress.newChild(70));
                                        final String newLabelText = RepositoryFilesView.this.getTitleText();
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                RepositoryFilesView.this.setInputDescription(RepositoryFilesView.this.getInput(), newLabelText);
                                            }
                                        });
                                    }
                                    catch (TeamRepositoryException e) {
                                        StatusUtil.log((Object)this, (Throwable)e);
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (!RepositoryFilesView.this.viewer.getControl().isDisposed()) {
                                                    RepositoryFilesView.trace("RepositoryFilesView.refreshAction.loggedInRunner: Calling viewer.refreshExpandedNodes()");
                                                    RepositoryFilesView.this.viewer.refreshExpandedNodes();
                                                }
                                            }
                                        });
                                        break block6;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            if (Trace.LOG_ELAPSED_TIME) {
                                Trace.endTrace((long)start, (String)(String.valueOf(this.getClass().getName()) + ":refreshAction"));
                            }
                        }
                    });
                }
            }
        });
        this.layout.setCurrent((Control)this.noInputContents);
        this.getControlSite().getParent().layout(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)site.getParent(), "com.ibm.team.filesystem.ide.ui.view_repositoryfiles");
    }

    private void updateFlowTargetForLocks(IProgressMonitor monitor) throws TeamRepositoryException {
        UserLockCacheManager lockManager;
        RepositoryFilesView.trace("RepositoryFilesView.updateFlowTargetForLocks()");
        IWorkspaceConnection oldStream = this.fCurrentConnectionStreamFlowTarget;
        IWorkspaceConnection newStream = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.currentConnection instanceof IWorkspaceConnection) {
            IFlowTable flowTable;
            IFlowEntry deliverTarget;
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)this.currentConnection;
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)workspaceConnection.teamRepository());
            if (!workspaceConnection.isStream() && (deliverTarget = (flowTable = workspaceConnection.getFlowTable()).getCurrentDeliverFlow()) != null) {
                IFlowNodeHandle targetHandle = deliverTarget.getFlowNode();
                try {
                    IWorkspaceConnection targetWorkspace = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)targetHandle, (IProgressMonitor)progress.newChild(100));
                    if (targetWorkspace.isStream()) {
                        newStream = targetWorkspace;
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (oldStream != null && !oldStream.equals(newStream) && (lockManager = UserLockCacheManager.getInstance()) != null) {
            lockManager.removeStreamToTrack(FILESYSTEM_VIEW_ID, oldStream);
            if (newStream != null) {
                lockManager.addStreamToTrack(FILESYSTEM_VIEW_ID, newStream);
            }
        }
        this.fCurrentConnectionStreamFlowTarget = newStream;
        RepositoryFilesView.trace(String.format("%s.%s: Setting fCurrentConnectionStreamFlowTarget to %s(%s)%n", ((Object)((Object)this)).getClass().getSimpleName(), "updateFlowTargetForLocks()", this.fCurrentConnectionStreamFlowTarget == null ? "null" : this.fCurrentConnectionStreamFlowTarget.getName(), this.fCurrentConnectionStreamFlowTarget == null ? "null" : this.fCurrentConnectionStreamFlowTarget.getResolvedWorkspace().getItemId().getUuidValue()));
        progress.done();
    }

    private void refreshWorkspaceConnectionForLocks(IProgressMonitor monitor) throws TeamRepositoryException {
        RepositoryFilesView.trace("RepositoryFilesView.refreshWorkspaceConnectionForLocks()");
        ArrayList<IWorkspaceConnection> connectionsToRefresh = new ArrayList<IWorkspaceConnection>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.currentConnection instanceof IWorkspaceConnection) {
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)this.currentConnection;
            if (workspaceConnection.isStream()) {
                connectionsToRefresh.add(workspaceConnection);
            }
            if (this.fCurrentConnectionStreamFlowTarget != null) {
                connectionsToRefresh.add(this.fCurrentConnectionStreamFlowTarget);
            }
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.currentConnection.teamRepository());
            workspaceManager.refreshWorkspaceConnections(connectionsToRefresh, (IProgressMonitor)progress.newChild(100));
        }
        progress.done();
    }

    private void getVersionDisplayMode() {
        if (!RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_files")) {
            this.versionDisplayMode.setVersionDisplayOpt(AbstractFileSystemItemWrapper.VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO);
        } else if (RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id")) {
            this.versionDisplayMode.setVersionDisplayOpt(AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_ID);
        } else {
            this.versionDisplayMode.setVersionDisplayOpt(AbstractFileSystemItemWrapper.VersionDisplayOption.SHOW_VERSION_NUMBER);
        }
    }

    public static void makeAutoExpandable(final SimpleTreeViewer treeViewer) {
        treeViewer.addExpandListener(new IPartResult(){

            public void setResult(Object result) {
                if (treeViewer.getControl().isDisposed()) {
                    return;
                }
                final ISetWithListeners childrenSet = treeViewer.getKnownChildren(result);
                if (childrenSet == null) {
                    return;
                }
                RepositoryFilesView.whenStable(childrenSet, new Runnable(){

                    @Override
                    public void run() {
                        if (childrenSet.size() == 1) {
                            List paths = treeViewer.getPathsToElement(childrenSet.iterator().next());
                            treeViewer.expand((Collection)paths);
                            for (TreePath next : paths) {
                                this.setResult(next.getLastSegment());
                            }
                        }
                    }
                });
            }
        });
    }

    public static BaseLabelProvider createLabelProvider(ISetWithListeners elements) {
        IDynamicFunction wrapperConversion = RepositoryFilesView.createWrapperConversion(elements);
        return new ConvertingLabelProvider(LabelProviders.create((ISetWithListeners)wrapperConversion.getRange()), wrapperConversion);
    }

    private static IDynamicFunction createWrapperConversion(ISetWithListeners knownElements) {
        ConvertingSet conversion = new ConvertingSet(knownElements, new IConversion(){

            public Object createAdapter(Object source) {
                if (source instanceof RepositoryFilesComponentNode) {
                    RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)source;
                    return node.getWrapper();
                }
                return source;
            }
        }, true);
        return conversion;
    }

    protected static void whenStable(final ISetWithListeners childrenSet, final Runnable runnable) {
        if (!childrenSet.isStale()) {
            childrenSet.getRealm().asyncExec(runnable);
        } else {
            childrenSet.addStaleListener((org.eclipse.core.databinding.observable.IStaleListener)new IStaleListener(){

                public void setStale(Object staleObject, boolean isStale) {
                    if (!isStale) {
                        childrenSet.removeStaleListener((org.eclipse.core.databinding.observable.IStaleListener)this);
                        runnable.run();
                    }
                }
            });
        }
    }

    public static Comparator createSorter() {
        return new MixedTypeComparator().put(FolderItemWrapper.class, (Comparator)new Comparator<FolderItemWrapper>(){

            @Override
            public int compare(FolderItemWrapper o1, FolderItemWrapper o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }).put(FileItemWrapper.class, (Comparator)new Comparator<FileItemWrapper>(){

            @Override
            public int compare(FileItemWrapper o1, FileItemWrapper o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }).put(RepositoryFilesComponentNode.class, (Comparator)new Comparator<RepositoryFilesComponentNode>(){

            @Override
            public int compare(RepositoryFilesComponentNode o1, RepositoryFilesComponentNode o2) {
                IItemContext c1 = o1.getContext();
                IItemContext c2 = o2.getContext();
                Object w1 = o1.getWrapper();
                Object w2 = o2.getWrapper();
                if (w1 instanceof BaselineWrapper && w2 instanceof BaselineWrapper) {
                    BaselineWrapper b1 = (BaselineWrapper)w1;
                    BaselineWrapper b2 = (BaselineWrapper)w2;
                    int compare = b1.getComponent().getName().compareToIgnoreCase(b2.getComponent().getName());
                    if (compare != 0) {
                        return compare;
                    }
                }
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
    }

    public void addMenuEntries(List output) {
        output.add(this.refreshAction);
        super.addMenuEntries(output);
    }

    public void addToolbarEntries(List output) {
        output.add(this.refreshAction);
        super.addToolbarEntries(output);
    }

    protected void inputCleared() {
        this.layout.setCurrent((Control)this.noInputContents);
        this.getControlSite().getParent().layout(false);
        super.inputCleared();
    }

    public void inputChanged(Object newInput) {
        RepositoryFilesView.trace("RepositoryFilesView.inputChanged()");
        this.layout.setCurrent(this.viewer.getControl());
        this.getControlSite().getParent().layout(false);
        RepositoryFilesViewInput input = (RepositoryFilesViewInput)newInput;
        SnapshotId namespace = input.getSnapshot();
        Object theInput = this.getInput();
        final Display d = Display.getCurrent();
        Composite c = this.getControlSite().getParent();
        this.unregisterLockCacheListeners();
        this.loggedInRunner.cancelAll();
        this.loggedInRunner.enqueue(input.getSnapshot().getRepository(), Messages.RepositoryFilesView_fetchingConfigurationJobName, new Operation((Control)c, namespace, theInput){
            private final /* synthetic */ Control val$c;
            private final /* synthetic */ SnapshotId val$namespace;
            private final /* synthetic */ Object val$theInput;
            {
                this.val$c = control;
                this.val$namespace = snapshotId;
                this.val$theInput = object;
            }

            public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                ISnapshot snapshot;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
                SWTUtil.greedyExec((Display)d, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RepositoryFilesView.this.setInputDescription(val$theInput, Messages.RepositoryFilesView_pendingText);
                    }
                });
                try {
                    if (RepositoryFilesView.this.currentConnection != null) {
                        RepositoryFilesView.this.currentConnection.removeGenericListener((Object)"item_permission_change_event", RepositoryFilesView.this.permissionChangeListener);
                        RepositoryFilesView.this.currentConnection.removeGenericListener((Object)"com.ibm.team.scm.LockEvent.StreamsLocked", RepositoryFilesView.this.lockListener);
                        SCMPlatform.getWorkspaceManager((ITeamRepository)RepositoryFilesView.this.currentConnection.teamRepository()).removeGenericListener((Object)"item_permission_change_event", RepositoryFilesView.this.permissionChangeListener);
                        SCMPlatform.getWorkspaceManager((ITeamRepository)RepositoryFilesView.this.currentConnection.teamRepository()).removeGenericListener((Object)"user_locks", RepositoryFilesView.this.lockListener);
                    }
                    snapshot = this.val$namespace.getSnapshot((IProgressMonitor)progress.newChild(25));
                    IConnection connection = this.val$namespace.getConnection((IProgressMonitor)progress.newChild(25));
                    if (connection != null) {
                        connection.addGenericListener((Object)"item_permission_change_event", RepositoryFilesView.this.permissionChangeListener);
                        connection.addGenericListener((Object)"com.ibm.team.scm.LockEvent.StreamsLocked", RepositoryFilesView.this.lockListener);
                        RepositoryFilesView.trace(String.format("%s:inputChanged(): addGenericListener() for STREAMS_LOCKED for workspace connection %s", this.getClass().getName(), connection.getName()));
                        SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).addGenericListener((Object)"user_locks", RepositoryFilesView.this.lockListener);
                        RepositoryFilesView.trace(String.format("%s:inputChanged(): addGenericListener() for USER_LOCKS for workspace manager %s", this.getClass().getName(), SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).toString()));
                    }
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)snapshot.getRepository());
                    wm.addGenericListener((Object)"item_permission_change_event", RepositoryFilesView.this.permissionChangeListener);
                    RepositoryFilesView.this.currentConnection = connection;
                    if (RepositoryFilesView.this.currentConnection != null) {
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.inputChanged().loggedInRunner.run(): %s(%s)", RepositoryFilesView.this.currentConnection.getName(), RepositoryFilesView.this.currentConnection.getContextHandle().getItemId()));
                    } else {
                        RepositoryFilesView.trace("RepositoryFilesView.inputChanged().loggedInRunner.run(): no current connection");
                    }
                    RepositoryFilesView.this.updateFlowTargetForLocks((IProgressMonitor)progress.newChild(10));
                    RepositoryFilesView.this.registerLockCacheListeners();
                    if (RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget != null) {
                        RepositoryFilesView.trace(String.format("RepositoryFilesView.inputChanged().loggedInRunner.run(): addGenericListener(STREAMS_LOCKED), fCurrentConnectionStreamFlowTarget = ", RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget));
                        RepositoryFilesView.this.fCurrentConnectionStreamFlowTarget.addGenericListener((Object)"com.ibm.team.scm.LockEvent.StreamsLocked", RepositoryFilesView.this.lockListener);
                    }
                    RepositoryFilesView.this.refreshWorkspaceConnectionForLocks((IProgressMonitor)progress.newChild(40));
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
                SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (val$theInput == RepositoryFilesView.this.getInput()) {
                            String labelText = RepositoryFilesView.this.getTitleText(snapshot);
                            RepositoryFilesView.this.setInputDescription(val$theInput, labelText);
                        }
                        RepositoryFilesView.this.viewer.setInput((Object)snapshot);
                    }
                });
            }
        });
    }

    private String getTitleText() throws TeamRepositoryException {
        RepositoryFilesViewInput input = (RepositoryFilesViewInput)this.getInput();
        if (input != null) {
            SnapshotId namespace = input.getSnapshot();
            ISnapshot snapshot = namespace.getSnapshot(null);
            return this.getTitleText(snapshot);
        }
        return "";
    }

    private String getTitleText(ISnapshot snapshot) {
        String label = snapshot.getName();
        if (snapshot instanceof NamespaceSetContext && ((NamespaceSetContext)snapshot).getOnlyContext() instanceof EraContext) {
            label = "";
        }
        if (this.currentConnection != null && this.currentConnection instanceof IWorkspaceConnection) {
            IWorkspaceConnection connection = (IWorkspaceConnection)this.currentConnection;
            if (connection.isLockedByMe()) {
                label = NLS.bind((String)Messages.RepositoryFilesView_streamLockedByMeTitleDecorator, (Object)label);
            } else if (connection.isLocked()) {
                label = NLS.bind((String)Messages.RepositoryFilesView_streamLockedByOtherTitleDecorator, (Object)label, (Object)connection.getLockOwnerName());
            }
        }
        return label;
    }

    public void registerLockCacheListeners() {
        UserLockCacheManager lockManager = UserLockCacheManager.getInstance();
        if (lockManager != null) {
            IWorkspaceConnection wc;
            if (this.currentConnection instanceof IWorkspaceConnection && (wc = (IWorkspaceConnection)this.currentConnection).isStream()) {
                lockManager.addStreamToTrack(FILESYSTEM_VIEW_ID, wc);
            }
            if (this.fCurrentConnectionStreamFlowTarget != null && this.fCurrentConnectionStreamFlowTarget.isStream()) {
                lockManager.addStreamToTrack(FILESYSTEM_VIEW_ID, this.fCurrentConnectionStreamFlowTarget);
            }
        }
    }

    private void unregisterLockCacheListeners() {
        UserLockCacheManager lockManager = UserLockCacheManager.getInstance();
        if (lockManager != null) {
            IWorkspaceConnection wc;
            if (this.currentConnection instanceof IWorkspaceConnection && (wc = (IWorkspaceConnection)this.currentConnection).isStream()) {
                lockManager.removeStreamToTrack(FILESYSTEM_VIEW_ID, wc);
            }
            if (this.fCurrentConnectionStreamFlowTarget != null && this.fCurrentConnectionStreamFlowTarget.isStream()) {
                lockManager.removeStreamToTrack(FILESYSTEM_VIEW_ID, this.fCurrentConnectionStreamFlowTarget);
            }
        }
    }

    public void dispose() {
        this.loggedInRunner.dispose();
        RcpUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        this.unregisterLockCacheListeners();
        if (this.currentConnection != null) {
            this.currentConnection.removeGenericListener((Object)"item_permission_change_event", this.permissionChangeListener);
            this.currentConnection.removeGenericListener((Object)"com.ibm.team.scm.LockEvent.StreamsLocked", this.lockListener);
            SCMPlatform.getWorkspaceManager((ITeamRepository)this.currentConnection.teamRepository()).removeGenericListener((Object)"user_locks", this.lockListener);
            SCMPlatform.getWorkspaceManager((ITeamRepository)this.currentConnection.teamRepository()).removeGenericListener((Object)"item_permission_change_event", this.permissionChangeListener);
        }
        super.dispose();
    }

    private static void trace(String message) {
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)message);
        }
    }
}

