/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.repositoryfiles;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RepoFilesSnapshotComponentsQuery
extends RepositoryQuery<RepositoryFilesComponentNode> {
    private ISnapshot snapshot;
    private IChangeListener changeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            RepoFilesSnapshotComponentsQuery.this.update();
        }
    };

    public RepoFilesSnapshotComponentsQuery(ISnapshot snapshot, IOperationRunner runner) {
        super(snapshot.getRepository(), runner);
        this.snapshot = snapshot;
    }

    protected void attachListeners() {
        this.snapshot.addChangeListener(this.changeListener);
    }

    protected void detachListeners() {
        this.snapshot.removeChangeListener(this.changeListener);
    }

    protected List<RepositoryFilesComponentNode> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (needsRefresh) {
            this.snapshot.refresh((IProgressMonitor)progress.newChild(20));
        }
        progress.setWorkRemaining(80);
        Map contexts = this.snapshot.getContexts((IProgressMonitor)progress.newChild(40));
        HashSet<ItemNamespace> namespaces = new HashSet<ItemNamespace>();
        for (IItemContext next : contexts.values()) {
            namespaces.add(next.getNamespace());
        }
        Map<ItemNamespace, Object> wrappers = WrapperUtil.createWrapperFromNamespace(namespaces, (IProgressMonitor)progress.newChild(40));
        ArrayList<RepositoryFilesComponentNode> result = new ArrayList<RepositoryFilesComponentNode>();
        for (IItemContext next : contexts.values()) {
            ItemNamespace namespace = next.getNamespace();
            Object uiWrapper = wrappers.get(namespace);
            if (!(uiWrapper instanceof AbstractWrapper)) continue;
            result.add(new RepositoryFilesComponentNode(next, uiWrapper));
        }
        return result;
    }

    public String getName() {
        return NLS.bind((String)Messages.SnapshotComponentsQuery_queryName, (Object)this.snapshot.getName());
    }
}

